/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.JsonKafkaPostProcessorConfig;
import org.apache.hudi.utilities.exception.HoodieSourcePostProcessException;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.KafkaSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.hudi.utilities.sources.processor.JsonKafkaSourcePostProcessor;
import org.apache.hudi.utilities.streamer.DefaultStreamContext;
import org.apache.hudi.utilities.streamer.StreamContext;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.OffsetRange;

public class JsonKafkaSource
extends KafkaSource<JavaRDD<String>> {
    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieIngestionMetrics metrics) {
        this(properties, sparkContext, sparkSession, metrics, (StreamContext)new DefaultStreamContext(schemaProvider, Option.empty()));
    }

    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, HoodieIngestionMetrics metrics, StreamContext streamContext) {
        super(properties, sparkContext, sparkSession, Source.SourceType.JSON, metrics, new DefaultStreamContext(UtilHelpers.getSchemaProviderForKafkaSource(streamContext.getSchemaProvider(), properties, sparkContext), streamContext.getSourceProfileSupplier()));
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", StringDeserializer.class.getName());
        this.offsetGen = new KafkaOffsetGen(this.props);
    }

    @Override
    protected JavaRDD<String> toBatch(OffsetRange[] offsetRanges) {
        JavaRDD kafkaRDD = KafkaUtils.createRDD(this.sparkContext, this.offsetGen.getKafkaParams(), offsetRanges, LocationStrategies.PreferConsistent()).filter((Function & Serializable)x -> !StringUtils.isNullOrEmpty((String)x.value()));
        return this.postProcess(this.maybeAppendKafkaOffsets((JavaRDD<ConsumerRecord<Object, Object>>)kafkaRDD));
    }

    protected JavaRDD<String> maybeAppendKafkaOffsets(JavaRDD<ConsumerRecord<Object, Object>> kafkaRDD) {
        if (this.shouldAddOffsets) {
            return kafkaRDD.mapPartitions((FlatMapFunction & Serializable)partitionIterator -> {
                ObjectMapper objectMapper = new ObjectMapper();
                return new CloseableMappingIterator<ConsumerRecord, String>(ClosableIterator.wrap(partitionIterator), consumerRecord -> {
                    String recordValue = consumerRecord.value().toString();
                    String recordKey = StringUtils.objToString(consumerRecord.key());
                    try {
                        ObjectNode jsonNode = (ObjectNode)objectMapper.readTree(recordValue);
                        jsonNode.put("_hoodie_kafka_source_offset", consumerRecord.offset());
                        jsonNode.put("_hoodie_kafka_source_partition", consumerRecord.partition());
                        jsonNode.put("_hoodie_kafka_source_timestamp", consumerRecord.timestamp());
                        if (recordKey != null) {
                            jsonNode.put("_hoodie_kafka_source_key", recordKey);
                        }
                        return objectMapper.writeValueAsString((Object)jsonNode);
                    }
                    catch (Throwable e) {
                        return recordValue;
                    }
                });
            });
        }
        return kafkaRDD.map((Function & Serializable)consumerRecord -> (String)consumerRecord.value());
    }

    private JavaRDD<String> postProcess(JavaRDD<String> jsonStringRDD) {
        JsonKafkaSourcePostProcessor processor;
        String postProcessorClassName = ConfigUtils.getStringWithAltKeys(this.props, JsonKafkaPostProcessorConfig.JSON_KAFKA_PROCESSOR_CLASS, true);
        if (StringUtils.isNullOrEmpty(postProcessorClassName)) {
            return jsonStringRDD;
        }
        try {
            processor = UtilHelpers.createJsonKafkaSourcePostProcessor(postProcessorClassName, this.props);
        }
        catch (IOException e) {
            throw new HoodieSourcePostProcessException("Could not init " + postProcessorClassName, e);
        }
        return processor.process(jsonStringRDD);
    }
}

