/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public class CloudObjectIncrCheckpoint {
    private final String commit;
    private final String key;

    public CloudObjectIncrCheckpoint(String commit, String key) {
        this.commit = commit;
        this.key = key;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getKey() {
        return this.key;
    }

    public static CloudObjectIncrCheckpoint fromString(Option<String> lastCheckpoint) {
        if (lastCheckpoint.isPresent()) {
            Option<String[]> splitResult = lastCheckpoint.map(str -> str.split("#", 2));
            if (splitResult.isPresent() && splitResult.get().length == 2) {
                String[] split = splitResult.get();
                return new CloudObjectIncrCheckpoint(split[0], split[1]);
            }
            return new CloudObjectIncrCheckpoint(lastCheckpoint.get(), null);
        }
        return new CloudObjectIncrCheckpoint("00000000000000", null);
    }

    public String toString() {
        if (StringUtils.isNullOrEmpty(this.commit) && StringUtils.isNullOrEmpty(this.key)) {
            return "00000000000000";
        }
        if (StringUtils.isNullOrEmpty(this.key)) {
            return this.commit;
        }
        return this.commit + "#" + this.key;
    }
}

