/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SanitizationUtils {
    private static final ObjectMapper OM = new ObjectMapper();
    private static final String AVRO_FIELD_NAME_KEY = "name";

    public static boolean shouldSanitize(TypedProperties props) {
        return ConfigUtils.getBooleanWithAltKeys(props, HoodieStreamerConfig.SANITIZE_SCHEMA_FIELD_NAMES);
    }

    public static String getInvalidCharMask(TypedProperties props) {
        return ConfigUtils.getStringWithAltKeys(props, HoodieStreamerConfig.SCHEMA_FIELD_NAME_INVALID_CHAR_MASK, true);
    }

    private static DataType sanitizeDataTypeForAvro(DataType dataType, String invalidCharMask) {
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType sanitizedDataType = SanitizationUtils.sanitizeDataTypeForAvro(arrayType.elementType(), invalidCharMask);
            return new ArrayType(sanitizedDataType, arrayType.containsNull());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType sanitizedKeyDataType = SanitizationUtils.sanitizeDataTypeForAvro(mapType.keyType(), invalidCharMask);
            DataType sanitizedValueDataType = SanitizationUtils.sanitizeDataTypeForAvro(mapType.valueType(), invalidCharMask);
            return new MapType(sanitizedKeyDataType, sanitizedValueDataType, mapType.valueContainsNull());
        }
        if (dataType instanceof StructType) {
            return SanitizationUtils.sanitizeStructTypeForAvro((StructType)dataType, invalidCharMask);
        }
        return dataType;
    }

    private static StructType sanitizeStructTypeForAvro(StructType structType, String invalidCharMask) {
        StructField[] structFields;
        StructType sanitizedStructType = new StructType();
        for (StructField s : structFields = structType.fields()) {
            DataType currFieldDataTypeSanitized = SanitizationUtils.sanitizeDataTypeForAvro(s.dataType(), invalidCharMask);
            StructField structFieldCopy = new StructField(HoodieAvroUtils.sanitizeName(s.name(), invalidCharMask), currFieldDataTypeSanitized, s.nullable(), s.metadata());
            sanitizedStructType = sanitizedStructType.add(structFieldCopy);
        }
        return sanitizedStructType;
    }

    public static Dataset<Row> sanitizeColumnNamesForAvro(Dataset<Row> inputDataset, String invalidCharMask) {
        StructField[] inputFields = inputDataset.schema().fields();
        Dataset targetDataset = inputDataset;
        for (StructField sf : inputFields) {
            DataType sanitizedFieldDataType = SanitizationUtils.sanitizeDataTypeForAvro(sf.dataType(), invalidCharMask);
            if (!sanitizedFieldDataType.equals(sf.dataType())) {
                targetDataset = targetDataset.withColumn(sf.name(), targetDataset.col(sf.name()).cast(sanitizedFieldDataType));
            }
            String possibleRename = HoodieAvroUtils.sanitizeName(sf.name(), invalidCharMask);
            if (sf.name().equals(possibleRename)) continue;
            targetDataset = targetDataset.withColumnRenamed(sf.name(), possibleRename);
        }
        return targetDataset;
    }

    public static Dataset<Row> sanitizeColumnNamesForAvro(Dataset<Row> inputDataset, TypedProperties props) {
        return SanitizationUtils.shouldSanitize(props) ? SanitizationUtils.sanitizeColumnNamesForAvro(inputDataset, SanitizationUtils.getInvalidCharMask(props)) : inputDataset;
    }

    public static Schema parseAvroSchema(String schemaStr, boolean shouldSanitize, String invalidCharMask) {
        try {
            return new Schema.Parser().parse(schemaStr);
        }
        catch (SchemaParseException spe) {
            if (!shouldSanitize) {
                throw spe;
            }
            Option<Schema> parseResult = SanitizationUtils.parseSanitizedAvroSchemaNoThrow(schemaStr, invalidCharMask);
            if (!parseResult.isPresent()) {
                throw spe;
            }
            return parseResult.get();
        }
    }

    private static List<Object> transformList(List<Object> src, String invalidCharMask) {
        return src.stream().map(obj -> {
            if (obj instanceof List) {
                return SanitizationUtils.transformList((List)obj, invalidCharMask);
            }
            if (obj instanceof Map) {
                return SanitizationUtils.transformMap((Map)obj, invalidCharMask);
            }
            return obj;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> transformMap(Map<String, Object> src, String invalidCharMask) {
        return src.entrySet().stream().map(kv -> {
            if (kv.getValue() instanceof List) {
                return Pair.of(kv.getKey(), SanitizationUtils.transformList((List)kv.getValue(), invalidCharMask));
            }
            if (kv.getValue() instanceof Map) {
                return Pair.of(kv.getKey(), SanitizationUtils.transformMap((Map)kv.getValue(), invalidCharMask));
            }
            if (kv.getValue() instanceof String) {
                String currentStrValue = (String)kv.getValue();
                if (((String)kv.getKey()).equals(AVRO_FIELD_NAME_KEY)) {
                    return Pair.of(kv.getKey(), HoodieAvroUtils.sanitizeName(currentStrValue, invalidCharMask));
                }
                return Pair.of(kv.getKey(), currentStrValue);
            }
            return Pair.of(kv.getKey(), kv.getValue());
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static Option<Schema> parseSanitizedAvroSchemaNoThrow(String schemaStr, String invalidCharMask) {
        try {
            OM.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
            Map objMap = (Map)OM.readValue(schemaStr, Map.class);
            Map<String, Object> modifiedMap = SanitizationUtils.transformMap(objMap, invalidCharMask);
            return Option.of(new Schema.Parser().parse(OM.writeValueAsString(modifiedMap)));
        }
        catch (Exception ex) {
            return Option.empty();
        }
    }

    @Deprecated
    public static class Config {
        @Deprecated
        public static final ConfigProperty<Boolean> SANITIZE_SCHEMA_FIELD_NAMES = HoodieStreamerConfig.SANITIZE_SCHEMA_FIELD_NAMES;
        @Deprecated
        public static final ConfigProperty<String> SCHEMA_FIELD_NAME_INVALID_CHAR_MASK = HoodieStreamerConfig.SCHEMA_FIELD_NAME_INVALID_CHAR_MASK;
    }
}

