/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.UUID;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.utilities.config.SqlTransformerConfig;
import org.apache.hudi.utilities.exception.HoodieTransformException;
import org.apache.hudi.utilities.exception.HoodieTransformExecutionException;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQueryBasedTransformer
implements Transformer {
    private static final Logger LOG = LoggerFactory.getLogger(SqlQueryBasedTransformer.class);
    private static final String SRC_PATTERN = "<SRC>";
    private static final String TMP_TABLE = "HOODIE_SRC_TMP_TABLE_";

    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        String transformerSQL = ConfigUtils.getStringWithAltKeys(properties, SqlTransformerConfig.TRANSFORMER_SQL);
        if (null == transformerSQL) {
            throw new HoodieTransformException("Missing configuration : (" + SqlTransformerConfig.TRANSFORMER_SQL.key() + ")");
        }
        try {
            String tmpTable = TMP_TABLE.concat(UUID.randomUUID().toString().replace("-", "_"));
            LOG.info("Registering tmp table : " + tmpTable);
            rowDataset.createOrReplaceTempView(tmpTable);
            String sqlStr = transformerSQL.replaceAll(SRC_PATTERN, tmpTable);
            LOG.debug("SQL Query for transformation : (" + sqlStr + ")");
            Dataset transformed = sparkSession.sql(sqlStr);
            sparkSession.catalog().dropTempView(tmpTable);
            return transformed;
        }
        catch (Exception e) {
            throw new HoodieTransformExecutionException("Failed to apply sql query based transformer", e);
        }
    }
}

