/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.compression;

import io.javalin.core.compression.CompressionStrategy;
import io.javalin.core.compression.CompressionType;
import io.javalin.core.compression.LeveledBrotliStream;
import io.javalin.core.compression.LeveledGzipStream;
import io.javalin.http.Context;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/javalin/core/compression/CompressedStream;", "", "type", "Lio/javalin/core/compression/CompressionType;", "outputStream", "Ljava/io/OutputStream;", "(Lio/javalin/core/compression/CompressionType;Ljava/io/OutputStream;)V", "getOutputStream", "()Ljava/io/OutputStream;", "getType", "()Lio/javalin/core/compression/CompressionType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "javalin"})
public final class CompressedStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompressionType type;
    @NotNull
    private final OutputStream outputStream;

    public CompressedStream(@NotNull CompressionType type2, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        this.type = type2;
        this.outputStream = outputStream;
    }

    @NotNull
    public final CompressionType getType() {
        return this.type;
    }

    @NotNull
    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    @NotNull
    public final CompressionType component1() {
        return this.type;
    }

    @NotNull
    public final OutputStream component2() {
        return this.outputStream;
    }

    @NotNull
    public final CompressedStream copy(@NotNull CompressionType type2, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        return new CompressedStream(type2, outputStream);
    }

    public static /* synthetic */ CompressedStream copy$default(CompressedStream compressedStream, CompressionType compressionType, OutputStream outputStream, int n, Object object) {
        if ((n & 1) != 0) {
            compressionType = compressedStream.type;
        }
        if ((n & 2) != 0) {
            outputStream = compressedStream.outputStream;
        }
        return compressedStream.copy(compressionType, outputStream);
    }

    @NotNull
    public String toString() {
        return "CompressedStream(type=" + (Object)((Object)this.type) + ", outputStream=" + this.outputStream + ')';
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + this.outputStream.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompressedStream)) {
            return false;
        }
        CompressedStream compressedStream = (CompressedStream)other;
        if (this.type != compressedStream.type) {
            return false;
        }
        return Intrinsics.areEqual(this.outputStream, compressedStream.outputStream);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lio/javalin/core/compression/CompressedStream$Companion;", "", "()V", "tryBrotli", "Lio/javalin/core/compression/CompressedStream;", "compression", "Lio/javalin/core/compression/CompressionStrategy;", "ctx", "Lio/javalin/http/Context;", "tryGzip", "javalin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CompressedStream tryBrotli(@NotNull CompressionStrategy compression, @NotNull Context ctx) {
            CompressedStream compressedStream;
            String string;
            Intrinsics.checkNotNullParameter(compression, "compression");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            if (compression.getBrotli() != null && ((string = ctx.header("Accept-Encoding")) == null ? false : StringsKt.contains((CharSequence)string, CompressionType.BR.getTypeName(), true))) {
                string = ctx.res.getOutputStream();
                Intrinsics.checkNotNullExpressionValue(string, "ctx.res.outputStream");
                CompressedStream compressedStream2 = new CompressedStream(CompressionType.BR, (OutputStream)((Object)new LeveledBrotliStream((OutputStream)((Object)string), compression.getBrotli().getLevel())));
                compressedStream = compressedStream2;
            } else {
                compressedStream = null;
            }
            return compressedStream;
        }

        @Nullable
        public final CompressedStream tryGzip(@NotNull CompressionStrategy compression, @NotNull Context ctx) {
            CompressedStream compressedStream;
            String string;
            Intrinsics.checkNotNullParameter(compression, "compression");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            if (compression.getGzip() != null && ((string = ctx.header("Accept-Encoding")) == null ? false : StringsKt.contains((CharSequence)string, CompressionType.GZIP.getTypeName(), true))) {
                string = ctx.res.getOutputStream();
                Intrinsics.checkNotNullExpressionValue(string, "ctx.res.outputStream");
                CompressedStream compressedStream2 = new CompressedStream(CompressionType.GZIP, new LeveledGzipStream((OutputStream)((Object)string), compression.getGzip().getLevel()));
                compressedStream = compressedStream2;
            } else {
                compressedStream = null;
            }
            return compressedStream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

