/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.atomic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.atomic.AtomicStats;
import org.apache.curator.framework.recipes.atomic.AtomicValue;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicNumber;
import org.apache.curator.framework.recipes.atomic.DistributedAtomicValue;
import org.apache.curator.framework.recipes.atomic.MakeValue;
import org.apache.curator.framework.recipes.atomic.PromotedToLock;

public class DistributedAtomicInteger
implements DistributedAtomicNumber<Integer> {
    private final DistributedAtomicValue value;

    public DistributedAtomicInteger(CuratorFramework client, String counterPath, RetryPolicy retryPolicy) {
        this(client, counterPath, retryPolicy, null);
    }

    public DistributedAtomicInteger(CuratorFramework client, String counterPath, RetryPolicy retryPolicy, PromotedToLock promotedToLock) {
        this.value = new DistributedAtomicValue(client, counterPath, retryPolicy, promotedToLock);
    }

    @Override
    public AtomicValue<Integer> get() throws Exception {
        return new AtomicInteger(this.value.get());
    }

    @Override
    public void forceSet(Integer newValue) throws Exception {
        this.value.forceSet(this.valueToBytes(newValue));
    }

    @Override
    public AtomicValue<Integer> compareAndSet(Integer expectedValue, Integer newValue) throws Exception {
        return new AtomicInteger(this.value.compareAndSet(this.valueToBytes(expectedValue), this.valueToBytes(newValue)));
    }

    @Override
    public AtomicValue<Integer> trySet(Integer newValue) throws Exception {
        return new AtomicInteger(this.value.trySet(this.valueToBytes(newValue)));
    }

    @Override
    public boolean initialize(Integer initialize2) throws Exception {
        return this.value.initialize(this.valueToBytes(initialize2));
    }

    @Override
    public AtomicValue<Integer> increment() throws Exception {
        return this.worker(1);
    }

    @Override
    public AtomicValue<Integer> decrement() throws Exception {
        return this.worker(-1);
    }

    @Override
    public AtomicValue<Integer> add(Integer delta) throws Exception {
        return this.worker(delta);
    }

    @Override
    public AtomicValue<Integer> subtract(Integer delta) throws Exception {
        return this.worker(-1 * delta);
    }

    @VisibleForTesting
    byte[] valueToBytes(Integer newValue) {
        Preconditions.checkNotNull((Object)newValue, (Object)"newValue cannot be null");
        byte[] newData = new byte[4];
        ByteBuffer wrapper = ByteBuffer.wrap(newData);
        wrapper.putInt(newValue);
        return newData;
    }

    @VisibleForTesting
    int bytesToValue(byte[] data2) {
        if (data2 == null || data2.length == 0) {
            return 0;
        }
        ByteBuffer wrapper = ByteBuffer.wrap(data2);
        try {
            return wrapper.getInt();
        }
        catch (BufferUnderflowException e) {
            throw this.value.createCorruptionException(data2);
        }
        catch (BufferOverflowException e) {
            throw this.value.createCorruptionException(data2);
        }
    }

    private AtomicValue<Integer> worker(final Integer addAmount) throws Exception {
        Preconditions.checkNotNull((Object)addAmount, (Object)"addAmount cannot be null");
        MakeValue makeValue = new MakeValue(){

            @Override
            public byte[] makeFrom(byte[] previous) {
                int previousValue = previous != null ? DistributedAtomicInteger.this.bytesToValue(previous) : 0;
                int newValue = previousValue + addAmount;
                return DistributedAtomicInteger.this.valueToBytes(newValue);
            }
        };
        AtomicValue<byte[]> result2 = this.value.trySet(makeValue);
        return new AtomicInteger(result2);
    }

    private class AtomicInteger
    implements AtomicValue<Integer> {
        private AtomicValue<byte[]> bytes;

        private AtomicInteger(AtomicValue<byte[]> bytes) {
            this.bytes = bytes;
        }

        @Override
        public boolean succeeded() {
            return this.bytes.succeeded();
        }

        @Override
        public Integer preValue() {
            return DistributedAtomicInteger.this.bytesToValue(this.bytes.preValue());
        }

        @Override
        public Integer postValue() {
            return DistributedAtomicInteger.this.bytesToValue(this.bytes.postValue());
        }

        @Override
        public AtomicStats getStats() {
            return this.bytes.getStats();
        }
    }
}

