/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public Function1<GenericRecord, Option<InternalRow>> createAvroToInternalRowConverter(Schema rootAvroType, StructType rootCatalystType) {
        HoodieAvroDeserializer deserializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(rootAvroType, (DataType)rootCatalystType);
        return (Function1 & Serializable & scala.Serializable)record -> deserializer.deserialize(record).map((Function1 & Serializable & scala.Serializable)x$1 -> (InternalRow)x$1);
    }

    public Function1<InternalRow, GenericRecord> createInternalRowToAvroConverter(StructType rootCatalystType, Schema rootAvroType, boolean nullable) {
        HoodieAvroSerializer serializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroSerializer((DataType)rootCatalystType, rootAvroType, nullable);
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericRecord genericRecord;
            try {
                genericRecord = (GenericRecord)serializer.serialize(row);
            }
            catch (HoodieSchemaException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new SchemaCompatibilityException("Failed to convert spark record into avro record", e);
            }
            return genericRecord;
        };
    }

    @Deprecated
    public Function1<GenericRecord, Row> createConverterToRow(Schema sourceAvroSchema, StructType targetSqlType) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(targetSqlType);
        Function1<GenericRecord, Option<InternalRow>> converter = this.createAvroToInternalRowConverter(sourceAvroSchema, targetSqlType);
        return (Function1 & Serializable & scala.Serializable)avro -> (Row)((Option)converter.apply(avro)).map((Function1 & Serializable & scala.Serializable)internalRow -> serde.deserializeRow((InternalRow)internalRow)).get();
    }

    @Deprecated
    public Function1<Row, GenericRecord> createConverterToAvro(StructType sourceSqlType, String structName, String recordNamespace) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(sourceSqlType);
        Schema avroSchema = this.convertStructTypeToAvroSchema((DataType)sourceSqlType, structName, recordNamespace);
        Schema schema = AvroSchemaUtils.resolveNullableSchema(avroSchema);
        Schema schema2 = avroSchema;
        boolean nullable = schema == null ? schema2 != null : !schema.equals(schema2);
        Function1<InternalRow, GenericRecord> converter = this.createInternalRowToAvroConverter(sourceSqlType, avroSchema, nullable);
        return (Function1 & Serializable & scala.Serializable)row -> (GenericRecord)converter.apply((Object)serde.serializeRow((Row)row));
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return ss.createDataFrame(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)records -> {
            if (records.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            Schema schema = new Schema.Parser().parse(schemaStr);
            StructType dataType = MODULE$.convertAvroSchemaToStructType(schema);
            Function1<GenericRecord, Row> converter = MODULE$.createConverterToRow(schema, dataType);
            return records.map((Function1 & Serializable & scala.Serializable)r -> (Row)converter.apply(r));
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String qualifiedName2) {
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName2)).split('.');
        Tuple2 tuple2 = new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).init())).mkString("."), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String namespace = (String)tuple2._1();
        String name2 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)namespace, (Object)name2);
        String namespace2 = (String)tuple22._1();
        String name3 = (String)tuple22._2();
        return this.convertStructTypeToAvroSchema(structType, name3, namespace2);
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String structName, String recordNamespace) {
        Schema schema;
        try {
            HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
            Schema avroSchema = schemaConverters.toAvroType(structType, false, structName, recordNamespace);
            schema = this.getAvroSchemaWithDefaults(avroSchema, structType);
        }
        catch (AvroRuntimeException a) {
            throw new HoodieSchemaException(a.getMessage(), a);
        }
        catch (Exception e) {
            throw new HoodieSchemaException(new StringBuilder(46).append("Failed to convert struct type to avro schema: ").append(structType).toString(), e);
        }
        return schema;
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        StructType structType;
        try {
            HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
            Tuple2<DataType, Object> tuple2 = schemaConverters.toSqlType(avroSchema);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            DataType dataType = (DataType)tuple2._1();
            structType = (StructType)dataType;
        }
        catch (Exception e) {
            throw new HoodieSchemaException(new StringBuilder(46).append("Failed to convert avro schema to struct type: ").append(avroSchema).toString(), e);
        }
        return structType;
    }

    public Schema getAvroSchemaWithDefaults(Schema schema, DataType dataType) {
        Schema.Type type2 = schema.getType();
        if (Schema.Type.RECORD.equals(type2)) {
            StructType structType = (StructType)dataType;
            StructField[] structFields = structType.fields();
            java.util.List modifiedFields = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
                Tuple2 tuple2;
                int i = structType.fieldIndex(field.name());
                String comment = structFields[i].metadata().contains("comment") ? structFields[i].metadata().getString("comment") : field.doc();
                Schema.Type type2 = field.schema().getType();
                Tuple2 tuple22 = tuple2 = Schema.Type.UNION.equals(type2) ? MODULE$.resolveUnion(field.schema(), structFields[i].dataType()) : new Tuple2((Object)MODULE$.getAvroSchemaWithDefaults(field.schema(), structFields[i].dataType()), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Schema newSchema = (Schema)tuple2._1();
                boolean containsNullSchema = tuple2._2$mcZ$sp();
                Tuple2 tuple23 = new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)containsNullSchema));
                Schema newSchema2 = (Schema)tuple23._1();
                boolean containsNullSchema2 = tuple23._2$mcZ$sp();
                return new Schema.Field(field.name(), newSchema2, comment, containsNullSchema2 ? JsonProperties.NULL_VALUE : field.defaultVal());
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
            return Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (java.util.List)modifiedFields);
        }
        if (Schema.Type.UNION.equals(type2)) {
            Tuple2<Schema, Object> tuple2 = this.resolveUnion(schema, dataType);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema resolved = (Schema)tuple2._1();
            Schema resolved2 = resolved;
            return resolved2;
        }
        if (Schema.Type.MAP.equals(type2)) {
            return Schema.createMap((Schema)this.getAvroSchemaWithDefaults(schema.getValueType(), ((MapType)dataType).valueType()));
        }
        if (Schema.Type.ARRAY.equals(type2)) {
            return Schema.createArray((Schema)this.getAvroSchemaWithDefaults(schema.getElementType(), ((ArrayType)dataType).elementType()));
        }
        return schema;
    }

    private Tuple2<Schema, Object> resolveUnion(Schema schema2, DataType dataType) {
        Buffer innerFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getTypes()).asScala();
        boolean containsNullSchema = BoxesRunTime.unboxToBoolean((Object)innerFields.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(nullFieldEncountered, schema) -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$resolveUnion$1(BoxesRunTime.unboxToBoolean((Object)nullFieldEncountered), schema))));
        return new Tuple2((Object)(containsNullSchema ? Schema.createUnion((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.NULL), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)((TraversableLike)innerFields.filter((Function1 & Serializable & scala.Serializable)innerSchema -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$resolveUnion$2(innerSchema)))).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema, dataType), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).asJava())) : Schema.createUnion((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema, dataType), Buffer$.MODULE$.canBuildFrom())).asJava()))), (Object)BoxesRunTime.boxToBoolean((boolean)containsNullSchema));
    }

    @Deprecated
    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String qualifiedName2 = AvroSchemaUtils.getAvroRecordQualifiedName(tableName);
        String[] nameParts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName2)).split('.');
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).last(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).init())).mkString("."));
    }

    private Schema handleUnion(Schema schema) {
        Schema.Type type2 = schema.getType();
        Schema.Type type3 = Schema.Type.UNION;
        if (!(type2 != null ? !type2.equals(type3) : type3 != null)) {
            Schema.Type type4 = ((Schema)schema.getTypes().get(0)).getType();
            Schema.Type type5 = Schema.Type.NULL;
            int index = !(type4 != null ? !type4.equals(type5) : type5 != null) ? 1 : 0;
            return (Schema)schema.getTypes().get(index);
        }
        return schema;
    }

    public static final /* synthetic */ boolean $anonfun$resolveUnion$1(boolean nullFieldEncountered, Schema schema) {
        Schema.Type type2 = schema.getType();
        Schema.Type type3 = Schema.Type.NULL;
        return nullFieldEncountered | !(type2 != null ? !type2.equals(type3) : type3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$resolveUnion$2(Schema innerSchema) {
        Schema.Type type2 = innerSchema.getType();
        Schema.Type type3 = Schema.Type.NULL;
        return type2 == null ? type3 != null : !type2.equals(type3);
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

