/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.Serializable;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(TransactionManager.class);
    protected final LockManager lockManager;
    protected final boolean isLockRequired;
    protected Option<HoodieInstant> currentTxnOwnerInstant = Option.empty();
    private Option<HoodieInstant> lastCompletedTxnOwnerInstant = Option.empty();

    public TransactionManager(HoodieWriteConfig config, HoodieStorage storage2) {
        this(new LockManager(config, storage2), config.isLockRequired());
    }

    protected TransactionManager(LockManager lockManager, boolean isLockRequired) {
        this.lockManager = lockManager;
        this.isLockRequired = isLockRequired;
    }

    public void beginTransaction(Option<HoodieInstant> newTxnOwnerInstant, Option<HoodieInstant> lastCompletedTxnOwnerInstant) {
        if (this.isLockRequired) {
            LOG.info("Transaction starting for " + newTxnOwnerInstant + " with latest completed transaction instant " + lastCompletedTxnOwnerInstant);
            this.lockManager.lock();
            this.reset(this.currentTxnOwnerInstant, newTxnOwnerInstant, lastCompletedTxnOwnerInstant);
            LOG.info("Transaction started for " + newTxnOwnerInstant + " with latest completed transaction instant " + lastCompletedTxnOwnerInstant);
        }
    }

    public void endTransaction(Option<HoodieInstant> currentTxnOwnerInstant) {
        if (this.isLockRequired) {
            LOG.info("Transaction ending with transaction owner " + currentTxnOwnerInstant);
            if (this.reset(currentTxnOwnerInstant, Option.empty(), Option.empty())) {
                this.lockManager.unlock();
                LOG.info("Transaction ended with transaction owner " + currentTxnOwnerInstant);
            }
        }
    }

    protected synchronized boolean reset(Option<HoodieInstant> callerInstant, Option<HoodieInstant> newTxnOwnerInstant, Option<HoodieInstant> lastCompletedTxnOwnerInstant) {
        if (!this.currentTxnOwnerInstant.isPresent() || this.currentTxnOwnerInstant.get().equals(callerInstant.get())) {
            this.currentTxnOwnerInstant = newTxnOwnerInstant;
            this.lastCompletedTxnOwnerInstant = lastCompletedTxnOwnerInstant;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.isLockRequired) {
            this.lockManager.close();
            LOG.info("Transaction manager closed");
        }
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Option<HoodieInstant> getLastCompletedTransactionOwner() {
        return this.lastCompletedTxnOwnerInstant;
    }

    public Option<HoodieInstant> getCurrentTransactionOwner() {
        return this.currentTxnOwnerInstant;
    }

    public boolean isLockRequired() {
        return this.isLockRequired;
    }
}

