/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.beust.jcommander;

import java.util.Map;
import org.apache.hudi.com.beust.jcommander.ParameterException;
import org.apache.hudi.com.beust.jcommander.internal.Maps;

public class FuzzyMap {
    public static <V> V findInMap(Map<? extends IKey, V> map2, IKey name2, boolean caseSensitive, boolean allowAbbreviations) {
        if (allowAbbreviations) {
            return FuzzyMap.findAbbreviatedValue(map2, name2, caseSensitive);
        }
        if (caseSensitive) {
            return map2.get(name2);
        }
        for (IKey iKey : map2.keySet()) {
            if (!iKey.getName().equalsIgnoreCase(name2.getName())) continue;
            return map2.get(iKey);
        }
        return null;
    }

    private static <V> V findAbbreviatedValue(Map<? extends IKey, V> map2, IKey name2, boolean caseSensitive) {
        V result2;
        String string = name2.getName();
        Map<String, V> results = Maps.newHashMap();
        for (IKey iKey : map2.keySet()) {
            String n = iKey.getName();
            boolean match = caseSensitive && n.startsWith(string) || !caseSensitive && n.toLowerCase().startsWith(string.toLowerCase());
            if (!match) continue;
            results.put(n, map2.get(iKey));
        }
        if (results.size() > 1) {
            throw new ParameterException("Ambiguous option: " + name2 + " matches " + results.keySet());
        }
        if (results.size() == 1) {
            Object result3 = results.values().iterator().next();
        } else {
            result2 = null;
        }
        return result2;
    }

    static interface IKey {
        public String getName();
    }
}

