/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser.PropertyAccessorCollector;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.ser.SerializerUtil;
import org.apache.hudi.com.fasterxml.jackson.module.afterburner.util.MyClassLoader;

public class SerializerModifier
extends BeanSerializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final MyClassLoader _classLoader;

    public SerializerModifier(ClassLoader cl) {
        this._classLoader = cl == null ? null : new MyClassLoader(cl, false);
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        Class beanClass = beanDesc.getBeanClass();
        if (!MyClassLoader.canAddClassInPackageOf(beanClass)) {
            return beanProperties;
        }
        if (this._classLoader != null && Modifier.isPrivate(beanClass.getModifiers())) {
            return beanProperties;
        }
        PropertyAccessorCollector collector = this.findProperties(beanClass, config, beanProperties);
        if (collector.isEmpty()) {
            return beanProperties;
        }
        BeanPropertyAccessor acc = null;
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            BeanPropertyWriter bpw = it.next();
            if (!(bpw instanceof OptimizedBeanPropertyWriter)) continue;
            if (acc == null) {
                acc = collector.findAccessor(this._classLoader);
            }
            it.set((BeanPropertyWriter)((OptimizedBeanPropertyWriter)bpw).withAccessor(acc));
        }
        return beanProperties;
    }

    protected PropertyAccessorCollector findProperties(Class<?> beanClass, SerializationConfig config, List<BeanPropertyWriter> beanProperties) {
        PropertyAccessorCollector collector = new PropertyAccessorCollector(beanClass);
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            BeanPropertyWriter bpw = it.next();
            AnnotatedMember member = bpw.getMember();
            Member jdkMember = member.getMember();
            if (jdkMember == null || Modifier.isPrivate(jdkMember.getModifiers()) || bpw.hasSerializer() && !SerializerUtil.isDefaultSerializer(bpw.getSerializer()) || bpw.isUnwrapping() || bpw.getClass() != BeanPropertyWriter.class) continue;
            Class type2 = bpw.getMember().getRawType();
            boolean isMethod = member instanceof AnnotatedMethod;
            if (type2.isPrimitive()) {
                if (type2 == Integer.TYPE) {
                    if (isMethod) {
                        it.set(collector.addIntGetter(bpw));
                        continue;
                    }
                    it.set(collector.addIntField(bpw));
                    continue;
                }
                if (type2 == Long.TYPE) {
                    if (isMethod) {
                        it.set(collector.addLongGetter(bpw));
                        continue;
                    }
                    it.set(collector.addLongField(bpw));
                    continue;
                }
                if (type2 != Boolean.TYPE) continue;
                if (isMethod) {
                    it.set(collector.addBooleanGetter(bpw));
                    continue;
                }
                it.set(collector.addBooleanField(bpw));
                continue;
            }
            if (type2 == String.class) {
                if (isMethod) {
                    it.set(collector.addStringGetter(bpw));
                    continue;
                }
                it.set(collector.addStringField(bpw));
                continue;
            }
            if (isMethod) {
                it.set(collector.addObjectGetter(bpw));
                continue;
            }
            it.set(collector.addObjectField(bpw));
        }
        return collector;
    }
}

