/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.uber.m3.tally;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.com.uber.m3.tally.Gauge;
import org.apache.hudi.com.uber.m3.tally.MetricBase;
import org.apache.hudi.com.uber.m3.tally.Reportable;
import org.apache.hudi.com.uber.m3.tally.ScopeImpl;
import org.apache.hudi.com.uber.m3.tally.StatsReporter;
import org.apache.hudi.com.uber.m3.util.ImmutableMap;

class GaugeImpl
extends MetricBase
implements Gauge,
Reportable {
    private AtomicBoolean updated = new AtomicBoolean(false);
    private AtomicLong curr = new AtomicLong(0L);

    protected GaugeImpl(ScopeImpl scope2, String fqn) {
        super(fqn);
        scope2.addToReportingQueue(this);
    }

    @Override
    public void update(double value) {
        this.curr.set(Double.doubleToLongBits(value));
        this.updated.set(true);
    }

    double value() {
        return Double.longBitsToDouble(this.curr.get());
    }

    @Override
    public void report(ImmutableMap<String, String> tags, StatsReporter reporter2) {
        if (this.updated.getAndSet(false)) {
            reporter2.reportGauge(this.getQualifiedName(), tags, this.value());
        }
    }

    double snapshot() {
        return this.value();
    }
}

