/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.uber.m3.tally;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.com.uber.m3.tally.Buckets;
import org.apache.hudi.com.uber.m3.tally.DurationBuckets;
import org.apache.hudi.com.uber.m3.tally.Scope;
import org.apache.hudi.com.uber.m3.tally.ScopeImpl;
import org.apache.hudi.com.uber.m3.tally.StatsReporter;
import org.apache.hudi.com.uber.m3.util.Duration;
import org.apache.hudi.com.uber.m3.util.ImmutableMap;

public class ScopeBuilder {
    private static final String DEFAULT_SEPARATOR = ".";
    private static final Buckets DEFAULT_SCOPE_BUCKETS = new DurationBuckets(new Duration[]{Duration.ZERO, Duration.ofMillis(10.0), Duration.ofMillis(15.0), Duration.ofMillis(50.0), Duration.ofMillis(75.0), Duration.ofMillis(100.0), Duration.ofMillis(200.0), Duration.ofMillis(300.0), Duration.ofMillis(400.0), Duration.ofMillis(500.0), Duration.ofMillis(600.0), Duration.ofMillis(800.0), Duration.ofSeconds(1.0), Duration.ofSeconds(2.0), Duration.ofSeconds(5.0)});
    protected StatsReporter reporter = null;
    protected String prefix = "";
    protected String separator = ".";
    protected ImmutableMap<String, String> tags;
    protected Buckets defaultBuckets = DEFAULT_SCOPE_BUCKETS;
    private ScheduledExecutorService scheduler;
    private ScopeImpl.Registry registry;

    protected ScopeBuilder(ScheduledExecutorService scheduler, ScopeImpl.Registry registry) {
        this.scheduler = scheduler;
        this.registry = registry;
    }

    public ScopeBuilder reporter(StatsReporter reporter2) {
        this.reporter = reporter2;
        return this;
    }

    public ScopeBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ScopeBuilder separator(String separator) {
        this.separator = separator;
        return this;
    }

    public ScopeBuilder tags(Map<String, String> tags) {
        this.tags = new ImmutableMap<String, String>(tags);
        return this;
    }

    public ScopeBuilder tags(ImmutableMap<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ScopeBuilder defaultBuckets(Buckets defaultBuckets) {
        this.defaultBuckets = defaultBuckets;
        return this;
    }

    ScopeImpl build() {
        return new ScopeImpl(this.scheduler, this.registry, this);
    }

    public Scope reportEvery(Duration interval) {
        return this.reportEvery(interval, null);
    }

    public Scope reportEvery(Duration interval, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (interval.compareTo(Duration.ZERO) <= 0) {
            throw new IllegalArgumentException("Reporting interval must be a positive Duration");
        }
        ScopeImpl scope2 = this.build();
        this.registry.subscopes.put(ScopeImpl.keyForPrefixedStringMap(this.prefix, this.tags), scope2);
        ScopeImpl scopeImpl = scope2;
        scopeImpl.getClass();
        this.scheduler.scheduleWithFixedDelay(new ScopeImpl.ReportLoop(scopeImpl, uncaughtExceptionHandler), 0L, interval.toMillis(), TimeUnit.MILLISECONDS);
        return scope2;
    }
}

