/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.data.HoodieAccumulator;
import org.apache.hudi.common.data.HoodieAtomicLongAccumulator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodieListPairData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFlatMapFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StorageConfiguration;

public final class HoodieLocalEngineContext
extends HoodieEngineContext {
    public HoodieLocalEngineContext(StorageConfiguration<?> conf) {
        this(conf, new LocalTaskContextSupplier());
    }

    public HoodieLocalEngineContext(StorageConfiguration<?> conf, TaskContextSupplier taskContextSupplier) {
        super(conf, taskContextSupplier);
    }

    @Override
    public HoodieAccumulator newAccumulator() {
        return HoodieAtomicLongAccumulator.create();
    }

    @Override
    public <T> HoodieData<T> emptyHoodieData() {
        return HoodieListData.eager(Collections.emptyList());
    }

    @Override
    public <K, V> HoodiePairData<K, V> emptyHoodiePairData() {
        return HoodieListPairData.eager(Collections.emptyList());
    }

    @Override
    public <T> HoodieData<T> parallelize(List<T> data2, int parallelism) {
        return HoodieListData.eager(data2);
    }

    @Override
    public <I, O> List<O> map(List<I> data2, SerializableFunction<I, O> func, int parallelism) {
        return ((Stream)data2.stream().parallel()).map(FunctionWrapper.throwingMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I, K, V> List<V> mapToPairAndReduceByKey(List<I> data2, SerializablePairFunction<I, K, V> mapToPairFunc, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return ((Stream)data2.stream().parallel()).map(FunctionWrapper.throwingMapToPairWrapper(mapToPairFunc)).collect(Collectors.groupingBy(p -> p.getKey())).values().stream().map(list -> list.stream().map(e -> e.getValue()).reduce(FunctionWrapper.throwingReduceWrapper(reduceFunc)).get()).collect(Collectors.toList());
    }

    @Override
    public <I, K, V> Stream<ImmutablePair<K, V>> mapPartitionsToPairAndReduceByKey(Stream<I> data2, SerializablePairFlatMapFunction<Iterator<I>, K, V> flatMapToPairFunc, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return FunctionWrapper.throwingFlatMapToPairWrapper(flatMapToPairFunc).apply(((Stream)data2.parallel()).iterator()).collect(Collectors.groupingBy(Pair::getKey)).entrySet().stream().map(entry -> new ImmutablePair(entry.getKey(), ((List)entry.getValue()).stream().map(Pair::getValue).reduce(FunctionWrapper.throwingReduceWrapper(reduceFunc)).orElse(null))).filter(Objects::nonNull);
    }

    @Override
    public <I, K, V> List<V> reduceByKey(List<Pair<K, V>> data2, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return ((Stream)data2.stream().parallel()).collect(Collectors.groupingBy(p -> p.getKey())).values().stream().map(list -> list.stream().map(e -> e.getValue()).reduce(FunctionWrapper.throwingReduceWrapper(reduceFunc)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public <I, O> List<O> flatMap(List<I> data2, SerializableFunction<I, Stream<O>> func, int parallelism) {
        return ((Stream)data2.stream().parallel()).flatMap(FunctionWrapper.throwingFlatMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I> void foreach(List<I> data2, SerializableConsumer<I> consumer, int parallelism) {
        data2.stream().forEach(FunctionWrapper.throwingForeachWrapper(consumer));
    }

    @Override
    public <I, K, V> Map<K, V> mapToPair(List<I> data2, SerializablePairFunction<I, K, V> func, Integer parallelism) {
        return data2.stream().map(FunctionWrapper.throwingMapToPairWrapper(func)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (oldVal, newVal) -> newVal));
    }

    @Override
    public void setProperty(EngineProperty key, String value) {
    }

    @Override
    public Option<String> getProperty(EngineProperty key) {
        return Option.empty();
    }

    @Override
    public void setJobStatus(String activeModule, String activityDescription) {
    }

    @Override
    public void putCachedDataIds(HoodieData.HoodieDataCacheKey cacheKey, int ... ids) {
    }

    @Override
    public List<Integer> getCachedDataIds(HoodieData.HoodieDataCacheKey cacheKey) {
        return Collections.emptyList();
    }

    @Override
    public List<Integer> removeCachedDataIds(HoodieData.HoodieDataCacheKey cacheKey) {
        return Collections.emptyList();
    }

    @Override
    public void cancelJob(String jobId) {
    }

    @Override
    public void cancelAllJobs() {
    }

    @Override
    public <I, O> O aggregate(HoodieData<I> data2, O zeroValue, Functions.Function2<O, I, O> seqOp, Functions.Function2<O, O, O> combOp) {
        return (O)data2.collectAsList().stream().reduce(zeroValue, seqOp::apply, combOp::apply);
    }
}

