/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.heartbeat;

import java.io.IOException;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHeartbeatUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHeartbeatUtils.class);

    public static Long getLastHeartbeatTime(HoodieStorage storage2, String basePath, String instantTime) throws IOException {
        StoragePath heartbeatFilePath = new StoragePath(HoodieTableMetaClient.getHeartbeatFolderPath(basePath), instantTime);
        if (storage2.exists(heartbeatFilePath)) {
            return storage2.getPathInfo(heartbeatFilePath).getModificationTime();
        }
        return 0L;
    }

    public static boolean isHeartbeatExpired(String instantTime, long maxAllowableHeartbeatIntervalInMs, HoodieStorage storage2, String basePath) throws IOException {
        Long currentTime = System.currentTimeMillis();
        Long lastHeartbeatTime = HoodieHeartbeatUtils.getLastHeartbeatTime(storage2, basePath, instantTime);
        if (currentTime - lastHeartbeatTime > maxAllowableHeartbeatIntervalInMs) {
            LOG.warn("Heartbeat expired, for instant: " + instantTime);
            return true;
        }
        return false;
    }
}

