/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieReplaceCommitMetadata
extends HoodieCommitMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieReplaceCommitMetadata.class);
    protected Map<String, List<String>> partitionToReplaceFileIds = new HashMap<String, List<String>>();

    public HoodieReplaceCommitMetadata() {
        this(false);
    }

    public HoodieReplaceCommitMetadata(boolean compacted) {
        super(compacted);
    }

    public void setPartitionToReplaceFileIds(Map<String, List<String>> partitionToReplaceFileIds) {
        this.partitionToReplaceFileIds = partitionToReplaceFileIds;
    }

    public void addReplaceFileId(String partitionPath, String fileId) {
        if (!this.partitionToReplaceFileIds.containsKey(partitionPath)) {
            this.partitionToReplaceFileIds.put(partitionPath, new ArrayList());
        }
        this.partitionToReplaceFileIds.get(partitionPath).add(fileId);
    }

    public Map<String, List<String>> getPartitionToReplaceFileIds() {
        return this.partitionToReplaceFileIds;
    }

    @Override
    public String toJsonString() throws IOException {
        if (this.partitionToWriteStats.containsKey(null)) {
            LOG.info("partition path is null for " + this.partitionToWriteStats.get(null));
            this.partitionToWriteStats.remove(null);
        }
        if (this.partitionToReplaceFileIds.containsKey(null)) {
            LOG.info("partition path is null for " + this.partitionToReplaceFileIds.get(null));
            this.partitionToReplaceFileIds.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return (T)JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieReplaceCommitMetadata that = (HoodieReplaceCommitMetadata)o;
        if (!this.partitionToWriteStats.equals(that.partitionToWriteStats)) {
            return false;
        }
        return this.compacted.equals(that.compacted);
    }

    @Override
    public int hashCode() {
        int result2 = this.partitionToWriteStats.hashCode();
        result2 = 31 * result2 + this.compacted.hashCode();
        return result2;
    }

    /*
     * Loose catch block
     */
    public static <T> T fromBytes(byte[] bytes, Class<T> clazz) throws IOException {
        block5: {
            if (bytes.length != 0) break block5;
            return clazz.newInstance();
            {
                catch (Exception e) {
                    throw new IOException("unable to read commit metadata for bytes length: " + bytes.length, e);
                }
            }
        }
        try {
            return HoodieReplaceCommitMetadata.fromJsonString(StringUtils.fromUTF8Bytes(MetadataConversionUtils.convertCommitMetadataToJsonBytes(TimelineMetadataUtils.deserializeReplaceCommitMetadata(bytes), org.apache.hudi.avro.model.HoodieReplaceCommitMetadata.class)), clazz);
        }
        catch (Exception e) {
            LOG.warn("Primary method failed; trying alternative deserialization method.", (Throwable)e);
            return HoodieReplaceCommitMetadata.fromJsonString(new String(bytes, StandardCharsets.UTF_8), clazz);
        }
    }

    @Override
    public String toString() {
        return "HoodieReplaceMetadata{partitionToWriteStats=" + this.partitionToWriteStats + ", partitionToReplaceFileIds=" + this.partitionToReplaceFileIds + ", compacted=" + this.compacted + ", extraMetadata=" + this.extraMetadata + ", operationType=" + (Object)((Object)this.operationType) + '}';
    }
}

