/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Closeable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.BaseHoodieLogRecordReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergedLogRecordReader<T>
extends BaseHoodieLogRecordReader<T>
implements Iterable<Pair<Option<T>, Map<String, Object>>>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergedLogRecordReader.class);
    public final HoodieTimer timer = HoodieTimer.create();
    private final Set<String> scannedPrefixes = new HashSet<String>();
    private long numMergedRecordsInLog;
    private long totalTimeTakenToReadAndMergeBlocks;

    private HoodieMergedLogRecordReader(HoodieReaderContext<T> readerContext, HoodieStorage storage2, List<String> logFilePaths, boolean reverseReader, int bufferSize, Option<InstantRange> instantRange, boolean withOperationField, boolean forceFullScan, Option<String> partitionName, Option<String> keyFieldOverride, boolean enableOptimizedLogBlocksScan, HoodieFileGroupRecordBuffer<T> recordBuffer) {
        super(readerContext, storage2, logFilePaths, reverseReader, bufferSize, instantRange, withOperationField, forceFullScan, partitionName, keyFieldOverride, enableOptimizedLogBlocksScan, recordBuffer);
        if (forceFullScan) {
            this.performScan();
        }
    }

    public final void scan() {
        this.scan(false);
    }

    public final void scan(boolean skipProcessingBlocks) {
        if (this.forceFullScan) {
            return;
        }
        this.scanInternal(Option.empty(), skipProcessingBlocks);
    }

    public void scanByFullKeys(List<String> keys2) {
        if (this.forceFullScan) {
            return;
        }
        List<String> missingKeys = keys2.stream().filter(key -> !this.recordBuffer.containsLogRecord((String)key)).collect(Collectors.toList());
        if (missingKeys.isEmpty()) {
            return;
        }
        this.scanInternal(Option.of(KeySpec.fullKeySpec(missingKeys)), false);
    }

    public void scanByKeyPrefixes(List<String> keyPrefixes) {
        if (this.forceFullScan) {
            return;
        }
        List<String> missingKeyPrefixes = keyPrefixes.stream().filter(keyPrefix -> this.scannedPrefixes.stream().noneMatch(keyPrefix::startsWith)).collect(Collectors.toList());
        if (missingKeyPrefixes.isEmpty()) {
            return;
        }
        this.scanInternal(Option.of(KeySpec.prefixKeySpec(missingKeyPrefixes)), false);
        this.scannedPrefixes.addAll(missingKeyPrefixes);
    }

    private void performScan() {
        this.timer.startTimer();
        this.scanInternal(Option.empty(), false);
        this.totalTimeTakenToReadAndMergeBlocks = this.timer.endTimer();
        this.numMergedRecordsInLog = this.recordBuffer.size();
        LOG.info("Number of log files scanned => {}", (Object)this.logFilePaths.size());
        LOG.info("Number of entries in Map => {}", (Object)this.recordBuffer.size());
    }

    @Override
    public Iterator<Pair<Option<T>, Map<String, Object>>> iterator() {
        return this.recordBuffer.getLogRecordIterator();
    }

    public Map<Serializable, Pair<Option<T>, Map<String, Object>>> getRecords() {
        return this.recordBuffer.getLogRecords();
    }

    public long getNumMergedRecordsInLog() {
        return this.numMergedRecordsInLog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getTotalTimeTakenToReadAndMergeBlocks() {
        return this.totalTimeTakenToReadAndMergeBlocks;
    }

    @Override
    public void close() {
    }

    public static class Builder<T>
    extends BaseHoodieLogRecordReader.Builder<T> {
        private HoodieReaderContext<T> readerContext;
        private HoodieStorage storage;
        private List<String> logFilePaths;
        private boolean reverseReader;
        private int bufferSize;
        private Long maxMemorySizeInBytes;
        private Option<InstantRange> instantRange = Option.empty();
        private String partitionName;
        private boolean withOperationField = false;
        private String keyFieldOverride;
        private boolean forceFullScan = true;
        private boolean enableOptimizedLogBlocksScan = false;
        private HoodieFileGroupRecordBuffer<T> recordBuffer;

        @Override
        public Builder<T> withHoodieReaderContext(HoodieReaderContext<T> readerContext) {
            this.readerContext = readerContext;
            return this;
        }

        @Override
        public Builder<T> withStorage(HoodieStorage storage2) {
            this.storage = storage2;
            return this;
        }

        @Override
        public Builder<T> withLogFiles(List<HoodieLogFile> hoodieLogFiles) {
            this.logFilePaths = hoodieLogFiles.stream().filter(l -> !l.isCDC()).map(l -> l.getPath().toString()).collect(Collectors.toList());
            return this;
        }

        @Override
        public Builder<T> withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder<T> withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder<T> withInstantRange(Option<InstantRange> instantRange) {
            this.instantRange = instantRange;
            return this;
        }

        @Override
        public Builder<T> withOperationField(boolean withOperationField) {
            this.withOperationField = withOperationField;
            return this;
        }

        @Override
        public Builder<T> withPartition(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        @Override
        public Builder<T> withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
            return this;
        }

        public Builder<T> withKeyFieldOverride(String keyFieldOverride) {
            this.keyFieldOverride = Objects.requireNonNull(keyFieldOverride);
            return this;
        }

        public Builder<T> withForceFullScan(boolean forceFullScan) {
            this.forceFullScan = forceFullScan;
            return this;
        }

        public Builder<T> withRecordBuffer(HoodieFileGroupRecordBuffer<T> recordBuffer) {
            this.recordBuffer = recordBuffer;
            return this;
        }

        @Override
        public HoodieMergedLogRecordReader<T> build() {
            ValidationUtils.checkArgument(this.recordBuffer != null, "Record Buffer is null in Merged Log Record Reader");
            ValidationUtils.checkArgument(this.readerContext != null, "Reader Context is null in Merged Log Record Reader");
            if (this.partitionName == null && CollectionUtils.nonEmpty(this.logFilePaths)) {
                this.partitionName = FSUtils.getRelativePartitionPath(new StoragePath(this.readerContext.getTablePath()), new StoragePath(this.logFilePaths.get(0)).getParent());
            }
            return new HoodieMergedLogRecordReader(this.readerContext, this.storage, this.logFilePaths, this.reverseReader, this.bufferSize, this.instantRange, this.withOperationField, this.forceFullScan, Option.ofNullable(this.partitionName), Option.ofNullable(this.keyFieldOverride), this.enableOptimizedLogBlocksScan, this.recordBuffer);
        }
    }
}

