/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;

public abstract class HoodieBaseFileGroupRecordBuffer<T>
implements HoodieFileGroupRecordBuffer<T> {
    protected final HoodieReaderContext<T> readerContext;
    protected final Schema readerSchema;
    protected final Option<String> orderingFieldName;
    protected final Option<String> partitionNameOverrideOpt;
    protected final Option<String[]> partitionPathFieldOpt;
    protected final RecordMergeMode recordMergeMode;
    protected final Option<HoodieRecordMerger> recordMerger;
    protected final Option<String> payloadClass;
    protected final TypedProperties props;
    protected final ExternalSpillableMap<Serializable, Pair<Option<T>, Map<String, Object>>> records;
    protected final HoodieReadStats readStats;
    protected ClosableIterator<T> baseFileIterator;
    protected Iterator<Pair<Option<T>, Map<String, Object>>> logRecordIterator;
    protected T nextRecord;
    protected boolean enablePartialMerging = false;
    protected InternalSchema internalSchema;
    protected HoodieTableMetaClient hoodieTableMetaClient;

    public HoodieBaseFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, TypedProperties props, HoodieReadStats readStats) {
        this.readerContext = readerContext;
        this.readerSchema = readerContext.getSchemaHandler().getRequiredSchema();
        this.partitionNameOverrideOpt = partitionNameOverrideOpt;
        this.partitionPathFieldOpt = partitionPathFieldOpt;
        this.recordMergeMode = recordMergeMode;
        this.recordMerger = readerContext.getRecordMerger();
        this.payloadClass = this.recordMerger.isPresent() && this.recordMerger.get().getMergingStrategy().equals("00000000-0000-0000-0000-000000000000") ? Option.of(hoodieTableMetaClient.getTableConfig().getPayloadClass()) : Option.empty();
        this.orderingFieldName = recordMergeMode == RecordMergeMode.COMMIT_TIME_ORDERING ? Option.empty() : Option.ofNullable(ConfigUtils.getOrderingField(props)).or(() -> {
            String preCombineField = hoodieTableMetaClient.getTableConfig().getPreCombineField();
            if (StringUtils.isNullOrEmpty(preCombineField)) {
                return Option.empty();
            }
            return Option.of(preCombineField);
        });
        this.props = props;
        this.internalSchema = readerContext.getSchemaHandler().getInternalSchema();
        this.hoodieTableMetaClient = hoodieTableMetaClient;
        long maxMemorySizeInBytes = props.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.defaultValue());
        String spillableMapBasePath = props.getString(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath());
        ExternalSpillableMap.DiskMapType diskMapType = ExternalSpillableMap.DiskMapType.valueOf(props.getString(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue().name()).toUpperCase(Locale.ROOT));
        boolean isBitCaskDiskMapCompressionEnabled = props.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue());
        this.readStats = readStats;
        try {
            this.records = new ExternalSpillableMap(maxMemorySizeInBytes, spillableMapBasePath, new DefaultSizeEstimator(), new HoodieRecordSizeEstimator(this.readerSchema), diskMapType, isBitCaskDiskMapCompressionEnabled);
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when creating ExternalSpillableMap at " + spillableMapBasePath, e);
        }
    }

    @Override
    public void setBaseFileIterator(ClosableIterator<T> baseFileIterator) {
        this.baseFileIterator = baseFileIterator;
    }

    protected abstract boolean doHasNext() throws IOException;

    @Override
    public final boolean hasNext() throws IOException {
        return this.nextRecord != null || this.doHasNext();
    }

    @Override
    public final T next() {
        T record = this.nextRecord;
        this.nextRecord = null;
        return record;
    }

    @Override
    public Map<Serializable, Pair<Option<T>, Map<String, Object>>> getLogRecords() {
        return this.records;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public Iterator<Pair<Option<T>, Map<String, Object>>> getLogRecordIterator() {
        return this.records.values().iterator();
    }

    @Override
    public void close() {
        this.records.clear();
    }

    protected Option<Pair<Option<T>, Map<String, Object>>> doProcessNextDataRecord(T record, Map<String, Object> metadata2, Pair<Option<T>, Map<String, Object>> existingRecordMetadataPair) throws IOException {
        if (existingRecordMetadataPair != null) {
            if (this.enablePartialMerging) {
                Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt = this.recordMerger.get().partialMerge(this.readerContext.constructHoodieRecord(Option.of(record), metadata2), this.readerContext.getSchemaFromMetadata(metadata2), this.readerContext.constructHoodieRecord(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight()), this.readerContext.getSchemaFromMetadata(existingRecordMetadataPair.getRight()), this.readerSchema, this.props);
                if (!combinedRecordAndSchemaOpt.isPresent()) {
                    return Option.empty();
                }
                Pair<HoodieRecord, Schema> combinedRecordAndSchema = combinedRecordAndSchemaOpt.get();
                HoodieRecord combinedRecord = combinedRecordAndSchema.getLeft();
                if (combinedRecord.getData() != existingRecordMetadataPair.getLeft().get()) {
                    return Option.of(Pair.of(Option.ofNullable(combinedRecord.getData()), this.readerContext.updateSchemaAndResetOrderingValInMetadata(metadata2, combinedRecordAndSchema.getRight())));
                }
                return Option.empty();
            }
            switch (this.recordMergeMode) {
                case COMMIT_TIME_ORDERING: {
                    return Option.empty();
                }
                case EVENT_TIME_ORDERING: {
                    Comparable existingOrderingValue = this.readerContext.getOrderingValue(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight(), this.readerSchema, this.orderingFieldName);
                    if (this.isDeleteRecordWithNaturalOrder(existingRecordMetadataPair.getLeft(), existingOrderingValue)) {
                        return Option.empty();
                    }
                    Comparable incomingOrderingValue = this.readerContext.getOrderingValue(Option.of(record), metadata2, this.readerSchema, this.orderingFieldName);
                    if (incomingOrderingValue.compareTo(existingOrderingValue) > 0) {
                        return Option.of(Pair.of(this.isDeleteRecord(Option.of(record), this.readerContext.getSchemaFromMetadata(metadata2)) ? Option.empty() : Option.of(record), metadata2));
                    }
                    return Option.empty();
                }
            }
            if (this.payloadClass.isPresent()) {
                T combinedRecordData;
                Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt = this.getMergedRecord(Option.of(record), metadata2, existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight());
                if (combinedRecordAndSchemaOpt.isPresent() && (combinedRecordData = this.readerContext.convertAvroRecord((IndexedRecord)combinedRecordAndSchemaOpt.get().getLeft().getData())) != existingRecordMetadataPair.getLeft().get()) {
                    return Option.of(Pair.of(Option.ofNullable(combinedRecordData), metadata2));
                }
                return Option.empty();
            }
            Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt = this.recordMerger.get().merge(this.readerContext.constructHoodieRecord(Option.of(record), metadata2), this.readerContext.getSchemaFromMetadata(metadata2), this.readerContext.constructHoodieRecord(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight()), this.readerContext.getSchemaFromMetadata(existingRecordMetadataPair.getRight()), this.props);
            if (!combinedRecordAndSchemaOpt.isPresent()) {
                return Option.empty();
            }
            Pair<HoodieRecord, Schema> combinedRecordAndSchema = combinedRecordAndSchemaOpt.get();
            HoodieRecord combinedRecord = combinedRecordAndSchema.getLeft();
            if (combinedRecord.getData() != existingRecordMetadataPair.getLeft().get()) {
                return Option.of(Pair.of(Option.ofNullable(combinedRecord.getData()), metadata2));
            }
            return Option.empty();
        }
        return Option.of(Pair.of(Option.ofNullable(record), metadata2));
    }

    protected Option<DeleteRecord> doProcessNextDeletedRecord(DeleteRecord deleteRecord, Pair<Option<T>, Map<String, Object>> existingRecordMetadataPair) {
        if (existingRecordMetadataPair != null) {
            boolean chooseExisting;
            switch (this.recordMergeMode) {
                case COMMIT_TIME_ORDERING: {
                    return Option.empty();
                }
            }
            Comparable existingOrderingVal = this.readerContext.getOrderingValue(existingRecordMetadataPair.getLeft(), existingRecordMetadataPair.getRight(), this.readerSchema, this.orderingFieldName);
            if (this.isDeleteRecordWithNaturalOrder(existingRecordMetadataPair.getLeft(), existingOrderingVal)) {
                return Option.empty();
            }
            Comparable<?> deleteOrderingVal = deleteRecord.getOrderingValue();
            boolean bl = chooseExisting = !deleteOrderingVal.equals(0) && ReflectionUtils.isSameClass(existingOrderingVal, deleteOrderingVal) && existingOrderingVal.compareTo(deleteOrderingVal) > 0;
            if (chooseExisting) {
                return Option.empty();
            }
        }
        return Option.of(deleteRecord);
    }

    protected Pair<ClosableIterator<T>, Schema> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        ClosableIterator<T> blockRecordsIterator;
        if (keySpecOpt.isPresent()) {
            KeySpec keySpec = keySpecOpt.get();
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext, keySpec.getKeys(), keySpec.isFullKey());
        } else {
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext);
        }
        Pair<Function<T, T>, Schema> schemaTransformerWithEvolvedSchema = this.getSchemaTransformerWithEvolvedSchema(dataBlock);
        return Pair.of(new CloseableMappingIterator<T, T>(blockRecordsIterator, schemaTransformerWithEvolvedSchema.getLeft()), schemaTransformerWithEvolvedSchema.getRight());
    }

    protected Option<Pair<Function<T, T>, Schema>> composeEvolvedSchemaTransformer(HoodieDataBlock dataBlock) {
        if (this.internalSchema.isEmptySchema()) {
            return Option.empty();
        }
        long currentInstantTime = Long.parseLong(dataBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
        InternalSchema fileSchema = InternalSchemaCache.searchSchemaAndCache(currentInstantTime, this.hoodieTableMetaClient);
        Pair<InternalSchema, Map<String, String>> mergedInternalSchema = new InternalSchemaMerger(fileSchema, this.internalSchema, true, false, false).mergeSchemaGetRenamed();
        Schema mergedAvroSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema.getLeft(), this.readerSchema.getFullName());
        assert (mergedAvroSchema.equals((Object)this.readerSchema));
        return Option.of(Pair.of(this.readerContext.projectRecord(dataBlock.getSchema(), mergedAvroSchema, mergedInternalSchema.getRight()), mergedAvroSchema));
    }

    protected Option<T> merge(Option<T> older, Map<String, Object> olderInfoMap, Option<T> newer, Map<String, Object> newerInfoMap) throws IOException {
        if (!older.isPresent()) {
            return this.isDeleteRecord(newer, this.readerContext.getSchemaFromMetadata(newerInfoMap)) ? Option.empty() : newer;
        }
        if (this.enablePartialMerging) {
            Option<Pair<HoodieRecord, Schema>> mergedRecord = this.recordMerger.get().partialMerge(this.readerContext.constructHoodieRecord(older, olderInfoMap), this.readerContext.getSchemaFromMetadata(olderInfoMap), this.readerContext.constructHoodieRecord(newer, newerInfoMap), this.readerContext.getSchemaFromMetadata(newerInfoMap), this.readerSchema, this.props);
            if (mergedRecord.isPresent() && !mergedRecord.get().getLeft().isDelete(mergedRecord.get().getRight(), this.props)) {
                if (!mergedRecord.get().getRight().equals((Object)this.readerSchema)) {
                    return Option.ofNullable(mergedRecord.get().getLeft().rewriteRecordWithNewSchema(mergedRecord.get().getRight(), null, this.readerSchema).getData());
                }
                return Option.ofNullable(mergedRecord.get().getLeft().getData());
            }
            return Option.empty();
        }
        switch (this.recordMergeMode) {
            case COMMIT_TIME_ORDERING: {
                return this.isDeleteRecord(newer, this.readerContext.getSchemaFromMetadata(newerInfoMap)) ? Option.empty() : newer;
            }
            case EVENT_TIME_ORDERING: {
                Comparable newOrderingValue = this.readerContext.getOrderingValue(newer, newerInfoMap, this.readerSchema, this.orderingFieldName);
                if (this.isDeleteRecordWithNaturalOrder(newer, newOrderingValue)) {
                    return Option.empty();
                }
                Comparable oldOrderingValue = this.readerContext.getOrderingValue(older, olderInfoMap, this.readerSchema, this.orderingFieldName);
                if (!this.isDeleteRecordWithNaturalOrder(older, oldOrderingValue) && oldOrderingValue.compareTo(newOrderingValue) > 0) {
                    return this.isDeleteRecord(older, this.readerContext.getSchemaFromMetadata(olderInfoMap)) ? Option.empty() : older;
                }
                return this.isDeleteRecord(newer, this.readerContext.getSchemaFromMetadata(newerInfoMap)) ? Option.empty() : newer;
            }
        }
        if (this.payloadClass.isPresent()) {
            Option<Pair<HoodieRecord, Schema>> mergedRecord = this.getMergedRecord(older, olderInfoMap, newer, newerInfoMap);
            if (mergedRecord.isPresent() && !mergedRecord.get().getLeft().isDelete(mergedRecord.get().getRight(), this.props)) {
                IndexedRecord indexedRecord = !mergedRecord.get().getRight().equals((Object)this.readerSchema) ? (IndexedRecord)mergedRecord.get().getLeft().rewriteRecordWithNewSchema(mergedRecord.get().getRight(), null, this.readerSchema).getData() : (IndexedRecord)mergedRecord.get().getLeft().getData();
                return Option.ofNullable(this.readerContext.convertAvroRecord(indexedRecord));
            }
            return Option.empty();
        }
        Option<Pair<HoodieRecord, Schema>> mergedRecord = this.recordMerger.get().merge(this.readerContext.constructHoodieRecord(older, olderInfoMap), this.readerContext.getSchemaFromMetadata(olderInfoMap), this.readerContext.constructHoodieRecord(newer, newerInfoMap), this.readerContext.getSchemaFromMetadata(newerInfoMap), this.props);
        if (mergedRecord.isPresent() && !mergedRecord.get().getLeft().isDelete(mergedRecord.get().getRight(), this.props)) {
            if (!mergedRecord.get().getRight().equals((Object)this.readerSchema)) {
                return Option.ofNullable(mergedRecord.get().getLeft().rewriteRecordWithNewSchema(mergedRecord.get().getRight(), null, this.readerSchema).getData());
            }
            return Option.ofNullable(mergedRecord.get().getLeft().getData());
        }
        return Option.empty();
    }

    private Option<Pair<HoodieRecord, Schema>> getMergedRecord(Option<T> older, Map<String, Object> olderInfoMap, Option<T> newer, Map<String, Object> newerInfoMap) throws IOException {
        ValidationUtils.checkArgument(!Objects.equals(this.payloadClass, OverwriteWithLatestAvroPayload.class.getCanonicalName()) && !Objects.equals(this.payloadClass, DefaultHoodieRecordPayload.class.getCanonicalName()));
        HoodieRecord oldHoodieRecord = this.constructHoodieAvroRecord(this.readerContext, older, olderInfoMap);
        HoodieRecord newHoodieRecord = this.constructHoodieAvroRecord(this.readerContext, newer, newerInfoMap);
        Option<Pair<HoodieRecord, Schema>> mergedRecord = this.recordMerger.get().merge(oldHoodieRecord, this.getSchemaForAvroPayloadMerge(oldHoodieRecord, olderInfoMap), newHoodieRecord, this.getSchemaForAvroPayloadMerge(newHoodieRecord, newerInfoMap), this.props);
        return mergedRecord;
    }

    private HoodieRecord constructHoodieAvroRecord(HoodieReaderContext<T> readerContext, Option<T> recordOption, Map<String, Object> metadataMap) {
        Schema recordSchema = this.readerSchema;
        GenericRecord record = null;
        if (recordOption.isPresent()) {
            recordSchema = readerContext.getSchemaFromMetadata(metadataMap);
            record = readerContext.convertToAvroRecord(recordOption.get(), recordSchema);
        }
        HoodieKey hoodieKey = new HoodieKey((String)metadataMap.get("_0"), (String)metadataMap.get("_1"));
        return new HoodieAvroRecord(hoodieKey, HoodieRecordUtils.loadPayload(this.payloadClass.get(), new Object[]{record, readerContext.getOrderingValue(recordOption, metadataMap, recordSchema, this.orderingFieldName)}, GenericRecord.class, Comparable.class), null);
    }

    private Schema getSchemaForAvroPayloadMerge(HoodieRecord record, Map<String, Object> infoMap) throws IOException {
        if (record.isDelete(this.readerSchema, this.props)) {
            return this.readerSchema;
        }
        return this.readerContext.getSchemaFromMetadata(infoMap);
    }

    protected boolean hasNextBaseRecord(T baseRecord, Pair<Option<T>, Map<String, Object>> logRecordInfo) throws IOException {
        Map<String, Object> metadata2 = this.readerContext.generateMetadataForRecord(baseRecord, this.readerSchema);
        if (logRecordInfo != null) {
            Option<T> resultRecord = this.merge(Option.of(baseRecord), metadata2, logRecordInfo.getLeft(), logRecordInfo.getRight());
            if (resultRecord.isPresent()) {
                this.nextRecord = this.readerContext.seal(resultRecord.get());
                this.readStats.incrementNumUpdates();
                return true;
            }
            this.readStats.incrementNumDeletes();
            return false;
        }
        this.nextRecord = this.readerContext.seal(baseRecord);
        this.readStats.incrementNumInserts();
        return true;
    }

    protected boolean hasNextLogRecord() throws IOException {
        if (this.logRecordIterator == null) {
            this.logRecordIterator = this.records.values().iterator();
        }
        while (this.logRecordIterator.hasNext()) {
            Pair<Option<T>, Map<String, Object>> nextRecordInfo = this.logRecordIterator.next();
            Option resultRecord = this.merge(Option.empty(), Collections.emptyMap(), nextRecordInfo.getLeft(), nextRecordInfo.getRight());
            if (!resultRecord.isPresent()) continue;
            this.nextRecord = this.readerContext.seal(resultRecord.get());
            return true;
        }
        return false;
    }

    protected Pair<Function<T, T>, Schema> getSchemaTransformerWithEvolvedSchema(HoodieDataBlock dataBlock) {
        Option<Pair<Function<Pair, Pair>, Schema>> schemaEvolutionTransformerOpt = this.composeEvolvedSchemaTransformer(dataBlock);
        Function transformer = schemaEvolutionTransformerOpt.map(Pair::getLeft).orElse(Function.identity());
        Schema evolvedSchema = schemaEvolutionTransformerOpt.map(Pair::getRight).orElseGet(dataBlock::getSchema);
        return Pair.of(transformer, evolvedSchema);
    }

    static boolean isCommitTimeOrderingValue(Comparable orderingValue) {
        return orderingValue == null || orderingValue.equals(0);
    }

    static Comparable getOrderingValue(HoodieReaderContext readerContext, DeleteRecord deleteRecord) {
        return HoodieBaseFileGroupRecordBuffer.isCommitTimeOrderingValue(deleteRecord.getOrderingValue()) ? Integer.valueOf(0) : readerContext.convertValueToEngineType(deleteRecord.getOrderingValue());
    }

    private boolean isDeleteRecordWithNaturalOrder(Option<T> rowOption, Comparable orderingValue) {
        return rowOption.isEmpty() && orderingValue.equals(0);
    }

    private boolean isDeleteRecord(Option<T> record, Schema schema) {
        if (record.isEmpty()) {
            return true;
        }
        Object operation = this.readerContext.getValue(record.get(), schema, HoodieRecord.OPERATION_METADATA_FIELD);
        if (operation != null && HoodieOperation.isDeleteRecord(operation.toString())) {
            return true;
        }
        Object deleteMarker = this.readerContext.getValue(record.get(), schema, "_hoodie_is_deleted");
        return deleteMarker instanceof Boolean && (Boolean)deleteMarker != false;
    }
}

