/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public abstract class FileFormatUtils {
    public static <T extends Comparable<T>> HoodieColumnRangeMetadata<T> getColumnRangeInPartition(String relativePartitionPath, @Nonnull List<HoodieColumnRangeMetadata<T>> fileColumnRanges, Map<String, Schema> colsToIndexSchemaMap) {
        ValidationUtils.checkArgument(!fileColumnRanges.isEmpty(), "fileColumnRanges should not be empty.");
        HashMap schemaSeenForColsToIndex = new HashMap();
        HashSet colsWithSchemaEvolved = new HashSet();
        fileColumnRanges.stream().forEach(entry -> {
            String colToIndex = entry.getColumnName();
            Class<?> minValueClass = entry.getMinValue() != null ? entry.getMinValue().getClass() : null;
            Class<?> maxValueClass = entry.getMaxValue() != null ? entry.getMaxValue().getClass() : null;
            schemaSeenForColsToIndex.computeIfAbsent(colToIndex, s -> new HashSet());
            if (minValueClass != null) {
                ((Set)schemaSeenForColsToIndex.get(colToIndex)).add(minValueClass);
            }
            if (maxValueClass != null) {
                ((Set)schemaSeenForColsToIndex.get(colToIndex)).add(maxValueClass);
            }
            if (!colsToIndexSchemaMap.isEmpty() && ((Set)schemaSeenForColsToIndex.get(colToIndex)).size() > 1) {
                colsWithSchemaEvolved.add(colToIndex);
            }
        });
        return fileColumnRanges.stream().map(e -> HoodieColumnRangeMetadata.create(relativePartitionPath, e.getColumnName(), e.getMinValue(), e.getMaxValue(), e.getNullCount(), e.getValueCount(), e.getTotalSize(), e.getTotalUncompressedSize())).reduce((a, b) -> {
            if (colsWithSchemaEvolved.isEmpty() || colsToIndexSchemaMap.isEmpty() || a.getMinValue() == null || a.getMaxValue() == null || b.getMinValue() == null || b.getMaxValue() == null || !colsWithSchemaEvolved.contains(a.getColumnName())) {
                return HoodieColumnRangeMetadata.merge(a, b);
            }
            Schema schema = (Schema)colsToIndexSchemaMap.get(a.getColumnName());
            HoodieColumnRangeMetadata<Comparable<?>> left = HoodieColumnRangeMetadata.create(a.getFilePath(), a.getColumnName(), HoodieTableMetadataUtil.coerceToComparable(schema, a.getMinValue()), HoodieTableMetadataUtil.coerceToComparable(schema, a.getMaxValue()), a.getNullCount(), a.getValueCount(), a.getTotalSize(), a.getTotalUncompressedSize());
            HoodieColumnRangeMetadata<Comparable<?>> right = HoodieColumnRangeMetadata.create(b.getFilePath(), b.getColumnName(), HoodieTableMetadataUtil.coerceToComparable(schema, b.getMinValue()), HoodieTableMetadataUtil.coerceToComparable(schema, b.getMaxValue()), b.getNullCount(), b.getValueCount(), b.getTotalSize(), b.getTotalUncompressedSize());
            return HoodieColumnRangeMetadata.merge(left, right);
        }).orElseThrow(() -> new HoodieException("MergingColumnRanges failed."));
    }

    public Set<String> readRowKeys(HoodieStorage storage2, StoragePath filePath) {
        return this.filterRowKeys(storage2, filePath, new HashSet<String>()).stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    public BloomFilter readBloomFilterFromMetadata(HoodieStorage storage2, StoragePath filePath) {
        Map<String, String> footerVals = this.readFooter(storage2, false, filePath, "org.apache.hudi.bloomfilter", "com.uber.hoodie.bloomfilter", "hoodie_bloom_filter_type_code");
        String footerVal = footerVals.get("org.apache.hudi.bloomfilter");
        if (null == footerVal) {
            footerVal = footerVals.get("com.uber.hoodie.bloomfilter");
        }
        BloomFilter toReturn = null;
        if (footerVal != null) {
            toReturn = footerVals.containsKey("hoodie_bloom_filter_type_code") ? BloomFilterFactory.fromString(footerVal, footerVals.get("hoodie_bloom_filter_type_code")) : BloomFilterFactory.fromString(footerVal, BloomFilterTypeCode.SIMPLE.name());
        }
        return toReturn;
    }

    public String[] readMinMaxRecordKeys(HoodieStorage storage2, StoragePath filePath) {
        Map<String, String> minMaxKeys = this.readFooter(storage2, true, filePath, "hoodie_min_record_key", "hoodie_max_record_key");
        if (minMaxKeys.size() != 2) {
            throw new HoodieException(String.format("Could not read min/max record key out of footer correctly from %s. read) : %s", filePath, minMaxKeys));
        }
        return new String[]{minMaxKeys.get("hoodie_min_record_key"), minMaxKeys.get("hoodie_max_record_key")};
    }

    public abstract List<GenericRecord> readAvroRecords(HoodieStorage var1, StoragePath var2);

    public abstract List<GenericRecord> readAvroRecords(HoodieStorage var1, StoragePath var2, Schema var3);

    public abstract Map<String, String> readFooter(HoodieStorage var1, boolean var2, StoragePath var3, String ... var4);

    public abstract long getRowCount(HoodieStorage var1, StoragePath var2);

    public abstract Set<Pair<String, Long>> filterRowKeys(HoodieStorage var1, StoragePath var2, Set<String> var3);

    public abstract ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage var1, StoragePath var2);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage var1, StoragePath var2, Option<BaseKeyGenerator> var3, Option<String> var4);

    public abstract ClosableIterator<HoodieKey> getHoodieKeyIterator(HoodieStorage var1, StoragePath var2);

    public abstract ClosableIterator<Pair<HoodieKey, Long>> fetchRecordKeysWithPositions(HoodieStorage var1, StoragePath var2, Option<BaseKeyGenerator> var3, Option<String> var4);

    public abstract Schema readAvroSchema(HoodieStorage var1, StoragePath var2);

    public abstract List<HoodieColumnRangeMetadata<Comparable>> readColumnStatsFromMetadata(HoodieStorage var1, StoragePath var2, List<String> var3);

    public abstract HoodieFileFormat getFormat();

    public abstract void writeMetaFile(HoodieStorage var1, StoragePath var2, Properties var3) throws IOException;

    public abstract byte[] serializeRecordsToLogBlock(HoodieStorage var1, List<HoodieRecord> var2, Schema var3, Schema var4, String var5, Map<String, String> var6) throws IOException;

    public static class HoodieKeyIterator
    implements ClosableIterator<HoodieKey> {
        private final ClosableIterator<GenericRecord> nestedItr;
        private final Function<GenericRecord, HoodieKey> func;

        public static HoodieKeyIterator getInstance(ClosableIterator<GenericRecord> nestedItr, Option<BaseKeyGenerator> keyGenerator, Option<String> partitionPathOption) {
            return new HoodieKeyIterator(nestedItr, keyGenerator, partitionPathOption);
        }

        private HoodieKeyIterator(ClosableIterator<GenericRecord> nestedItr, Option<BaseKeyGenerator> keyGenerator, Option<String> partitionPathOption) {
            this.nestedItr = nestedItr;
            this.func = keyGenerator.isPresent() ? retVal -> {
                String recordKey = ((BaseKeyGenerator)keyGenerator.get()).getRecordKey((GenericRecord)retVal);
                String partitionPath = ((BaseKeyGenerator)keyGenerator.get()).getPartitionPath((GenericRecord)retVal);
                return new HoodieKey(recordKey, partitionPath);
            } : retVal -> {
                String recordKey = retVal.get(0).toString();
                String partitionPath = partitionPathOption.orElseGet(() -> retVal.get(1).toString());
                return new HoodieKey(recordKey, partitionPath);
            };
        }

        @Override
        public void close() {
            if (this.nestedItr != null) {
                this.nestedItr.close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nestedItr.hasNext();
        }

        @Override
        public HoodieKey next() {
            return this.func.apply((GenericRecord)this.nestedItr.next());
        }
    }
}

