/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.BitCaskDiskMap;
import org.apache.hudi.common.util.collection.DiskMap;
import org.apache.hudi.common.util.collection.KeyFilteringIterable;
import org.apache.hudi.common.util.collection.RocksDbDiskMap;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ExternalSpillableMap<T extends Serializable, R extends Serializable>
implements Map<T, R>,
Serializable,
Closeable,
KeyFilteringIterable<T, R> {
    private static final int NUMBER_OF_RECORDS_TO_ESTIMATE_PAYLOAD_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(ExternalSpillableMap.class);
    private final long maxInMemorySizeInBytes;
    private final Map<T, R> inMemoryMap = new HashMap<T, R>();
    private volatile transient DiskMap<T, R> diskBasedMap;
    private static final double SIZING_FACTOR_FOR_IN_MEMORY_MAP = 0.8;
    private final SizeEstimator<T> keySizeEstimator;
    private final SizeEstimator<R> valueSizeEstimator;
    private final DiskMapType diskMapType;
    private final boolean isCompressionEnabled;
    private long currentInMemoryMapSize;
    private volatile long estimatedPayloadSize = 0L;
    private final String baseFilePath;

    public ExternalSpillableMap(long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator) throws IOException {
        this(maxInMemorySizeInBytes, baseFilePath, keySizeEstimator, valueSizeEstimator, DiskMapType.BITCASK);
    }

    public ExternalSpillableMap(long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator, DiskMapType diskMapType) throws IOException {
        this(maxInMemorySizeInBytes, baseFilePath, keySizeEstimator, valueSizeEstimator, diskMapType, false);
    }

    public ExternalSpillableMap(long maxInMemorySizeInBytes, String baseFilePath, SizeEstimator<T> keySizeEstimator, SizeEstimator<R> valueSizeEstimator, DiskMapType diskMapType, boolean isCompressionEnabled) throws IOException {
        this.baseFilePath = baseFilePath;
        this.maxInMemorySizeInBytes = (long)Math.floor((double)maxInMemorySizeInBytes * 0.8);
        this.currentInMemoryMapSize = 0L;
        this.keySizeEstimator = keySizeEstimator;
        this.valueSizeEstimator = valueSizeEstimator;
        this.diskMapType = diskMapType;
        this.isCompressionEnabled = isCompressionEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDiskBasedMap() {
        if (null == this.diskBasedMap) {
            ExternalSpillableMap externalSpillableMap = this;
            synchronized (externalSpillableMap) {
                if (null == this.diskBasedMap) {
                    try {
                        switch (this.diskMapType) {
                            case ROCKS_DB: {
                                this.diskBasedMap = new RocksDbDiskMap(this.baseFilePath);
                                break;
                            }
                            default: {
                                this.diskBasedMap = new BitCaskDiskMap(this.baseFilePath, this.isCompressionEnabled);
                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public Iterator<R> iterator() {
        return this.diskBasedMap == null ? this.inMemoryMap.values().iterator() : new IteratorWrapper<R>(this.inMemoryMap.values().iterator(), this.diskBasedMap.iterator());
    }

    @Override
    public Iterator<R> iterator(Predicate<T> filter) {
        return this.diskBasedMap == null ? this.inMemoryMapIterator(filter) : new IteratorWrapper<R>(this.inMemoryMapIterator(filter), this.diskBasedMap.iterator(filter));
    }

    private Iterator<R> inMemoryMapIterator(Predicate<T> filter) {
        return this.inMemoryMap.entrySet().stream().filter(entry -> filter.test(entry.getKey())).map(Map.Entry::getValue).iterator();
    }

    public int getDiskBasedMapNumEntries() {
        return this.diskBasedMap == null ? 0 : this.diskBasedMap.size();
    }

    public long getSizeOfFileOnDiskInBytes() {
        return this.diskBasedMap == null ? 0L : this.diskBasedMap.sizeOfFileOnDiskInBytes();
    }

    public int getInMemoryMapNumEntries() {
        return this.inMemoryMap.size();
    }

    public long getCurrentInMemoryMapSize() {
        return this.currentInMemoryMapSize;
    }

    @Override
    public int size() {
        return this.inMemoryMap.size() + this.getDiskBasedMapNumEntries();
    }

    @Override
    public boolean isEmpty() {
        return this.inMemoryMap.isEmpty() && this.getDiskBasedMapNumEntries() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inMemoryMap.containsKey(key) || this.inDiskContainsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inMemoryMap.containsValue(value) || this.diskBasedMap != null && this.diskBasedMap.containsValue(value);
    }

    private boolean inMemoryContainsKey(Object key) {
        return this.inMemoryMap.containsKey(key);
    }

    private boolean inDiskContainsKey(Object key) {
        return this.diskBasedMap != null && this.diskBasedMap.containsKey(key);
    }

    @Override
    public R get(Object key) {
        if (this.inMemoryMap.containsKey(key)) {
            return (R)((Serializable)this.inMemoryMap.get(key));
        }
        if (this.inDiskContainsKey(key)) {
            return (R)((Serializable)this.diskBasedMap.get(key));
        }
        return null;
    }

    @Override
    public R put(T key, R value) {
        if (this.estimatedPayloadSize == 0L) {
            this.estimatedPayloadSize = this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value);
        } else if (this.inMemoryMap.size() % 100 == 0) {
            this.estimatedPayloadSize = (long)((double)this.estimatedPayloadSize * 0.9 + (double)(this.keySizeEstimator.sizeEstimate(key) + this.valueSizeEstimator.sizeEstimate(value)) * 0.1);
            this.currentInMemoryMapSize = (long)this.inMemoryMap.size() * this.estimatedPayloadSize;
        }
        if (this.inMemoryMap.containsKey(key)) {
            this.inMemoryMap.put(key, value);
        } else if (this.currentInMemoryMapSize < this.maxInMemorySizeInBytes) {
            this.currentInMemoryMapSize += this.estimatedPayloadSize;
            if (this.inDiskContainsKey(key)) {
                this.diskBasedMap.remove(key);
            }
            this.inMemoryMap.put(key, value);
        } else {
            if (this.diskBasedMap == null) {
                this.initDiskBasedMap();
            }
            this.diskBasedMap.put(key, value);
        }
        return value;
    }

    @Override
    public R remove(Object key) {
        if (this.inMemoryMap.containsKey(key)) {
            this.currentInMemoryMapSize -= this.estimatedPayloadSize;
            return (R)((Serializable)this.inMemoryMap.remove(key));
        }
        if (this.inDiskContainsKey(key)) {
            return (R)((Serializable)this.diskBasedMap.remove(key));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> m) {
        for (Map.Entry<T, R> entry : m.entrySet()) {
            this.put((T)((Serializable)entry.getKey()), (R)((Serializable)entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.inMemoryMap.clear();
        if (this.diskBasedMap != null) {
            this.diskBasedMap.clear();
        }
        this.currentInMemoryMapSize = 0L;
    }

    @Override
    public void close() {
        this.inMemoryMap.clear();
        if (this.diskBasedMap != null) {
            this.diskBasedMap.close();
        }
        this.currentInMemoryMapSize = 0L;
    }

    @Override
    public Set<T> keySet() {
        if (this.diskBasedMap == null) {
            return this.inMemoryMap.keySet();
        }
        HashSet<Object> keySet = new HashSet<Object>(this.inMemoryMap.size() + this.diskBasedMap.size());
        keySet.addAll(this.inMemoryMap.keySet());
        keySet.addAll(this.diskBasedMap.keySet());
        return keySet;
    }

    @Override
    public Collection<R> values() {
        if (this.diskBasedMap == null) {
            return this.inMemoryMap.values();
        }
        ArrayList<Object> result2 = new ArrayList<Object>(this.inMemoryMap.size() + this.diskBasedMap.size());
        result2.addAll(this.inMemoryMap.values());
        Iterator iterator2 = this.diskBasedMap.iterator();
        while (iterator2.hasNext()) {
            result2.add(iterator2.next());
        }
        return result2;
    }

    public Stream<R> valueStream() {
        if (this.diskBasedMap == null) {
            return this.inMemoryMap.values().stream();
        }
        return Stream.concat(this.inMemoryMap.values().stream(), this.diskBasedMap.valueStream());
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        if (this.diskBasedMap == null) {
            return this.inMemoryMap.entrySet();
        }
        Set<Map.Entry<T, R>> inMemory = this.inMemoryMap.entrySet();
        Set onDisk = this.diskBasedMap.entrySet();
        HashSet<Map.Entry<T, R>> entrySet = new HashSet<Map.Entry<T, R>>(inMemory.size() + onDisk.size());
        entrySet.addAll(inMemory);
        entrySet.addAll(onDisk);
        return entrySet;
    }

    private class IteratorWrapper<R>
    implements Iterator<R> {
        private final Iterator<R> inMemoryIterator;
        private final Iterator<R> diskLazyFileIterator;

        public IteratorWrapper(Iterator<R> inMemoryIterator, Iterator<R> diskLazyFileIterator) {
            this.inMemoryIterator = inMemoryIterator;
            this.diskLazyFileIterator = diskLazyFileIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.inMemoryIterator.hasNext()) {
                return true;
            }
            return this.diskLazyFileIterator.hasNext();
        }

        @Override
        public R next() {
            if (this.inMemoryIterator.hasNext()) {
                return this.inMemoryIterator.next();
            }
            return this.diskLazyFileIterator.next();
        }
    }

    public static enum DiskMapType {
        BITCASK,
        ROCKS_DB,
        UNKNOWN;

    }
}

