/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.collection.MappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class HoodieJavaRDD<T>
implements HoodieData<T> {
    private final JavaRDD<T> rddData;

    private HoodieJavaRDD(JavaRDD<T> rddData) {
        this.rddData = rddData;
    }

    public static <T> HoodieJavaRDD<T> of(JavaRDD<T> rddData) {
        return new HoodieJavaRDD<T>(rddData);
    }

    public static <T> HoodieJavaRDD<T> of(List<T> data2, HoodieSparkEngineContext context, int parallelism) {
        return new HoodieJavaRDD<T>(context.getJavaSparkContext().parallelize(data2, parallelism));
    }

    public static <T> JavaRDD<T> getJavaRDD(HoodieData<T> hoodieData) {
        return ((HoodieJavaRDD)hoodieData).rddData;
    }

    public static <K, V> JavaPairRDD<K, V> getJavaRDD(HoodiePairData<K, V> hoodieData) {
        return ((HoodieJavaPairRDD)hoodieData).get();
    }

    @Override
    public int getId() {
        return this.rddData.id();
    }

    @Override
    public void persist(String level) {
        this.rddData.persist(StorageLevel.fromString((String)level));
    }

    @Override
    public void persist(String level, HoodieEngineContext engineContext, HoodieData.HoodieDataCacheKey cacheKey) {
        engineContext.putCachedDataIds(cacheKey, this.getId());
        this.rddData.persist(StorageLevel.fromString((String)level));
    }

    @Override
    public void unpersist() {
        this.rddData.unpersist();
    }

    @Override
    public boolean isEmpty() {
        return this.rddData.isEmpty();
    }

    @Override
    public long count() {
        return this.rddData.count();
    }

    @Override
    public int getNumPartitions() {
        return this.rddData.getNumPartitions();
    }

    @Override
    public int deduceNumPartitions() {
        int partPartitions;
        Optional partitioner = this.rddData.partitioner();
        if (partitioner.isPresent() && (partPartitions = ((Partitioner)partitioner.get()).numPartitions()) > 0) {
            return partPartitions;
        }
        if (SQLConf.get().contains(SQLConf.SHUFFLE_PARTITIONS().key())) {
            return Integer.parseInt(SQLConf.get().getConfString(SQLConf.SHUFFLE_PARTITIONS().key()));
        }
        if (this.rddData.context().conf().contains("spark.default.parallelism")) {
            return this.rddData.context().defaultParallelism();
        }
        return this.rddData.getNumPartitions();
    }

    @Override
    public <O> HoodieData<O> map(SerializableFunction<T, O> func) {
        return HoodieJavaRDD.of(this.rddData.map(func::apply));
    }

    @Override
    public <O> HoodieData<O> mapPartitions(SerializableFunction<Iterator<T>, Iterator<O>> func, boolean preservesPartitioning) {
        return HoodieJavaRDD.of(this.rddData.mapPartitions(func::apply, preservesPartitioning));
    }

    @Override
    public <O> HoodieData<O> flatMap(SerializableFunction<T, Iterator<O>> func) {
        return HoodieJavaRDD.of(this.rddData.flatMap((FlatMapFunction & Serializable)e -> (Iterator)func.apply(e)));
    }

    @Override
    public <K, V> HoodiePairData<K, V> flatMapToPair(SerializableFunction<T, Iterator<? extends Pair<K, V>>> func) {
        return HoodieJavaPairRDD.of(this.rddData.flatMapToPair((PairFlatMapFunction & Serializable)e -> new MappingIterator<Pair, Tuple2>((Iterator)func.apply(e), p -> new Tuple2(p.getKey(), p.getValue()))));
    }

    @Override
    public <K, V> HoodiePairData<K, V> mapToPair(SerializablePairFunction<T, K, V> func) {
        return HoodieJavaPairRDD.of(this.rddData.mapToPair((PairFunction & Serializable)input -> {
            Pair pair = func.call(input);
            return new Tuple2(pair.getLeft(), pair.getRight());
        }));
    }

    @Override
    public HoodieData<T> distinct() {
        return HoodieJavaRDD.of(this.rddData.distinct());
    }

    @Override
    public HoodieData<T> distinct(int parallelism) {
        return HoodieJavaRDD.of(this.rddData.distinct(parallelism));
    }

    @Override
    public HoodieData<T> filter(SerializableFunction<T, Boolean> filterFunc) {
        return HoodieJavaRDD.of(this.rddData.filter(filterFunc::apply));
    }

    @Override
    public HoodieData<T> union(HoodieData<T> other) {
        return HoodieJavaRDD.of(this.rddData.union(((HoodieJavaRDD)other).rddData));
    }

    @Override
    public List<T> collectAsList() {
        return this.rddData.collect();
    }

    @Override
    public HoodieData<T> repartition(int parallelism) {
        return HoodieJavaRDD.of(this.rddData.repartition(parallelism));
    }
}

