/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.utils.HoodieArrayWritableAvroUtils;
import org.apache.hudi.hadoop.utils.ObjectInspectorCache;
import org.apache.hudi.keygen.BaseKeyGenerator;

public class HoodieHiveRecord
extends HoodieRecord<ArrayWritable> {
    private boolean copy;
    private final boolean isDeleted;
    private final ArrayWritableObjectInspector objectInspector;
    private final ObjectInspectorCache objectInspectorCache;
    protected Schema schema;

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public HoodieHiveRecord(HoodieKey key, ArrayWritable data2, Schema schema, ObjectInspectorCache objectInspectorCache) {
        super(key, data2);
        this.objectInspector = objectInspectorCache.getObjectInspector(schema);
        this.objectInspectorCache = objectInspectorCache;
        this.schema = schema;
        this.copy = false;
        this.isDeleted = data2 == null;
    }

    private HoodieHiveRecord(HoodieKey key, ArrayWritable data2, Schema schema, HoodieOperation operation, boolean isCopy, ArrayWritableObjectInspector objectInspector, ObjectInspectorCache objectInspectorCache) {
        super(key, data2, operation, Option.empty());
        this.schema = schema;
        this.copy = isCopy;
        this.isDeleted = data2 == null;
        this.objectInspector = objectInspector;
        this.objectInspectorCache = objectInspectorCache;
    }

    @Override
    public HoodieRecord<ArrayWritable> newInstance() {
        return new HoodieHiveRecord(this.key, (ArrayWritable)this.data, this.schema, this.operation, this.copy, this.objectInspector, this.objectInspectorCache);
    }

    @Override
    public HoodieRecord<ArrayWritable> newInstance(HoodieKey key, HoodieOperation op) {
        throw new UnsupportedOperationException("ObjectInspector is needed for HoodieHiveRecord");
    }

    @Override
    public HoodieRecord<ArrayWritable> newInstance(HoodieKey key) {
        throw new UnsupportedOperationException("ObjectInspector is needed for HoodieHiveRecord");
    }

    @Override
    public Comparable<?> getOrderingValue(Schema recordSchema, Properties props) {
        String orderingField = ConfigUtils.getOrderingField(props);
        if (StringUtils.isNullOrEmpty(orderingField)) {
            return 0;
        }
        return (Comparable)this.getValue(orderingField);
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.HIVE;
    }

    @Override
    public String getRecordKey(Schema recordSchema, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    protected void writeRecordPayload(ArrayWritable payload, Kryo kryo, Output output) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    protected ArrayWritable readRecordPayload(Kryo kryo, Input input) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        Object[] objects = new Object[columns.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.getValue(columns[i]);
        }
        return objects;
    }

    @Override
    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public boolean isDelete(Schema recordSchema, Properties props) throws IOException {
        if (null == this.data) {
            return true;
        }
        if (recordSchema.getField("_hoodie_is_deleted") == null) {
            return false;
        }
        Object deleteMarker = this.getValue("_hoodie_is_deleted");
        return deleteMarker instanceof BooleanWritable && ((BooleanWritable)deleteMarker).get();
    }

    @Override
    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        return false;
    }

    @Override
    public HoodieRecord<ArrayWritable> copy() {
        if (!this.copy) {
            this.data = new ArrayWritable(Writable.class, Arrays.copyOf(((ArrayWritable)this.data).get(), ((ArrayWritable)this.data).get().length));
            this.copy = true;
        }
        return this;
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        return Option.empty();
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFieldsOp, Option<Schema> schemaWithoutMetaFields) throws IOException {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, Option<BaseKeyGenerator> keyGen) {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    @Override
    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) throws IOException {
        ((ArrayWritable)this.data).get()[recordSchema.getIndexNamed((String)keyFieldName).intValue()] = new Text();
        return this;
    }

    @Override
    public Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties props) throws IOException {
        throw new UnsupportedOperationException("Not supported for HoodieHiveRecord");
    }

    private Object getValue(String name2) {
        return HoodieArrayWritableAvroUtils.getWritableValue((ArrayWritable)this.data, this.objectInspector, name2);
    }

    protected Schema getSchema() {
        return this.schema;
    }
}

