/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.function.Function;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieConsistentBucketIndex
extends HoodieBucketIndex {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieConsistentBucketIndex.class);

    public HoodieConsistentBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        throw new HoodieIndexException("Consistent hashing index does not support update location without the instant parameter");
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    protected Function<HoodieRecord, Option<HoodieRecordLocation>> getIndexLocationFunctionForPartition(HoodieTable table, String partitionPath) {
        return new ConsistentBucketIndexLocationFunction(table, partitionPath);
    }

    private class ConsistentBucketIndexLocationFunction
    implements Function<HoodieRecord, Option<HoodieRecordLocation>> {
        private final String partitionPath;
        private final ConsistentBucketIdentifier identifier;

        public ConsistentBucketIndexLocationFunction(HoodieTable table, String partition) {
            this.partitionPath = partition;
            HoodieConsistentHashingMetadata metadata2 = ConsistentBucketIndexUtils.loadOrCreateMetadata(table, partition, HoodieConsistentBucketIndex.this.getNumBuckets());
            this.identifier = new ConsistentBucketIdentifier(metadata2);
        }

        @Override
        public Option<HoodieRecordLocation> apply(HoodieRecord record) {
            HoodieKey recordKey = record.getKey();
            ConsistentHashingNode node = this.identifier.getBucket(recordKey, HoodieConsistentBucketIndex.this.indexKeyFields);
            if (!StringUtils.isNullOrEmpty(node.getFileIdPrefix())) {
                return Option.of(new HoodieRecordLocation(null, FSUtils.createNewFileId(node.getFileIdPrefix(), 0)));
            }
            LOG.error("Consistent hashing node has no file group, partition: {}, meta: {}, record_key: {}", new Object[]{this.partitionPath, this.identifier.getMetadata().getFilename(), recordKey});
            throw new HoodieIndexException("Failed to getBucket as hashing node has no file group");
        }
    }
}

