/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.hadoop.HoodieAvroParquetReaderIterator;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.HoodieAvroParquetReaderBuilder;
import org.apache.parquet.hadoop.ParquetReader;

public class HoodieAvroParquetReader
extends HoodieAvroFileReader {
    private final StoragePath path;
    private final HoodieStorage storage;
    private final FileFormatUtils parquetUtils;
    private final List<ParquetReaderIterator> readerIterators = new ArrayList<ParquetReaderIterator>();
    private Option<Schema> fileSchema = Option.empty();

    public HoodieAvroParquetReader(HoodieStorage storage2, StoragePath path) {
        this.storage = storage2.newInstance(path, HoodieAvroParquetReader.tryOverrideDefaultConfigs(storage2.getConf().newInstance()));
        this.path = path;
        this.parquetUtils = HoodieIOFactory.getIOFactory(storage2).getFileFormatUtils(HoodieFileFormat.PARQUET);
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordIterator(Schema readerSchema) throws IOException {
        ClosableIterator<IndexedRecord> iterator2 = this.getIndexedRecordIterator(readerSchema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator2, data2 -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data2)));
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.storage, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.storage, this.path);
    }

    @Override
    public Set<Pair<String, Long>> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.storage, this.path, candidateRowKeys);
    }

    @Override
    protected ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema schema) throws IOException {
        return this.getIndexedRecordIteratorInternal(schema);
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        return this.getIndexedRecordIteratorInternal(requestedSchema);
    }

    @Override
    public Schema getSchema() {
        if (this.fileSchema.isEmpty()) {
            this.fileSchema = Option.ofNullable(this.parquetUtils.readAvroSchema(this.storage, this.path));
        }
        return this.fileSchema.get();
    }

    @Override
    public void close() {
        this.readerIterators.forEach(ParquetReaderIterator::close);
    }

    @Override
    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.storage, this.path);
    }

    private static StorageConfiguration<?> tryOverrideDefaultConfigs(StorageConfiguration<?> conf) {
        if (conf.getString("parquet.avro.add-list-element-records").isEmpty()) {
            conf.set("parquet.avro.add-list-element-records", "false");
        }
        if (conf.getString("parquet.strict.typing").isEmpty()) {
            conf.set("parquet.strict.typing", "false");
        }
        return conf;
    }

    private ClosableIterator<IndexedRecord> getIndexedRecordIteratorInternal(Schema schema) throws IOException {
        Configuration hadoopConf = this.storage.getConf().unwrapCopyAs(Configuration.class);
        Option<Object> promotedSchema = Option.empty();
        if (HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(this.getSchema(), schema)) {
            AvroReadSupport.setAvroReadSchema(hadoopConf, this.getSchema());
            AvroReadSupport.setRequestedProjection(hadoopConf, this.getSchema());
            promotedSchema = Option.of(schema);
        } else {
            AvroReadSupport.setAvroReadSchema(hadoopConf, schema);
            AvroReadSupport.setRequestedProjection(hadoopConf, schema);
        }
        ParquetReader reader = new HoodieAvroParquetReaderBuilder(this.path).withConf(hadoopConf).set("parquet.avro.add-list-element-records", hadoopConf.get("parquet.avro.add-list-element-records")).set("parquet.strict.typing", hadoopConf.get("parquet.strict.typing")).build();
        ParquetReaderIterator parquetReaderIterator = promotedSchema.isPresent() ? new HoodieAvroParquetReaderIterator((ParquetReader<IndexedRecord>)reader, (Schema)promotedSchema.get()) : new ParquetReaderIterator(reader);
        this.readerIterators.add(parquetReaderIterator);
        return parquetReaderIterator;
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        final ClosableIterator<IndexedRecord> recordKeyIterator = this.getIndexedRecordIterator(HoodieAvroUtils.getRecordKeySchema());
        return new ClosableIterator<String>(){

            @Override
            public boolean hasNext() {
                return recordKeyIterator.hasNext();
            }

            @Override
            public String next() {
                Object obj = recordKeyIterator.next();
                return ((GenericRecord)obj).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            }

            @Override
            public void close() {
                recordKeyIterator.close();
            }
        };
    }
}

