/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieSparkBootstrapFileReader;
import org.apache.hudi.io.storage.HoodieSparkParquetReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.internal.SQLConf;

public class HoodieSparkFileReaderFactory
extends HoodieFileReaderFactory {
    public HoodieSparkFileReaderFactory(HoodieStorage storage2) {
        super(storage2);
    }

    @Override
    public HoodieFileReader newParquetFileReader(StoragePath path) {
        this.storage.getConf().setIfUnset(SQLConf.PARQUET_BINARY_AS_STRING().key(), SQLConf.PARQUET_BINARY_AS_STRING().defaultValueString());
        this.storage.getConf().setIfUnset(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), SQLConf.PARQUET_INT96_AS_TIMESTAMP().defaultValueString());
        this.storage.getConf().setIfUnset(SQLConf.CASE_SENSITIVE().key(), SQLConf.CASE_SENSITIVE().defaultValueString());
        this.storage.getConf().setIfUnset("spark.sql.legacy.parquet.nanosAsLong", "false");
        this.storage.getConf().setIfUnset("spark.sql.parquet.inferTimestampNTZ.enabled", "true");
        return new HoodieSparkParquetReader(this.storage, path);
    }

    @Override
    protected HoodieFileReader newHFileFileReader(HoodieConfig hoodieConfig, StoragePath path, Option<Schema> schemaOption) throws IOException {
        throw new HoodieIOException("Not support read HFile");
    }

    @Override
    protected HoodieFileReader newOrcFileReader(StoragePath path) {
        throw new HoodieIOException("Not support read orc file");
    }

    @Override
    public HoodieFileReader newBootstrapFileReader(HoodieFileReader skeletonFileReader, HoodieFileReader dataFileReader, Option<String[]> partitionFields, Object[] partitionValues) {
        return new HoodieSparkBootstrapFileReader(skeletonFileReader, dataFileReader, partitionFields, partitionValues);
    }
}

