/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordDelegate;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriterFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRowCreateHandle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRowCreateHandle.class);
    private static final AtomicLong GLOBAL_SEQ_NO = new AtomicLong(1L);
    private final HoodieTable table;
    private final HoodieWriteConfig writeConfig;
    private final String partitionPath;
    private final StoragePath path;
    private final String fileId;
    private final boolean populateMetaFields;
    private final UTF8String fileName;
    private final UTF8String commitTime;
    private final Function<Long, String> seqIdGenerator;
    private final boolean shouldPreserveHoodieMetadata;
    private final HoodieTimer currTimer;
    protected final HoodieInternalRowFileWriter fileWriter;
    protected final WriteStatus writeStatus;
    private final HoodieRecordLocation newRecordLocation;

    public HoodieRowCreateHandle(HoodieTable table, HoodieWriteConfig writeConfig, String partitionPath, String fileId, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType) {
        this(table, writeConfig, partitionPath, fileId, instantTime, taskPartitionId, taskId, taskEpochId, structType, false);
    }

    public HoodieRowCreateHandle(HoodieTable table, HoodieWriteConfig writeConfig, String partitionPath, String fileId, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean shouldPreserveHoodieMetadata) {
        this.partitionPath = partitionPath;
        this.table = table;
        this.writeConfig = writeConfig;
        this.fileId = fileId;
        this.newRecordLocation = new HoodieRecordLocation(instantTime, fileId);
        this.currTimer = HoodieTimer.start();
        HoodieStorage storage2 = table.getStorage();
        String writeToken = HoodieRowCreateHandle.getWriteToken(taskPartitionId, taskId, taskEpochId);
        String fileName = FSUtils.makeBaseFileName(instantTime, writeToken, this.fileId, table.getBaseFileExtension());
        this.path = HoodieRowCreateHandle.makeNewPath(storage2, partitionPath, fileName, writeConfig);
        this.populateMetaFields = writeConfig.populateMetaFields();
        this.fileName = UTF8String.fromString((String)this.path.getName());
        this.commitTime = UTF8String.fromString((String)instantTime);
        this.seqIdGenerator = id -> HoodieRecord.generateSequenceId(instantTime, taskPartitionId, id);
        this.writeStatus = new WriteStatus(table.shouldTrackSuccessRecords(), writeConfig.getWriteStatusFailureFraction());
        this.shouldPreserveHoodieMetadata = shouldPreserveHoodieMetadata;
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setStat(new HoodieWriteStat());
        try {
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(storage2, instantTime, new StoragePath(writeConfig.getBasePath()), FSUtils.constructAbsolutePath(writeConfig.getBasePath(), partitionPath), table.getPartitionMetafileFormat());
            partitionMetadata.trySave();
            HoodieRowCreateHandle.createMarkerFile(partitionPath, fileName, instantTime, table, writeConfig);
            this.fileWriter = HoodieInternalRowFileWriterFactory.getInternalRowFileWriter(this.path, table, writeConfig, structType);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize file writer for path " + this.path, e);
        }
        LOG.info("New handle created for partition: {} with fileId {}", (Object)partitionPath, (Object)fileId);
    }

    public void write(InternalRow row) throws IOException {
        if (this.populateMetaFields) {
            this.writeRow(row);
        } else {
            this.writeRowNoMetaFields(row);
        }
    }

    private void writeRow(InternalRow row) {
        try {
            UTF8String recordKey = row.getUTF8String(HoodieRecord.RECORD_KEY_META_FIELD_ORD);
            UTF8String partitionPath = row.getUTF8String(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
            UTF8String seqId = this.shouldPreserveHoodieMetadata ? row.getUTF8String(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD_ORD) : UTF8String.fromString((String)this.seqIdGenerator.apply(GLOBAL_SEQ_NO.getAndIncrement()));
            UTF8String writeCommitTime = this.shouldPreserveHoodieMetadata ? row.getUTF8String(HoodieRecord.COMMIT_TIME_METADATA_FIELD_ORD) : this.commitTime;
            HoodieInternalRow updatedRow = new HoodieInternalRow(writeCommitTime, seqId, recordKey, partitionPath, this.fileName, row, true);
            try {
                this.fileWriter.writeRow(recordKey, updatedRow);
                HoodieRecordDelegate recordDelegate = this.writeStatus.isTrackingSuccessfulWrites() ? HoodieRecordDelegate.create(recordKey.toString(), partitionPath.toString(), null, this.newRecordLocation) : null;
                this.writeStatus.markSuccess(recordDelegate, Option.empty());
            }
            catch (Exception t) {
                this.writeStatus.markFailure(recordKey.toString(), partitionPath.toString(), t);
            }
        }
        catch (Exception e) {
            this.writeStatus.setGlobalError(e);
            throw e;
        }
    }

    private void writeRowNoMetaFields(InternalRow row) {
        try {
            this.fileWriter.writeRow(row);
            this.writeStatus.markSuccess((HoodieRecordDelegate)null, Option.empty());
        }
        catch (Exception e) {
            this.writeStatus.setGlobalError(e);
            throw new HoodieException("Exception thrown while writing spark InternalRows to file ", e);
        }
    }

    public boolean canWrite() {
        return this.fileWriter.canWrite();
    }

    public WriteStatus close() throws IOException {
        this.fileWriter.close();
        HoodieWriteStat stat = this.writeStatus.getStat();
        stat.setPartitionPath(this.partitionPath);
        stat.setNumWrites(this.writeStatus.getTotalRecords());
        stat.setNumDeletes(0L);
        stat.setNumInserts(this.writeStatus.getTotalRecords());
        stat.setPrevCommit("null");
        stat.setFileId(this.fileId);
        stat.setPath(new StoragePath(this.writeConfig.getBasePath()), this.path);
        long fileSizeInBytes = FSUtils.getFileSize(this.table.getStorage(), this.path);
        stat.setTotalWriteBytes(fileSizeInBytes);
        stat.setFileSizeInBytes(fileSizeInBytes);
        stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
        for (Pair<HoodieRecordDelegate, Throwable> pair : this.writeStatus.getFailedRecords()) {
            LOG.error("Failed to write {}", (Object)pair.getLeft(), (Object)pair.getRight());
        }
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalCreateTime(this.currTimer.endTimer());
        stat.setRuntimeStats(runtimeStats);
        return this.writeStatus;
    }

    public String getFileName() {
        return this.path.getName();
    }

    private static StoragePath makeNewPath(HoodieStorage storage2, String partitionPath, String fileName, HoodieWriteConfig writeConfig) {
        StoragePath path = new StoragePath(writeConfig.getBasePath(), partitionPath);
        try {
            if (!storage2.exists(path)) {
                storage2.createDirectory(path);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new StoragePath(path, fileName);
    }

    private static void createMarkerFile(String partitionPath, String dataFileName, String instantTime, HoodieTable<?, ?, ?, ?> table, HoodieWriteConfig writeConfig) {
        WriteMarkersFactory.get(writeConfig.getMarkersType(), table, instantTime).create(partitionPath, dataFileName, IOType.CREATE);
    }

    private static String getWriteToken(int taskPartitionId, long taskId, long taskEpochId) {
        return taskPartitionId + "-" + taskId + "-" + taskEpochId;
    }
}

