/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class FilterWrapper
extends Filter {
    Filter filter = null;

    public FilterWrapper(Filter filter) {
        if (null == filter) {
            throw new NullPointerException("Cannot create FilterWrapper with null Filter");
        }
        this.filter = filter;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.FilterWrapper.Builder builder = FilterProtos.FilterWrapper.newBuilder();
        builder.setFilter(ProtobufUtil.toFilter(this.filter));
        return builder.build().toByteArray();
    }

    public static FilterWrapper parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FilterWrapper proto;
        try {
            proto = FilterProtos.FilterWrapper.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        try {
            return new FilterWrapper(ProtobufUtil.toFilter(proto.getFilter()));
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
    }

    @Override
    public void reset() throws IOException {
        this.filter.reset();
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        return this.filter.filterAllRemaining();
    }

    @Override
    public boolean filterRow() throws IOException {
        return this.filter.filterRow();
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) throws IOException {
        return this.filter.getNextCellHint(currentCell);
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
        if (this.filterAllRemaining()) {
            return true;
        }
        return this.filter.filterRowKey(buffer, offset, length);
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        if (this.filterAllRemaining()) {
            return true;
        }
        return this.filter.filterRowKey(cell);
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) throws IOException {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) throws IOException {
        return this.filter.filterCell(c);
    }

    @Override
    public Cell transformCell(Cell v) throws IOException {
        return this.filter.transformCell(v);
    }

    @Override
    public boolean hasFilterRow() {
        return this.filter.hasFilterRow();
    }

    @Override
    public void filterRowCells(List<Cell> kvs) throws IOException {
        this.filterRowCellsWithRet(kvs);
    }

    public FilterRowRetCode filterRowCellsWithRet(List<Cell> kvs) throws IOException {
        this.filter.filterRowCells(kvs);
        if (!kvs.isEmpty()) {
            if (this.filter.filterRow()) {
                kvs.clear();
                return FilterRowRetCode.EXCLUDE;
            }
            return FilterRowRetCode.INCLUDE;
        }
        return FilterRowRetCode.NOT_CALLED;
    }

    @Override
    public boolean isFamilyEssential(byte[] name2) throws IOException {
        return this.filter.isFamilyEssential(name2);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterWrapper)) {
            return false;
        }
        FilterWrapper other = (FilterWrapper)o;
        return this.filter.areSerializedFieldsEqual(other.filter);
    }

    public static enum FilterRowRetCode {
        NOT_CALLED,
        INCLUDE,
        EXCLUDE,
        INCLUDE_THIS_FAMILY;

    }
}

