/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockPriority;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.PersistentIOEngine;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.BucketCacheProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class BucketProtoUtils {
    private BucketProtoUtils() {
    }

    static BucketCacheProtos.BucketCacheEntry toPB(BucketCache cache) {
        return BucketCacheProtos.BucketCacheEntry.newBuilder().setCacheCapacity(cache.getMaxSize()).setIoClass(cache.ioEngine.getClass().getName()).setMapClass(cache.backingMap.getClass().getName()).putAllDeserializers(CacheableDeserializerIdManager.save()).setBackingMap(BucketProtoUtils.toPB(cache.backingMap)).setChecksum(ByteString.copyFrom(((PersistentIOEngine)cache.ioEngine).calculateChecksum(cache.getAlgorithm()))).build();
    }

    private static BucketCacheProtos.BackingMap toPB(Map<BlockCacheKey, BucketEntry> backingMap) {
        BucketCacheProtos.BackingMap.Builder builder = BucketCacheProtos.BackingMap.newBuilder();
        for (Map.Entry<BlockCacheKey, BucketEntry> entry : backingMap.entrySet()) {
            builder.addEntry(BucketCacheProtos.BackingMapEntry.newBuilder().setKey(BucketProtoUtils.toPB(entry.getKey())).setValue(BucketProtoUtils.toPB(entry.getValue())).build());
        }
        return builder.build();
    }

    private static BucketCacheProtos.BlockCacheKey toPB(BlockCacheKey key) {
        return BucketCacheProtos.BlockCacheKey.newBuilder().setHfilename(key.getHfileName()).setOffset(key.getOffset()).setPrimaryReplicaBlock(key.isPrimary()).setBlockType(BucketProtoUtils.toPB(key.getBlockType())).build();
    }

    private static BucketCacheProtos.BlockType toPB(BlockType blockType) {
        switch (blockType) {
            case DATA: {
                return BucketCacheProtos.BlockType.data;
            }
            case META: {
                return BucketCacheProtos.BlockType.meta;
            }
            case TRAILER: {
                return BucketCacheProtos.BlockType.trailer;
            }
            case INDEX_V1: {
                return BucketCacheProtos.BlockType.index_v1;
            }
            case FILE_INFO: {
                return BucketCacheProtos.BlockType.file_info;
            }
            case LEAF_INDEX: {
                return BucketCacheProtos.BlockType.leaf_index;
            }
            case ROOT_INDEX: {
                return BucketCacheProtos.BlockType.root_index;
            }
            case BLOOM_CHUNK: {
                return BucketCacheProtos.BlockType.bloom_chunk;
            }
            case ENCODED_DATA: {
                return BucketCacheProtos.BlockType.encoded_data;
            }
            case GENERAL_BLOOM_META: {
                return BucketCacheProtos.BlockType.general_bloom_meta;
            }
            case INTERMEDIATE_INDEX: {
                return BucketCacheProtos.BlockType.intermediate_index;
            }
            case DELETE_FAMILY_BLOOM_META: {
                return BucketCacheProtos.BlockType.delete_family_bloom_meta;
            }
        }
        throw new Error("Unrecognized BlockType.");
    }

    private static BucketCacheProtos.BucketEntry toPB(BucketEntry entry) {
        return BucketCacheProtos.BucketEntry.newBuilder().setOffset(entry.offset()).setLength(entry.getLength()).setDeserialiserIndex(entry.deserializerIndex).setAccessCounter(entry.getAccessCounter()).setPriority(BucketProtoUtils.toPB(entry.getPriority())).build();
    }

    private static BucketCacheProtos.BlockPriority toPB(BlockPriority p) {
        switch (p) {
            case MULTI: {
                return BucketCacheProtos.BlockPriority.multi;
            }
            case MEMORY: {
                return BucketCacheProtos.BlockPriority.memory;
            }
            case SINGLE: {
                return BucketCacheProtos.BlockPriority.single;
            }
        }
        throw new Error("Unrecognized BlockPriority.");
    }

    static ConcurrentHashMap<BlockCacheKey, BucketEntry> fromPB(Map<Integer, String> deserializers, BucketCacheProtos.BackingMap backingMap, Function<BucketEntry, ByteBuffAllocator.Recycler> createRecycler) throws IOException {
        ConcurrentHashMap<BlockCacheKey, BucketEntry> result2 = new ConcurrentHashMap<BlockCacheKey, BucketEntry>();
        for (BucketCacheProtos.BackingMapEntry entry : backingMap.getEntryList()) {
            BucketCacheProtos.BlockCacheKey protoKey = entry.getKey();
            BlockCacheKey key = new BlockCacheKey(protoKey.getHfilename(), protoKey.getOffset(), protoKey.getPrimaryReplicaBlock(), BucketProtoUtils.fromPb(protoKey.getBlockType()));
            BucketCacheProtos.BucketEntry protoValue = entry.getValue();
            BucketEntry value = new BucketEntry(protoValue.getOffset(), protoValue.getLength(), protoValue.getAccessCounter(), protoValue.getPriority() == BucketCacheProtos.BlockPriority.memory, createRecycler, ByteBuffAllocator.HEAP);
            int oldIndex = protoValue.getDeserialiserIndex();
            String deserializerClass = deserializers.get(oldIndex);
            if (deserializerClass == null) {
                throw new IOException("Found deserializer index without matching entry.");
            }
            if (!deserializerClass.equals(HFileBlock.BlockDeserializer.class.getName())) {
                throw new IOException("Unknown deserializer class found: " + deserializerClass);
            }
            int actualIndex = HFileBlock.BLOCK_DESERIALIZER.getDeserializerIdentifier();
            value.deserializerIndex = (byte)actualIndex;
            result2.put(key, value);
        }
        return result2;
    }

    private static BlockType fromPb(BucketCacheProtos.BlockType blockType) {
        switch (blockType) {
            case data: {
                return BlockType.DATA;
            }
            case meta: {
                return BlockType.META;
            }
            case trailer: {
                return BlockType.TRAILER;
            }
            case index_v1: {
                return BlockType.INDEX_V1;
            }
            case file_info: {
                return BlockType.FILE_INFO;
            }
            case leaf_index: {
                return BlockType.LEAF_INDEX;
            }
            case root_index: {
                return BlockType.ROOT_INDEX;
            }
            case bloom_chunk: {
                return BlockType.BLOOM_CHUNK;
            }
            case encoded_data: {
                return BlockType.ENCODED_DATA;
            }
            case general_bloom_meta: {
                return BlockType.GENERAL_BLOOM_META;
            }
            case intermediate_index: {
                return BlockType.INTERMEDIATE_INDEX;
            }
            case delete_family_bloom_meta: {
                return BlockType.DELETE_FAMILY_BLOOM_META;
            }
        }
        throw new Error("Unrecognized BlockType.");
    }
}

