/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hudi.org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SnapshotOfRegionAssignmentFromMeta {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapshotOfRegionAssignmentFromMeta.class.getName());
    private final Connection connection;
    private final Map<TableName, List<RegionInfo>> tableToRegionMap;
    private Map<RegionInfo, ServerName> regionToRegionServerMap;
    private final Map<String, RegionInfo> regionNameToRegionInfoMap;
    private final Map<ServerName, List<RegionInfo>> currentRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> secondaryRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> teritiaryRSToRegionMap;
    private final Map<ServerName, List<RegionInfo>> primaryRSToRegionMap;
    private final FavoredNodesPlan existingAssignmentPlan;
    private final Set<TableName> disabledTables;
    private final boolean excludeOfflinedSplitParents;

    public SnapshotOfRegionAssignmentFromMeta(Connection connection) {
        this(connection, new HashSet<TableName>(), false);
    }

    public SnapshotOfRegionAssignmentFromMeta(Connection connection, Set<TableName> disabledTables, boolean excludeOfflinedSplitParents) {
        this.connection = connection;
        this.tableToRegionMap = new HashMap<TableName, List<RegionInfo>>();
        this.regionToRegionServerMap = new HashMap<RegionInfo, ServerName>();
        this.currentRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.primaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.secondaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.teritiaryRSToRegionMap = new HashMap<ServerName, List<RegionInfo>>();
        this.regionNameToRegionInfoMap = new TreeMap<String, RegionInfo>();
        this.existingAssignmentPlan = new FavoredNodesPlan();
        this.disabledTables = disabledTables;
        this.excludeOfflinedSplitParents = excludeOfflinedSplitParents;
    }

    public void initialize() throws IOException {
        LOG.info("Start to scan the hbase:meta for the current region assignment snappshot");
        MetaTableAccessor.Visitor v = new MetaTableAccessor.Visitor(){

            @Override
            public boolean visit(Result result2) throws IOException {
                try {
                    if (result2 == null || result2.isEmpty()) {
                        return true;
                    }
                    RegionLocations rl = MetaTableAccessor.getRegionLocations(result2);
                    if (rl == null) {
                        return true;
                    }
                    HRegionInfo hri = rl.getRegionLocation(0).getRegionInfo();
                    if (hri == null) {
                        return true;
                    }
                    if (hri.getTable() == null) {
                        return true;
                    }
                    if (SnapshotOfRegionAssignmentFromMeta.this.disabledTables.contains(hri.getTable())) {
                        return true;
                    }
                    if (SnapshotOfRegionAssignmentFromMeta.this.excludeOfflinedSplitParents && hri.isSplit()) {
                        return true;
                    }
                    HRegionLocation[] hrls = rl.getRegionLocations();
                    for (int i = 0; i < hrls.length; ++i) {
                        if (hrls[i] == null || (hri = hrls[i].getRegionInfo()) == null) continue;
                        SnapshotOfRegionAssignmentFromMeta.this.addAssignment(hri, hrls[i].getServerName());
                        SnapshotOfRegionAssignmentFromMeta.this.addRegion(hri);
                    }
                    hri = rl.getRegionLocation(0).getRegionInfo();
                    byte[] favoredNodes = result2.getValue(HConstants.CATALOG_FAMILY, FavoredNodeAssignmentHelper.FAVOREDNODES_QUALIFIER);
                    if (favoredNodes == null) {
                        return true;
                    }
                    Object[] favoredServerList = FavoredNodeAssignmentHelper.getFavoredNodesList(favoredNodes);
                    SnapshotOfRegionAssignmentFromMeta.this.existingAssignmentPlan.updateFavoredNodesMap(hri, Arrays.asList(favoredServerList));
                    if (favoredServerList.length != 3) {
                        LOG.warn("Insufficient favored nodes for region " + hri + " fn: " + Arrays.toString(favoredServerList));
                    }
                    for (int i = 0; i < favoredServerList.length; ++i) {
                        if (i == FavoredNodesPlan.Position.PRIMARY.ordinal()) {
                            SnapshotOfRegionAssignmentFromMeta.this.addPrimaryAssignment(hri, (ServerName)favoredServerList[i]);
                        }
                        if (i == FavoredNodesPlan.Position.SECONDARY.ordinal()) {
                            SnapshotOfRegionAssignmentFromMeta.this.addSecondaryAssignment(hri, (ServerName)favoredServerList[i]);
                        }
                        if (i != FavoredNodesPlan.Position.TERTIARY.ordinal()) continue;
                        SnapshotOfRegionAssignmentFromMeta.this.addTeritiaryAssignment(hri, (ServerName)favoredServerList[i]);
                    }
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error("Catche remote exception " + e.getMessage() + " when processing" + result2);
                    throw e;
                }
            }
        };
        MetaTableAccessor.fullScanRegions(this.connection, v);
        LOG.info("Finished to scan the hbase:meta for the current region assignmentsnapshot");
    }

    private void addRegion(RegionInfo regionInfo) {
        this.regionNameToRegionInfoMap.put(regionInfo.getRegionNameAsString(), regionInfo);
        TableName tableName = regionInfo.getTable();
        List<RegionInfo> regionList = this.tableToRegionMap.get(tableName);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.tableToRegionMap.put(tableName, regionList);
    }

    private void addAssignment(RegionInfo regionInfo, ServerName server) {
        this.regionToRegionServerMap.put(regionInfo, server);
        if (server == null) {
            return;
        }
        List<RegionInfo> regionList = this.currentRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.currentRSToRegionMap.put(server, regionList);
    }

    private void addPrimaryAssignment(RegionInfo regionInfo, ServerName server) {
        List<RegionInfo> regionList = this.primaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.primaryRSToRegionMap.put(server, regionList);
    }

    private void addSecondaryAssignment(RegionInfo regionInfo, ServerName server) {
        List<RegionInfo> regionList = this.secondaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.secondaryRSToRegionMap.put(server, regionList);
    }

    private void addTeritiaryAssignment(RegionInfo regionInfo, ServerName server) {
        List<RegionInfo> regionList = this.teritiaryRSToRegionMap.get(server);
        if (regionList == null) {
            regionList = new ArrayList<RegionInfo>();
        }
        regionList.add(regionInfo);
        this.teritiaryRSToRegionMap.put(server, regionList);
    }

    public Map<String, RegionInfo> getRegionNameToRegionInfoMap() {
        return this.regionNameToRegionInfoMap;
    }

    public Map<TableName, List<RegionInfo>> getTableToRegionMap() {
        return this.tableToRegionMap;
    }

    public Map<RegionInfo, ServerName> getRegionToRegionServerMap() {
        return this.regionToRegionServerMap;
    }

    public Map<ServerName, List<RegionInfo>> getRegionServerToRegionMap() {
        return this.currentRSToRegionMap;
    }

    public FavoredNodesPlan getExistingAssignmentPlan() {
        return this.existingAssignmentPlan;
    }

    public Set<TableName> getTableSet() {
        return this.tableToRegionMap.keySet();
    }

    public Map<ServerName, List<RegionInfo>> getSecondaryToRegionInfoMap() {
        return this.secondaryRSToRegionMap;
    }

    public Map<ServerName, List<RegionInfo>> getTertiaryToRegionInfoMap() {
        return this.teritiaryRSToRegionMap;
    }

    public Map<ServerName, List<RegionInfo>> getPrimaryToRegionInfoMap() {
        return this.primaryRSToRegionMap;
    }
}

