/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.janitor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Get;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.GCMultipleMergedRegionsProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.janitor.CatalogJanitorReport;
import org.apache.hudi.org.apache.hadoop.hbase.master.janitor.ReportMakingVisitor;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CatalogJanitor
extends ScheduledChore {
    public static final int DEFAULT_HBASE_CATALOGJANITOR_INTERVAL = 300000;
    private static final Logger LOG = LoggerFactory.getLogger((String)CatalogJanitor.class.getName());
    private final AtomicBoolean alreadyRunning = new AtomicBoolean(false);
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final MasterServices services;
    private volatile CatalogJanitorReport lastReport;

    public CatalogJanitor(MasterServices services) {
        super("CatalogJanitor-" + services.getServerName().toShortString(), services, services.getConfiguration().getInt("hbase.catalogjanitor.interval", 300000));
        this.services = services;
    }

    @Override
    protected boolean initialChore() {
        try {
            if (this.getEnabled()) {
                this.scan();
            }
        }
        catch (IOException e) {
            LOG.warn("Failed initial janitorial scan of hbase:meta table", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setEnabled(boolean enabled) {
        boolean alreadyEnabled = this.enabled.getAndSet(enabled);
        if (!enabled && alreadyEnabled) {
            while (this.alreadyRunning.get()) {
                Threads.sleepWithoutInterrupt(100L);
            }
        }
        return alreadyEnabled;
    }

    public boolean getEnabled() {
        return this.enabled.get();
    }

    @Override
    protected void chore() {
        try {
            AssignmentManager am = this.services.getAssignmentManager();
            if (this.getEnabled() && !this.services.isInMaintenanceMode() && !this.services.getServerManager().isClusterShutdown() && CatalogJanitor.isMetaLoaded(am)) {
                this.scan();
            } else {
                LOG.warn("CatalogJanitor is disabled! Enabled=" + this.getEnabled() + ", maintenanceMode=" + this.services.isInMaintenanceMode() + ", am=" + am + ", metaLoaded=" + CatalogJanitor.isMetaLoaded(am) + ", hasRIT=" + CatalogJanitor.isRIT(am) + " clusterShutDown=" + this.services.getServerManager().isClusterShutdown());
            }
        }
        catch (IOException e) {
            LOG.warn("Failed janitorial scan of hbase:meta table", (Throwable)e);
        }
    }

    private static boolean isMetaLoaded(AssignmentManager am) {
        return am != null && am.isMetaLoaded();
    }

    private static boolean isRIT(AssignmentManager am) {
        return CatalogJanitor.isMetaLoaded(am) && am.hasRegionsInTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scan() throws IOException {
        int gcs = 0;
        try {
            if (!this.alreadyRunning.compareAndSet(false, true)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CatalogJanitor already running");
                }
                int n = -1;
                return n;
            }
            this.lastReport = this.scanForReport();
            if (!this.lastReport.isEmpty()) {
                LOG.warn(this.lastReport.toString());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(this.lastReport.toString());
            }
            this.updateAssignmentManagerMetrics();
            Map<RegionInfo, Result> mergedRegions = this.lastReport.mergedRegions;
            for (Map.Entry<RegionInfo, Result> e : mergedRegions.entrySet()) {
                if (this.services.isInMaintenanceMode()) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("In maintenence mode, not cleaning");
                    break;
                }
                List<RegionInfo> parents = MetaTableAccessor.getMergeRegions(e.getValue().rawCells());
                if (parents == null || !this.cleanMergeRegion(e.getKey(), parents)) continue;
                ++gcs;
            }
            Map<RegionInfo, Result> splitParents = this.lastReport.splitParents;
            HashSet<String> parentNotCleaned = new HashSet<String>();
            for (Map.Entry<RegionInfo, Result> e : splitParents.entrySet()) {
                if (this.services.isInMaintenanceMode()) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("In maintenence mode, not cleaning");
                    break;
                }
                if (!parentNotCleaned.contains(e.getKey().getEncodedName()) && this.cleanParent(e.getKey(), e.getValue())) {
                    ++gcs;
                    continue;
                }
                PairOfSameType<RegionInfo> daughters = MetaTableAccessor.getDaughterRegions(e.getValue());
                parentNotCleaned.add(daughters.getFirst().getEncodedName());
                parentNotCleaned.add(daughters.getSecond().getEncodedName());
            }
            int n = gcs;
            return n;
        }
        finally {
            this.alreadyRunning.set(false);
        }
    }

    protected CatalogJanitorReport scanForReport() throws IOException {
        ReportMakingVisitor visitor2 = new ReportMakingVisitor(this.services);
        MetaTableAccessor.scanMetaForTableRegions(this.services.getConnection(), visitor2, null);
        return visitor2.getReport();
    }

    public CatalogJanitorReport getLastReport() {
        return this.lastReport;
    }

    private boolean cleanMergeRegion(RegionInfo mergedRegion, List<RegionInfo> parents) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning merged region {}", (Object)mergedRegion);
        }
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir(rootdir, mergedRegion.getTable());
        TableDescriptor htd = this.getDescriptor(mergedRegion.getTable());
        HRegionFileSystem regionFs = null;
        try {
            regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, mergedRegion, true);
        }
        catch (IOException e) {
            LOG.warn("Merged region does not exist: " + mergedRegion.getEncodedName());
        }
        if (regionFs == null || !regionFs.hasReferences(htd)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting parents ({}) from fs; merged child {} no longer holds references", (Object)parents.stream().map(r -> RegionInfo.getShortNameToLog(r)).collect(Collectors.joining(", ")), (Object)mergedRegion);
            }
            ProcedureExecutor<MasterProcedureEnv> pe = this.services.getMasterProcedureExecutor();
            GCMultipleMergedRegionsProcedure mergeRegionProcedure = new GCMultipleMergedRegionsProcedure((MasterProcedureEnv)pe.getEnvironment(), mergedRegion, parents);
            pe.submitProcedure((Procedure)mergeRegionProcedure);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitted procedure {} for merged region {}", (Object)mergeRegionProcedure, (Object)mergedRegion);
            }
            return true;
        }
        return false;
    }

    static boolean cleanParent(MasterServices services, RegionInfo parent, Result rowContent) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning parent region {}", (Object)parent);
        }
        if (MetaTableAccessor.hasMergeRegions(rowContent.rawCells())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Region {} has merge parents, cleaning them first", (Object)parent);
            }
            return false;
        }
        PairOfSameType<RegionInfo> daughters = MetaTableAccessor.getDaughterRegions(rowContent);
        Pair<Boolean, Boolean> a = CatalogJanitor.checkDaughterInFs(services, parent, daughters.getFirst());
        Pair<Boolean, Boolean> b = CatalogJanitor.checkDaughterInFs(services, parent, daughters.getSecond());
        if (CatalogJanitor.hasNoReferences(a) && CatalogJanitor.hasNoReferences(b)) {
            String daughterB;
            String daughterA = daughters.getFirst() != null ? daughters.getFirst().getShortNameToLog() : "null";
            String string = daughterB = daughters.getSecond() != null ? daughters.getSecond().getShortNameToLog() : "null";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting region " + parent.getShortNameToLog() + " because daughters -- " + daughterA + ", " + daughterB + " -- no longer hold references");
            }
            ProcedureExecutor<MasterProcedureEnv> pe = services.getMasterProcedureExecutor();
            GCRegionProcedure gcRegionProcedure = new GCRegionProcedure((MasterProcedureEnv)pe.getEnvironment(), parent);
            pe.submitProcedure((Procedure)gcRegionProcedure);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submitted procedure {} for split parent {}", (Object)gcRegionProcedure, (Object)parent);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            if (!CatalogJanitor.hasNoReferences(a)) {
                LOG.debug("Deferring removal of region {} because daughter {} still has references", (Object)parent, (Object)daughters.getFirst());
            }
            if (!CatalogJanitor.hasNoReferences(b)) {
                LOG.debug("Deferring removal of region {} because daughter {} still has references", (Object)parent, (Object)daughters.getSecond());
            }
        }
        return false;
    }

    private boolean cleanParent(RegionInfo parent, Result rowContent) throws IOException {
        return CatalogJanitor.cleanParent(this.services, parent, rowContent);
    }

    private static boolean hasNoReferences(Pair<Boolean, Boolean> p) {
        return p.getFirst() == false || p.getSecond() == false;
    }

    private static Pair<Boolean, Boolean> checkDaughterInFs(MasterServices services, RegionInfo parent, RegionInfo daughter) throws IOException {
        if (daughter == null) {
            return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
        }
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir(rootdir, daughter.getTable());
        Path daughterRegionDir = new Path(tabledir, daughter.getEncodedName());
        try {
            if (!CommonFSUtils.isExists(fs, daughterRegionDir)) {
                return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
            }
        }
        catch (IOException ioe) {
            LOG.error("Error trying to determine if daughter region exists, assuming exists and has references", (Throwable)ioe);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        boolean references = false;
        TableDescriptor parentDescriptor = services.getTableDescriptors().get(parent.getTable());
        try {
            ColumnFamilyDescriptor family;
            HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(services.getConfiguration(), fs, tabledir, daughter, true);
            ColumnFamilyDescriptor[] columnFamilyDescriptorArray = parentDescriptor.getColumnFamilies();
            int n = columnFamilyDescriptorArray.length;
            for (int i = 0; i < n && !(references = regionFs.hasReferences((family = columnFamilyDescriptorArray[i]).getNameAsString())); ++i) {
            }
        }
        catch (IOException e) {
            LOG.error("Error trying to determine referenced files from : " + daughter.getEncodedName() + ", to: " + parent.getEncodedName() + " assuming has references", (Throwable)e);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        return new Pair<Boolean, Boolean>(Boolean.TRUE, references);
    }

    private TableDescriptor getDescriptor(TableName tableName) throws IOException {
        return this.services.getTableDescriptors().get(tableName);
    }

    private void updateAssignmentManagerMetrics() {
        this.services.getAssignmentManager().getAssignmentManagerMetrics().updateHoles(this.lastReport.getHoles().size());
        this.services.getAssignmentManager().getAssignmentManagerMetrics().updateOverlaps(this.lastReport.getOverlaps().size());
        this.services.getAssignmentManager().getAssignmentManagerMetrics().updateUnknownServerRegions(this.lastReport.getUnknownServers().size());
        this.services.getAssignmentManager().getAssignmentManagerMetrics().updateEmptyRegionInfoRegions(this.lastReport.getEmptyRegionInfo().size());
    }

    private static void checkLog4jProperties() {
        String filename = "log4j.properties";
        try (InputStream inStream = CatalogJanitor.class.getClassLoader().getResourceAsStream(filename);){
            if (inStream != null) {
                new Properties().load(inStream);
            } else {
                System.out.println("No " + filename + " on classpath; Add one else no logging output!");
            }
        }
        catch (IOException e) {
            LOG.error("Log4j check failed", (Throwable)e);
        }
    }

    public static void main(String[] args2) throws IOException {
        CatalogJanitor.checkLog4jProperties();
        ReportMakingVisitor visitor2 = new ReportMakingVisitor(null);
        Configuration configuration = HBaseConfiguration.create();
        configuration.setBoolean("hbase.defaults.for.version.skip", true);
        try (Connection connection = ConnectionFactory.createConnection(configuration);){
            Get g = new Get(Bytes.toBytes("t2,40,1564119846424.1db8c57d64e0733e0f027aaeae7a0bf0."));
            g.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
            try (Table t = connection.getTable(TableName.META_TABLE_NAME);){
                Result r = t.get(g);
                byte[] row = g.getRow();
                int n = row.length - 2;
                row[n] = (byte)(row[n] << row[row.length - 2]);
                Put p = new Put(g.getRow());
                p.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                t.put(p);
            }
            MetaTableAccessor.scanMetaForTableRegions(connection, visitor2, null);
            CatalogJanitorReport report = visitor2.getReport();
            LOG.info(report != null ? report.toString() : "empty");
        }
    }

    static class SplitParentFirstComparator
    implements Comparator<RegionInfo> {
        Comparator<byte[]> rowEndKeyComparator = new Bytes.RowEndKeyComparator();

        SplitParentFirstComparator() {
        }

        @Override
        public int compare(RegionInfo left, RegionInfo right) {
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int result2 = left.getTable().compareTo(right.getTable());
            if (result2 != 0) {
                return result2;
            }
            result2 = Bytes.compareTo(left.getStartKey(), right.getStartKey());
            if (result2 != 0) {
                return result2;
            }
            result2 = this.rowEndKeyComparator.compare(right.getEndKey(), left.getEndKey());
            return result2;
        }
    }
}

