/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.backup.FailedArchiveException;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hudi.org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ReadOnlyConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.InvalidHFileException;
import org.apache.hudi.org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hudi.org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hudi.org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ProtocolStringList;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.IterableUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HStore
implements Store,
HeapSize,
StoreConfigInformation,
PropagatingConfigurationObserver {
    public static final String MEMSTORE_CLASS_NAME = "hbase.regionserver.memstore.class";
    public static final String COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY = "hbase.server.compactchecker.interval.multiplier";
    public static final String BLOCKING_STOREFILES_KEY = "hbase.hstore.blockingStoreFiles";
    public static final String BLOCK_STORAGE_POLICY_KEY = "hbase.hstore.block.storage.policy";
    public static final String DEFAULT_BLOCK_STORAGE_POLICY = "HOT";
    public static final int DEFAULT_COMPACTCHECKER_INTERVAL_MULTIPLIER = 1000;
    public static final int DEFAULT_BLOCKING_STOREFILE_COUNT = 16;
    private static final int SPLIT_REGION_COMPACTION_PRIORITY = -2147482648;
    private static final Logger LOG = LoggerFactory.getLogger(HStore.class);
    protected final MemStore memstore;
    private final HRegion region;
    protected Configuration conf;
    private long lastCompactSize = 0L;
    volatile boolean forceMajor = false;
    static int closeCheckInterval = 0;
    private AtomicLong storeSize = new AtomicLong();
    private AtomicLong totalUncompressedBytes = new AtomicLong();
    private LongAdder memstoreOnlyRowReadsCount = new LongAdder();
    private LongAdder mixedRowReadsCount = new LongAdder();
    private boolean cacheOnWriteLogged;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final ReentrantLock archiveLock = new ReentrantLock();
    private final boolean verifyBulkLoads;
    private final AtomicInteger currentParallelPutCount = new AtomicInteger(0);
    private final int parallelPutCountPrintThreshold;
    private ScanInfo scanInfo;
    private final List<HStoreFile> filesCompacting = Lists.newArrayList();
    private final Set<ChangedReadersObserver> changedReaderObservers = Collections.newSetFromMap(new ConcurrentHashMap());
    private HFileDataBlockEncoder dataBlockEncoder;
    final StoreEngine<?, ?, ?, ?> storeEngine;
    private static final AtomicBoolean offPeakCompactionTracker = new AtomicBoolean();
    private volatile OffPeakHours offPeakHours;
    private static final int DEFAULT_FLUSH_RETRIES_NUMBER = 10;
    private int flushRetriesNumber;
    private int pauseTime;
    private long blockingFileCount;
    private int compactionCheckMultiplier;
    private AtomicLong flushedCellsCount = new AtomicLong();
    private AtomicLong compactedCellsCount = new AtomicLong();
    private AtomicLong majorCompactedCellsCount = new AtomicLong();
    private AtomicLong flushedCellsSize = new AtomicLong();
    private AtomicLong flushedOutputFileSize = new AtomicLong();
    private AtomicLong compactedCellsSize = new AtomicLong();
    private AtomicLong majorCompactedCellsSize = new AtomicLong();
    private final StoreContext storeContext;
    public static final long FIXED_OVERHEAD = ClassSize.estimateBase(HStore.class, false);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)ClassSize.REENTRANT_LOCK + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.OBJECT + ScanInfo.FIXED_OVERHEAD);

    protected HStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, boolean warmup) throws IOException {
        this.conf = StoreUtils.createStoreConfiguration(confParam, region.getTableDescriptor(), family);
        this.region = region;
        this.storeContext = this.initializeStoreContext(family);
        region.getRegionFileSystem().createStoreDir(family.getNameAsString());
        String policyName = family.getStoragePolicy();
        if (null == policyName) {
            policyName = this.conf.get(BLOCK_STORAGE_POLICY_KEY, DEFAULT_BLOCK_STORAGE_POLICY);
        }
        region.getRegionFileSystem().setStoragePolicy(family.getNameAsString(), policyName.trim());
        this.dataBlockEncoder = new HFileDataBlockEncoderImpl(family.getDataBlockEncoding());
        long timeToPurgeDeletes = Math.max(this.conf.getLong("hbase.hstore.time.to.purge.deletes", 0L), 0L);
        LOG.trace("Time to purge deletes set to {}ms in {}", (Object)timeToPurgeDeletes, (Object)this);
        long ttl = HStore.determineTTLFromFamily(family);
        this.scanInfo = new ScanInfo(this.conf, family, ttl, timeToPurgeDeletes, region.getCellComparator());
        this.memstore = this.getMemstore();
        this.offPeakHours = OffPeakHours.getInstance(this.conf);
        this.verifyBulkLoads = this.conf.getBoolean("hbase.hstore.bulkload.verify", false);
        this.blockingFileCount = this.conf.getInt(BLOCKING_STOREFILES_KEY, 16);
        this.compactionCheckMultiplier = this.conf.getInt(COMPACTCHECKER_INTERVAL_MULTIPLIER_KEY, 1000);
        if (this.compactionCheckMultiplier <= 0) {
            LOG.error("Compaction check period multiplier must be positive, setting default: {}", (Object)1000);
            this.compactionCheckMultiplier = 1000;
        }
        if (closeCheckInterval == 0) {
            closeCheckInterval = this.conf.getInt("hbase.hstore.close.check.interval", 10000000);
        }
        this.storeEngine = this.createStoreEngine(this, this.conf, region.getCellComparator());
        List<HStoreFile> hStoreFiles = this.loadStoreFiles(warmup);
        this.storeSize.addAndGet(this.getStorefilesSize(hStoreFiles, sf -> true));
        this.totalUncompressedBytes.addAndGet(this.getTotalUncompressedBytes(hStoreFiles));
        this.storeEngine.getStoreFileManager().loadFiles(hStoreFiles);
        this.flushRetriesNumber = this.conf.getInt("hbase.hstore.flush.retries.number", 10);
        this.pauseTime = this.conf.getInt("hbase.server.pause", 1000);
        if (this.flushRetriesNumber <= 0) {
            throw new IllegalArgumentException("hbase.hstore.flush.retries.number must be > 0, not " + this.flushRetriesNumber);
        }
        int confPrintThreshold = this.conf.getInt("hbase.region.store.parallel.put.print.threshold", 50);
        if (confPrintThreshold < 10) {
            confPrintThreshold = 10;
        }
        this.parallelPutCountPrintThreshold = confPrintThreshold;
        LOG.info("Store={},  memstore type={}, storagePolicy={}, verifyBulkLoads={}, parallelPutCountPrintThreshold={}, encoding={}, compression={}", new Object[]{this, this.memstore.getClass().getSimpleName(), policyName, this.verifyBulkLoads, this.parallelPutCountPrintThreshold, family.getDataBlockEncoding(), family.getCompressionType()});
        this.cacheOnWriteLogged = false;
    }

    private StoreContext initializeStoreContext(ColumnFamilyDescriptor family) throws IOException {
        return new StoreContext.Builder().withBlockSize(family.getBlocksize()).withEncryptionContext(EncryptionUtil.createEncryptionContext(this.conf, family)).withBloomType(family.getBloomFilterType()).withCacheConfig(this.createCacheConf(family)).withCellComparator(this.region.getCellComparator()).withColumnFamilyDescriptor(family).withCompactedFilesSupplier(this::getCompactedFiles).withRegionFileSystem(this.region.getRegionFileSystem()).withFavoredNodesSupplier(this::getFavoredNodes).withFamilyStoreDirectoryPath(this.region.getRegionFileSystem().getStoreDir(family.getNameAsString())).withRegionCoprocessorHost(this.region.getCoprocessorHost()).build();
    }

    private InetSocketAddress[] getFavoredNodes() {
        InetSocketAddress[] favoredNodes = null;
        if (this.region.getRegionServerServices() != null) {
            favoredNodes = this.region.getRegionServerServices().getFavoredNodesForRegion(this.region.getRegionInfo().getEncodedName());
        }
        return favoredNodes;
    }

    private MemStore getMemstore() {
        MemStore ms = null;
        MemoryCompactionPolicy inMemoryCompaction = null;
        inMemoryCompaction = this.getTableName().isSystemTable() ? MemoryCompactionPolicy.valueOf(this.conf.get("hbase.systemtables.compacting.memstore.type", "NONE").toUpperCase()) : this.getColumnFamilyDescriptor().getInMemoryCompaction();
        if (inMemoryCompaction == null) {
            inMemoryCompaction = MemoryCompactionPolicy.valueOf(this.conf.get("hbase.hregion.compacting.memstore.type", CompactingMemStore.COMPACTING_MEMSTORE_TYPE_DEFAULT).toUpperCase());
        }
        switch (inMemoryCompaction) {
            case NONE: {
                Class memStoreClass = this.conf.getClass(MEMSTORE_CLASS_NAME, DefaultMemStore.class, MemStore.class);
                ms = (MemStore)ReflectionUtils.newInstance(memStoreClass, this.conf, this.getComparator(), this.getHRegion().getRegionServicesForStores());
                break;
            }
            default: {
                Class compactingMemStoreClass = this.conf.getClass(MEMSTORE_CLASS_NAME, CompactingMemStore.class, CompactingMemStore.class);
                ms = (MemStore)ReflectionUtils.newInstance(compactingMemStoreClass, new Object[]{this.conf, this.getComparator(), this, this.getHRegion().getRegionServicesForStores(), inMemoryCompaction});
            }
        }
        return ms;
    }

    protected CacheConfig createCacheConf(ColumnFamilyDescriptor family) {
        CacheConfig cacheConf = new CacheConfig(this.conf, family, this.region.getBlockCache(), this.region.getRegionServicesForStores().getByteBuffAllocator());
        LOG.info("Created cacheConfig: {}, for column family {} of region {} ", new Object[]{cacheConf, family.getNameAsString(), this.region.getRegionInfo().getEncodedName()});
        return cacheConf;
    }

    protected StoreEngine<?, ?, ?, ?> createStoreEngine(HStore store, Configuration conf, CellComparator kvComparator) throws IOException {
        return StoreEngine.create(store, conf, kvComparator);
    }

    public static long determineTTLFromFamily(ColumnFamilyDescriptor family) {
        long ttl = family.getTimeToLive();
        ttl = ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : (ttl == -1L ? Long.MAX_VALUE : (ttl *= 1000L));
        return ttl;
    }

    StoreContext getStoreContext() {
        return this.storeContext;
    }

    @Override
    public String getColumnFamilyName() {
        return this.storeContext.getFamily().getNameAsString();
    }

    @Override
    public TableName getTableName() {
        return this.getRegionInfo().getTable();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.storeContext.getRegionFileSystem().getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.storeContext.getRegionFileSystem();
    }

    @Override
    public long getStoreFileTtl() {
        return this.scanInfo.getMinVersions() == 0 ? this.scanInfo.getTtl() : Long.MAX_VALUE;
    }

    @Override
    public long getMemStoreFlushSize() {
        return this.region.memstoreFlushSize;
    }

    @Override
    public MemStoreSize getFlushableSize() {
        return this.memstore.getFlushableSize();
    }

    @Override
    public MemStoreSize getSnapshotSize() {
        return this.memstore.getSnapshotSize();
    }

    @Override
    public long getCompactionCheckMultiplier() {
        return this.compactionCheckMultiplier;
    }

    @Override
    public long getBlockingFileCount() {
        return this.blockingFileCount;
    }

    public static int getCloseCheckInterval() {
        return closeCheckInterval;
    }

    @Override
    public ColumnFamilyDescriptor getColumnFamilyDescriptor() {
        return this.storeContext.getFamily();
    }

    @Override
    public OptionalLong getMaxSequenceId() {
        return StoreUtils.getMaxSequenceIdInList(this.getStorefiles());
    }

    @Override
    public OptionalLong getMaxMemStoreTS() {
        return StoreUtils.getMaxMemStoreTSInList(this.getStorefiles());
    }

    public HFileDataBlockEncoder getDataBlockEncoder() {
        return this.dataBlockEncoder;
    }

    void setDataBlockEncoderInTest(HFileDataBlockEncoder blockEncoder) {
        this.dataBlockEncoder = blockEncoder;
    }

    private List<HStoreFile> loadStoreFiles(boolean warmup) throws IOException {
        Collection<StoreFileInfo> files = this.getRegionFileSystem().getStoreFiles(this.getColumnFamilyName());
        return this.openStoreFiles(files, warmup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HStoreFile> openStoreFiles(Collection<StoreFileInfo> files, boolean warmup) throws IOException {
        if (CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        ThreadPoolExecutor storeFileOpenerThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileOpener-" + this.getColumnFamilyName());
        ExecutorCompletionService<HStoreFile> completionService = new ExecutorCompletionService<HStoreFile>(storeFileOpenerThreadPool);
        int totalValidStoreFile = 0;
        for (StoreFileInfo storeFileInfo : files) {
            completionService.submit(() -> this.createStoreFileAndReader(storeFileInfo));
            ++totalValidStoreFile;
        }
        HashSet<String> compactedStoreFiles = new HashSet<String>();
        ArrayList<HStoreFile> results = new ArrayList<HStoreFile>(files.size());
        IOException ioe = null;
        try {
            for (int i = 0; i < totalValidStoreFile; ++i) {
                try {
                    HStoreFile storeFile = (HStoreFile)completionService.take().get();
                    if (storeFile == null) continue;
                    LOG.debug("loaded {}", (Object)storeFile);
                    results.add(storeFile);
                    compactedStoreFiles.addAll(storeFile.getCompactedStoreFiles());
                    continue;
                }
                catch (InterruptedException e) {
                    if (ioe != null) continue;
                    ioe = new InterruptedIOException(e.getMessage());
                    continue;
                }
                catch (ExecutionException e) {
                    if (ioe != null) continue;
                    ioe = new IOException(e.getCause());
                }
            }
        }
        finally {
            storeFileOpenerThreadPool.shutdownNow();
        }
        if (ioe != null) {
            boolean evictOnClose = this.getCacheConfig() != null ? this.getCacheConfig().shouldEvictOnClose() : true;
            for (HStoreFile file : results) {
                try {
                    if (file == null) continue;
                    file.closeStoreFile(evictOnClose);
                }
                catch (IOException e) {
                    LOG.warn("Could not close store file {}", (Object)file, (Object)e);
                }
            }
            throw ioe;
        }
        if (!warmup) {
            ArrayList<HStoreFile> filesToRemove = new ArrayList<HStoreFile>(compactedStoreFiles.size());
            for (HStoreFile storeFile : results) {
                if (!compactedStoreFiles.contains(storeFile.getPath().getName())) continue;
                LOG.warn("Clearing the compacted storefile {} from {}", (Object)storeFile, (Object)this);
                storeFile.getReader().close(storeFile.getCacheConf() != null ? storeFile.getCacheConf().shouldEvictOnClose() : true);
                filesToRemove.add(storeFile);
            }
            results.removeAll(filesToRemove);
            if (!filesToRemove.isEmpty() && this.isPrimaryReplicaStore()) {
                LOG.debug("Moving the files {} to archive", filesToRemove);
                this.getRegionFileSystem().removeStoreFiles(this.getColumnFamilyDescriptor().getNameAsString(), filesToRemove);
            }
        }
        return results;
    }

    @Override
    public void refreshStoreFiles() throws IOException {
        Collection<StoreFileInfo> newFiles = this.getRegionFileSystem().getStoreFiles(this.getColumnFamilyName());
        this.refreshStoreFilesInternal(newFiles);
    }

    public void refreshStoreFiles(Collection<String> newFiles) throws IOException {
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(newFiles.size());
        for (String file : newFiles) {
            storeFiles.add(this.getRegionFileSystem().getStoreFileInfo(this.getColumnFamilyName(), file));
        }
        this.refreshStoreFilesInternal(storeFiles);
    }

    private void refreshStoreFilesInternal(Collection<StoreFileInfo> newFiles) throws IOException {
        StoreFileManager sfm = this.storeEngine.getStoreFileManager();
        Collection<HStoreFile> currentFiles = sfm.getStorefiles();
        Collection<HStoreFile> compactedFiles = sfm.getCompactedfiles();
        if (currentFiles == null) {
            currentFiles = Collections.emptySet();
        }
        if (newFiles == null) {
            newFiles = Collections.emptySet();
        }
        if (compactedFiles == null) {
            compactedFiles = Collections.emptySet();
        }
        HashMap<StoreFileInfo, HStoreFile> currentFilesSet = new HashMap<StoreFileInfo, HStoreFile>(currentFiles.size());
        for (HStoreFile hStoreFile : currentFiles) {
            currentFilesSet.put(hStoreFile.getFileInfo(), hStoreFile);
        }
        HashMap<StoreFileInfo, HStoreFile> compactedFilesSet = new HashMap<StoreFileInfo, HStoreFile>(compactedFiles.size());
        for (HStoreFile sf : compactedFiles) {
            compactedFilesSet.put(sf.getFileInfo(), sf);
        }
        HashSet<StoreFileInfo> hashSet = new HashSet<StoreFileInfo>(newFiles);
        Sets.SetView<StoreFileInfo> setView = Sets.difference(hashSet, compactedFilesSet.keySet());
        Sets.SetView<StoreFileInfo> toBeAddedFiles = Sets.difference(setView, currentFilesSet.keySet());
        Sets.SetView<StoreFileInfo> toBeRemovedFiles = Sets.difference(currentFilesSet.keySet(), setView);
        if (toBeAddedFiles.isEmpty() && toBeRemovedFiles.isEmpty()) {
            return;
        }
        LOG.info("Refreshing store files for " + this + " files to add: " + toBeAddedFiles + " files to remove: " + toBeRemovedFiles);
        HashSet<HStoreFile> toBeRemovedStoreFiles = new HashSet<HStoreFile>(toBeRemovedFiles.size());
        for (StoreFileInfo sfi : toBeRemovedFiles) {
            toBeRemovedStoreFiles.add((HStoreFile)currentFilesSet.get(sfi));
        }
        List<HStoreFile> openedFiles = this.openStoreFiles(toBeAddedFiles, false);
        this.replaceStoreFiles(toBeRemovedStoreFiles, openedFiles);
        if (!toBeAddedFiles.isEmpty()) {
            this.region.getMVCC().advanceTo(this.getMaxSequenceId().getAsLong());
        }
        this.completeCompaction(toBeRemovedStoreFiles);
    }

    protected HStoreFile createStoreFileAndReader(Path p) throws IOException {
        StoreFileInfo info = new StoreFileInfo(this.conf, this.getFileSystem(), p, this.isPrimaryReplicaStore());
        return this.createStoreFileAndReader(info);
    }

    private HStoreFile createStoreFileAndReader(StoreFileInfo info) throws IOException {
        info.setRegionCoprocessorHost(this.region.getCoprocessorHost());
        HStoreFile storeFile = new HStoreFile(info, this.getColumnFamilyDescriptor().getBloomFilterType(), this.getCacheConfig());
        storeFile.initReader();
        return storeFile;
    }

    public void startReplayingFromWAL() {
        this.memstore.startReplayingFromWAL();
    }

    public void stopReplayingFromWAL() {
        this.memstore.stopReplayingFromWAL();
    }

    public void add(Cell cell, MemStoreSizing memstoreSizing) {
        this.lock.readLock().lock();
        try {
            if (this.currentParallelPutCount.getAndIncrement() > this.parallelPutCountPrintThreshold) {
                LOG.trace("tableName={}, encodedName={}, columnFamilyName={} is too busy!", new Object[]{this.getTableName(), this.getRegionInfo().getEncodedName(), this.getColumnFamilyName()});
            }
            this.memstore.add(cell, memstoreSizing);
        }
        finally {
            this.lock.readLock().unlock();
            this.currentParallelPutCount.decrementAndGet();
        }
    }

    public void add(Iterable<Cell> cells, MemStoreSizing memstoreSizing) {
        this.lock.readLock().lock();
        try {
            if (this.currentParallelPutCount.getAndIncrement() > this.parallelPutCountPrintThreshold) {
                LOG.trace("tableName={}, encodedName={}, columnFamilyName={} is too busy!", new Object[]{this.getTableName(), this.getRegionInfo().getEncodedName(), this.getColumnFamilyName()});
            }
            this.memstore.add(cells, memstoreSizing);
        }
        finally {
            this.lock.readLock().unlock();
            this.currentParallelPutCount.decrementAndGet();
        }
    }

    @Override
    public long timeOfOldestEdit() {
        return this.memstore.timeOfOldestEdit();
    }

    public Collection<HStoreFile> getStorefiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles();
    }

    public Collection<HStoreFile> getCompactedFiles() {
        return this.storeEngine.getStoreFileManager().getCompactedfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertBulkLoadHFileOk(Path srcPath) throws IOException {
        try (Closeable reader = null;){
            LOG.info("Validating hfile at " + srcPath + " for inclusion in " + this);
            FileSystem srcFs = srcPath.getFileSystem(this.conf);
            srcFs.access(srcPath, FsAction.READ_WRITE);
            reader = HFile.createReader(srcFs, srcPath, this.getCacheConfig(), this.isPrimaryReplicaStore(), this.conf);
            Optional<byte[]> firstKey = reader.getFirstRowKey();
            Preconditions.checkState(firstKey.isPresent(), "First key can not be null");
            Optional<Cell> lk = reader.getLastKey();
            Preconditions.checkState(lk.isPresent(), "Last key can not be null");
            byte[] lastKey = CellUtil.cloneRow(lk.get());
            if (LOG.isDebugEnabled()) {
                LOG.debug("HFile bounds: first=" + Bytes.toStringBinary(firstKey.get()) + " last=" + Bytes.toStringBinary(lastKey));
                LOG.debug("Region bounds: first=" + Bytes.toStringBinary(this.getRegionInfo().getStartKey()) + " last=" + Bytes.toStringBinary(this.getRegionInfo().getEndKey()));
            }
            if (!this.getRegionInfo().containsRange(firstKey.get(), lastKey)) {
                throw new WrongRegionException("Bulk load file " + srcPath.toString() + " does not fit inside region " + this.getRegionInfo().getRegionNameAsString());
            }
            if (reader.length() > this.conf.getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                LOG.warn("Trying to bulk load hfile " + srcPath + " with size: " + reader.length() + " bytes can be problematic as it may lead to oversplitting.");
            }
            if (this.verifyBulkLoads) {
                long verificationStartTime = EnvironmentEdgeManager.currentTime();
                LOG.info("Full verification started for bulk load hfile: {}", (Object)srcPath);
                Cell prevCell = null;
                HFileScanner scanner = reader.getScanner(false, false, false);
                scanner.seekTo();
                do {
                    Cell cell = scanner.getCell();
                    if (prevCell != null) {
                        if (this.getComparator().compareRows(prevCell, cell) > 0) {
                            throw new InvalidHFileException("Previous row is greater than current row: path=" + srcPath + " previous=" + CellUtil.getCellKeyAsString(prevCell) + " current=" + CellUtil.getCellKeyAsString(cell));
                        }
                        if (CellComparator.getInstance().compareFamilies(prevCell, cell) != 0) {
                            throw new InvalidHFileException("Previous key had different family compared to current key: path=" + srcPath + " previous=" + Bytes.toStringBinary(prevCell.getFamilyArray(), prevCell.getFamilyOffset(), prevCell.getFamilyLength()) + " current=" + Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
                        }
                    }
                    prevCell = cell;
                } while (scanner.next());
                LOG.info("Full verification complete for bulk load hfile: " + srcPath.toString() + " took " + (EnvironmentEdgeManager.currentTime() - verificationStartTime) + " ms");
            }
        }
    }

    public Pair<Path, Path> preBulkLoadHFile(String srcPathStr, long seqNum) throws IOException {
        Path srcPath = new Path(srcPathStr);
        return this.getRegionFileSystem().bulkLoadStoreFile(this.getColumnFamilyName(), srcPath, seqNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path bulkLoadHFile(byte[] family, String srcPathStr, Path dstPath) throws IOException {
        Path srcPath = new Path(srcPathStr);
        try {
            this.getRegionFileSystem().commitStoreFile(srcPath, dstPath);
        }
        finally {
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCommitStoreFile(family, srcPath, dstPath);
            }
        }
        LOG.info("Loaded HFile " + srcPath + " into " + this + " as " + dstPath + " - updating store file list.");
        HStoreFile sf = this.createStoreFileAndReader(dstPath);
        this.bulkLoadHFile(sf);
        LOG.info("Successfully loaded {} into {} (new location: {})", new Object[]{srcPath, this, dstPath});
        return dstPath;
    }

    public void bulkLoadHFile(StoreFileInfo fileInfo) throws IOException {
        HStoreFile sf = this.createStoreFileAndReader(fileInfo);
        this.bulkLoadHFile(sf);
    }

    private void bulkLoadHFile(HStoreFile sf) throws IOException {
        StoreFileReader r = sf.getReader();
        this.storeSize.addAndGet(r.length());
        this.totalUncompressedBytes.addAndGet(r.getTotalUncompressedBytes());
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(Lists.newArrayList(sf));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        LOG.info("Loaded HFile " + sf.getFileInfo() + " into " + this);
        if (LOG.isTraceEnabled()) {
            String traceMessage = "BULK LOAD time,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + r.length() + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace(traceMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<HStoreFile> close() throws IOException {
        this.archiveLock.lock();
        this.lock.writeLock().lock();
        try {
            ImmutableCollection<HStoreFile> result2 = this.storeEngine.getStoreFileManager().clearFiles();
            Collection<HStoreFile> compactedfiles = this.storeEngine.getStoreFileManager().clearCompactedFiles();
            if (CollectionUtils.isNotEmpty(compactedfiles)) {
                this.removeCompactedfiles(compactedfiles, this.getCacheConfig() != null ? this.getCacheConfig().shouldEvictOnClose() : true);
            }
            if (!result2.isEmpty()) {
                ThreadPoolExecutor storeFileCloserThreadPool = this.region.getStoreFileOpenAndCloseThreadPool("StoreFileCloser-" + this.getColumnFamilyName());
                ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(storeFileCloserThreadPool);
                for (final HStoreFile f : result2) {
                    completionService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            boolean evictOnClose = HStore.this.getCacheConfig() != null ? HStore.this.getCacheConfig().shouldEvictOnClose() : true;
                            f.closeStoreFile(evictOnClose);
                            return null;
                        }
                    });
                }
                IOException ioe = null;
                try {
                    for (int i = 0; i < result2.size(); ++i) {
                        try {
                            Future future = completionService.take();
                            future.get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            if (ioe != null) continue;
                            ioe = new InterruptedIOException();
                            ioe.initCause(e);
                            continue;
                        }
                        catch (ExecutionException e) {
                            if (ioe != null) continue;
                            ioe = new IOException(e.getCause());
                        }
                    }
                }
                finally {
                    storeFileCloserThreadPool.shutdownNow();
                }
                if (ioe != null) {
                    throw ioe;
                }
            }
            LOG.trace("Closed {}", (Object)this);
            ImmutableCollection<HStoreFile> immutableCollection = result2;
            return immutableCollection;
        }
        finally {
            this.lock.writeLock().unlock();
            this.archiveLock.unlock();
        }
    }

    void snapshot() {
        this.lock.writeLock().lock();
        try {
            this.memstore.snapshot();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected List<Path> flushCache(long logCacheFlushId, MemStoreSnapshot snapshot, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker) throws IOException {
        StoreFlusher flusher = this.storeEngine.getStoreFlusher();
        IOException lastException = null;
        for (int i = 0; i < this.flushRetriesNumber; ++i) {
            try {
                List<Path> pathNames = flusher.flushSnapshot(snapshot, logCacheFlushId, status, throughputController, tracker);
                Path lastPathName = null;
                try {
                    Iterator<Path> iterator2 = pathNames.iterator();
                    while (iterator2.hasNext()) {
                        Path pathName;
                        lastPathName = pathName = iterator2.next();
                        this.validateStoreFile(pathName);
                    }
                    return pathNames;
                }
                catch (Exception e) {
                    LOG.warn("Failed validating store file {}, retrying num={}", new Object[]{lastPathName, i, e});
                    lastException = e instanceof IOException ? (IOException)e : new IOException(e);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed flushing store file for {}, retrying num={}", new Object[]{this, i, e});
                lastException = e;
            }
            if (lastException == null || i >= this.flushRetriesNumber - 1) continue;
            try {
                Thread.sleep(this.pauseTime);
                continue;
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HStoreFile tryCommitRecoveredHFile(Path path) throws IOException {
        LOG.info("Validating recovered hfile at {} for inclusion in store {}", (Object)path, (Object)this);
        FileSystem srcFs = path.getFileSystem(this.conf);
        srcFs.access(path, FsAction.READ_WRITE);
        try (HFile.Reader reader = HFile.createReader(srcFs, path, this.getCacheConfig(), this.isPrimaryReplicaStore(), this.conf);){
            Optional<byte[]> firstKey = reader.getFirstRowKey();
            Preconditions.checkState(firstKey.isPresent(), "First key can not be null");
            Optional<Cell> lk = reader.getLastKey();
            Preconditions.checkState(lk.isPresent(), "Last key can not be null");
            byte[] lastKey = CellUtil.cloneRow(lk.get());
            if (!this.getRegionInfo().containsRange(firstKey.get(), lastKey)) {
                throw new WrongRegionException("Recovered hfile " + path.toString() + " does not fit inside region " + this.getRegionInfo().getRegionNameAsString());
            }
        }
        Path dstPath = this.getRegionFileSystem().commitStoreFile(this.getColumnFamilyName(), path);
        HStoreFile sf = this.createStoreFileAndReader(dstPath);
        StoreFileReader r = sf.getReader();
        this.storeSize.addAndGet(r.length());
        this.totalUncompressedBytes.addAndGet(r.getTotalUncompressedBytes());
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(Lists.newArrayList(sf));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        LOG.info("Loaded recovered hfile to {}, entries={}, sequenceid={}, filesize={}", new Object[]{sf, r.getEntries(), r.getSequenceID(), StringUtils.TraditionalBinaryPrefix.long2String((long)r.length(), (String)"B", (int)1)});
        return sf;
    }

    private HStoreFile commitFile(Path path, long logCacheFlushId, MonitoredTask status) throws IOException {
        Path dstPath = this.getRegionFileSystem().commitStoreFile(this.getColumnFamilyName(), path);
        status.setStatus("Flushing " + this + ": reopening flushed file");
        HStoreFile sf = this.createStoreFileAndReader(dstPath);
        StoreFileReader r = sf.getReader();
        this.storeSize.addAndGet(r.length());
        this.totalUncompressedBytes.addAndGet(r.getTotalUncompressedBytes());
        if (LOG.isInfoEnabled()) {
            LOG.info("Added " + sf + ", entries=" + r.getEntries() + ", sequenceid=" + logCacheFlushId + ", filesize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)r.length(), (String)"", (int)1));
        }
        return sf;
    }

    public StoreFileWriter createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind) throws IOException {
        return this.createWriterInTmp(maxKeyCount, compression, isCompaction, includeMVCCReadpoint, includesTag, shouldDropBehind, -1L, "");
    }

    public StoreFileWriter createWriterInTmp(long maxKeyCount, Compression.Algorithm compression, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind, long totalCompactedFilesSize, String fileStoragePolicy) throws IOException {
        CacheConfig cacheConf = this.getCacheConfig();
        CacheConfig writerCacheConf = new CacheConfig(cacheConf);
        if (isCompaction) {
            boolean cacheCompactedBlocksOnWrite = this.getCacheConfig().shouldCacheCompactedBlocksOnWrite();
            if (cacheCompactedBlocksOnWrite && totalCompactedFilesSize <= cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For {} , cacheCompactedBlocksOnWrite is true, hence enabled cacheOnWrite for Data blocks, Index blocks and Bloom filter blocks", (Object)this);
                    this.cacheOnWriteLogged = true;
                }
            } else {
                writerCacheConf.setCacheDataOnWrite(false);
                if (totalCompactedFilesSize > cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                    LOG.debug("For {}, setting cacheCompactedBlocksOnWrite as false as total size of compacted files - {}, is greater than cacheCompactedBlocksOnWriteThreshold - {}", new Object[]{this, totalCompactedFilesSize, cacheConf.getCacheCompactedBlocksOnWriteThreshold()});
                }
            }
        } else {
            boolean shouldCacheDataOnWrite = cacheConf.shouldCacheDataOnWrite();
            if (shouldCacheDataOnWrite) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For {} , cacheDataOnWrite is true, hence enabled cacheOnWrite for Index blocks and Bloom filter blocks", (Object)this);
                    this.cacheOnWriteLogged = true;
                }
            }
        }
        Encryption.Context encryptionContext = this.storeContext.getEncryptionContext();
        HFileContext hFileContext = this.createFileContext(compression, includeMVCCReadpoint, includesTag, encryptionContext);
        Path familyTempDir = new Path(this.getRegionFileSystem().getTempDir(), this.getColumnFamilyName());
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(this.conf, writerCacheConf, this.getFileSystem()).withOutputDir(familyTempDir).withBloomType(this.storeContext.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withFavoredNodes(this.storeContext.getFavoredNodes()).withFileContext(hFileContext).withShouldDropCacheBehind(shouldDropBehind).withCompactedFilesSupplier(this.storeContext.getCompactedFilesSupplier()).withFileStoragePolicy(fileStoragePolicy);
        return builder.build();
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag, Encryption.Context encryptionContext) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        ColumnFamilyDescriptor family = this.getColumnFamilyDescriptor();
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(includeMVCCReadpoint).withIncludesTags(includesTag).withCompression(compression).withCompressTags(family.isCompressTags()).withChecksumType(StoreUtils.getChecksumType(this.conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum(this.conf)).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).withEncryptionContext(encryptionContext).withCreateTime(EnvironmentEdgeManager.currentTime()).withColumnFamily(this.getColumnFamilyDescriptor().getName()).withTableName(this.getTableName().getName()).withCellComparator(this.getComparator()).build();
        return hFileContext;
    }

    private long getTotalSize(Collection<HStoreFile> sfs) {
        return sfs.stream().mapToLong(sf -> sf.getReader().length()).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStorefiles(List<HStoreFile> sfs, long snapshotId) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().insertNewFiles(sfs);
            if (snapshotId > 0L) {
                this.memstore.clearSnapshot(snapshotId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.notifyChangedReadersObservers(sfs);
        if (LOG.isTraceEnabled()) {
            long totalSize = this.getTotalSize(sfs);
            String traceMessage = "FLUSH time,count,size,store size,store files [" + EnvironmentEdgeManager.currentTime() + "," + sfs.size() + "," + totalSize + "," + this.storeSize + "," + this.storeEngine.getStoreFileManager().getStorefileCount() + "]";
            LOG.trace(traceMessage);
        }
        return this.needsCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangedReadersObservers(List<HStoreFile> sfs) throws IOException {
        for (ChangedReadersObserver o : this.changedReaderObservers) {
            List<KeyValueScanner> memStoreScanners;
            this.lock.readLock().lock();
            try {
                memStoreScanners = this.memstore.getScanners(o.getReadPoint());
            }
            finally {
                this.lock.readLock().unlock();
            }
            o.updateReaders(sfs, memStoreScanners);
        }
    }

    public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt) throws IOException {
        return this.getScanners(cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValueScanner> getScanners(boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt) throws IOException {
        List<KeyValueScanner> memStoreScanners;
        Collection<HStoreFile> storeFilesToScan;
        this.lock.readLock().lock();
        try {
            storeFilesToScan = this.storeEngine.getStoreFileManager().getFilesForScan(startRow, includeStartRow, stopRow, includeStopRow);
            memStoreScanners = this.memstore.getScanners(readPt);
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(storeFilesToScan, cacheBlocks, usePread, isCompaction, false, matcher, readPt);
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
            scanners.addAll(sfScanners);
            scanners.addAll(memStoreScanners);
            return scanners;
        }
        catch (Throwable t) {
            HStore.clearAndClose(memStoreScanners);
            throw t instanceof IOException ? (IOException)t : new IOException(t);
        }
    }

    private static void clearAndClose(List<KeyValueScanner> scanners) {
        if (scanners == null) {
            return;
        }
        for (KeyValueScanner s : scanners) {
            s.close();
        }
        scanners.clear();
    }

    public List<KeyValueScanner> getScanners(List<HStoreFile> files, boolean cacheBlocks, boolean isGet, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, byte[] stopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        return this.getScanners(files, cacheBlocks, usePread, isCompaction, matcher, startRow, true, stopRow, false, readPt, includeMemstoreScanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValueScanner> getScanners(List<HStoreFile> files, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        List<KeyValueScanner> memStoreScanners = null;
        if (includeMemstoreScanner) {
            this.lock.readLock().lock();
            try {
                memStoreScanners = this.memstore.getScanners(readPt);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        try {
            List<StoreFileScanner> sfScanners = StoreFileScanner.getScannersForStoreFiles(files, cacheBlocks, usePread, isCompaction, false, matcher, readPt);
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(sfScanners.size() + 1);
            scanners.addAll(sfScanners);
            if (memStoreScanners != null) {
                scanners.addAll(memStoreScanners);
            }
            return scanners;
        }
        catch (Throwable t) {
            HStore.clearAndClose(memStoreScanners);
            throw t instanceof IOException ? (IOException)t : new IOException(t);
        }
    }

    public void addChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.add(o);
    }

    public void deleteChangedReaderObserver(ChangedReadersObserver o) {
        this.changedReaderObservers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HStoreFile> compact(CompactionContext compaction, ThroughputController throughputController, User user) throws IOException {
        assert (compaction != null);
        CompactionRequestImpl cr = compaction.getRequest();
        try {
            long compactionStartTime = EnvironmentEdgeManager.currentTime();
            assert (compaction.hasSelection());
            Collection<HStoreFile> filesToCompact = cr.getFiles();
            assert (!filesToCompact.isEmpty());
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                Preconditions.checkArgument(this.filesCompacting.containsAll(filesToCompact));
            }
            LOG.info("Starting compaction of " + filesToCompact + " into tmpdir=" + this.getRegionFileSystem().getTempDir() + ", totalSize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)cr.getSize(), (String)"", (int)1));
            list = this.doCompaction(cr, filesToCompact, user, compactionStartTime, compaction.compact(throughputController, user));
            return list;
        }
        finally {
            this.finishCompactionRequest(cr);
        }
    }

    protected List<HStoreFile> doCompaction(CompactionRequestImpl cr, Collection<HStoreFile> filesToCompact, User user, long compactionStartTime, List<Path> newFiles) throws IOException {
        this.setStoragePolicyFromFileName(newFiles);
        List<HStoreFile> sfs = this.moveCompactedFilesIntoPlace(cr, newFiles, user);
        this.writeCompactionWalRecord(filesToCompact, sfs);
        this.replaceStoreFiles(filesToCompact, sfs);
        if (cr.isMajor()) {
            this.majorCompactedCellsCount.addAndGet(this.getCompactionProgress().getTotalCompactingKVs());
            this.majorCompactedCellsSize.addAndGet(this.getCompactionProgress().totalCompactedSize);
        } else {
            this.compactedCellsCount.addAndGet(this.getCompactionProgress().getTotalCompactingKVs());
            this.compactedCellsSize.addAndGet(this.getCompactionProgress().totalCompactedSize);
        }
        long outputBytes = this.getTotalSize(sfs);
        this.completeCompaction(filesToCompact);
        long now = EnvironmentEdgeManager.currentTime();
        if (this.region.getRegionServerServices() != null && this.region.getRegionServerServices().getMetrics() != null) {
            this.region.getRegionServerServices().getMetrics().updateCompaction(this.region.getTableDescriptor().getTableName().getNameAsString(), cr.isMajor(), now - compactionStartTime, cr.getFiles().size(), newFiles.size(), cr.getSize(), outputBytes);
        }
        this.logCompactionEndMessage(cr, sfs, now, compactionStartTime);
        return sfs;
    }

    private void setStoragePolicyFromFileName(List<Path> newFiles) throws IOException {
        String prefix = "storage_policy_";
        for (Path newFile : newFiles) {
            if (!newFile.getParent().getName().startsWith(prefix)) continue;
            CommonFSUtils.setStoragePolicy(this.getRegionFileSystem().getFileSystem(), newFile, newFile.getParent().getName().substring(prefix.length()));
        }
    }

    private List<HStoreFile> moveCompactedFilesIntoPlace(CompactionRequestImpl cr, List<Path> newFiles, User user) throws IOException {
        ArrayList<HStoreFile> sfs = new ArrayList<HStoreFile>(newFiles.size());
        for (Path newFile : newFiles) {
            assert (newFile != null);
            HStoreFile sf = this.moveFileIntoPlace(newFile);
            if (this.getCoprocessorHost() != null) {
                this.getCoprocessorHost().postCompact(this, sf, cr.getTracker(), cr, user);
            }
            assert (sf != null);
            sfs.add(sf);
        }
        return sfs;
    }

    HStoreFile moveFileIntoPlace(Path newFile) throws IOException {
        this.validateStoreFile(newFile);
        Path destPath = this.getRegionFileSystem().commitStoreFile(this.getColumnFamilyName(), newFile);
        return this.createStoreFileAndReader(destPath);
    }

    private void writeCompactionWalRecord(Collection<HStoreFile> filesCompacted, Collection<HStoreFile> newFiles) throws IOException {
        if (this.region.getWAL() == null) {
            return;
        }
        List<Path> inputPaths = filesCompacted.stream().map(HStoreFile::getPath).collect(Collectors.toList());
        List<Path> outputPaths = newFiles.stream().map(HStoreFile::getPath).collect(Collectors.toList());
        RegionInfo info = this.region.getRegionInfo();
        WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor(info, this.getColumnFamilyDescriptor().getName(), inputPaths, outputPaths, this.getRegionFileSystem().getStoreDir(this.getColumnFamilyDescriptor().getNameAsString()));
        WALUtil.writeCompactionMarker(this.region.getWAL(), this.region.getReplicationScope(), this.region.getRegionInfo(), compactionDescriptor, this.region.getMVCC());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceStoreFiles(Collection<HStoreFile> compactedFiles, Collection<HStoreFile> result2) throws IOException {
        this.lock.writeLock().lock();
        try {
            this.storeEngine.getStoreFileManager().addCompactionResults(compactedFiles, result2);
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                this.filesCompacting.removeAll(compactedFiles);
            }
            RegionServerServices rsServices = this.region.getRegionServerServices();
            if (rsServices != null && rsServices.getRegionServerSpaceQuotaManager() != null) {
                this.updateSpaceQuotaAfterFileReplacement(rsServices.getRegionServerSpaceQuotaManager().getRegionSizeStore(), this.getRegionInfo(), compactedFiles, result2);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void updateSpaceQuotaAfterFileReplacement(RegionSizeStore sizeStore, RegionInfo regionInfo, Collection<HStoreFile> oldFiles, Collection<HStoreFile> newFiles) {
        long delta = 0L;
        if (oldFiles != null) {
            for (HStoreFile compactedFile : oldFiles) {
                if (!compactedFile.isHFile()) continue;
                delta -= compactedFile.getReader().length();
            }
        }
        if (newFiles != null) {
            for (HStoreFile newFile : newFiles) {
                if (!newFile.isHFile()) continue;
                delta += newFile.getReader().length();
            }
        }
        sizeStore.incrementRegionSize(regionInfo, delta);
    }

    private void logCompactionEndMessage(CompactionRequestImpl cr, List<HStoreFile> sfs, long now, long compactionStartTime) {
        StringBuilder message = new StringBuilder("Completed" + (cr.isMajor() ? " major" : "") + " compaction of " + cr.getFiles().size() + (cr.isAllFiles() ? " (all)" : "") + " file(s) in " + this + " of " + this.getRegionInfo().getShortNameToLog() + " into ");
        if (sfs.isEmpty()) {
            message.append("none, ");
        } else {
            for (HStoreFile sf : sfs) {
                message.append(sf.getPath().getName());
                message.append("(size=");
                message.append(StringUtils.TraditionalBinaryPrefix.long2String((long)sf.getReader().length(), (String)"", (int)1));
                message.append("), ");
            }
        }
        message.append("total size for store is ").append(StringUtils.TraditionalBinaryPrefix.long2String((long)this.storeSize.get(), (String)"", (int)1)).append(". This selection was in queue for ").append(StringUtils.formatTimeDiff((long)compactionStartTime, (long)cr.getSelectionTime())).append(", and took ").append(StringUtils.formatTimeDiff((long)now, (long)compactionStartTime)).append(" to execute.");
        LOG.info(message.toString());
        if (LOG.isTraceEnabled()) {
            int fileCount = this.storeEngine.getStoreFileManager().getStorefileCount();
            long resultSize = this.getTotalSize(sfs);
            String traceMessage = "COMPACTION start,end,size out,files in,files out,store size,store files [" + compactionStartTime + "," + now + "," + resultSize + "," + cr.getFiles().size() + "," + sfs.size() + "," + this.storeSize + "," + fileCount + "]";
            LOG.trace(traceMessage);
        }
    }

    public void replayCompactionMarker(WALProtos.CompactionDescriptor compaction, boolean pickCompactionFiles, boolean removeFiles) throws IOException {
        LOG.debug("Completing compaction from the WAL marker");
        ProtocolStringList compactionInputs = compaction.getCompactionInputList();
        ArrayList<String> compactionOutputs = Lists.newArrayList(compaction.getCompactionOutputList());
        String familyName = this.getColumnFamilyName();
        HashSet<String> inputFiles = new HashSet<String>();
        for (Object compactionInput : compactionInputs) {
            Path inputPath = this.getRegionFileSystem().getStoreFilePath(familyName, (String)compactionInput);
            inputFiles.add(inputPath.getName());
        }
        ArrayList<HStoreFile> inputStoreFiles = new ArrayList<HStoreFile>(compactionInputs.size());
        for (HStoreFile sf : this.getStorefiles()) {
            if (!inputFiles.contains(sf.getPath().getName())) continue;
            inputStoreFiles.add(sf);
        }
        ArrayList<HStoreFile> outputStoreFiles = new ArrayList<HStoreFile>(compactionOutputs.size());
        if (pickCompactionFiles) {
            for (HStoreFile sf : this.getStorefiles()) {
                compactionOutputs.remove(sf.getPath().getName());
            }
            for (String compactionOutput : compactionOutputs) {
                StoreFileInfo storeFileInfo = this.getRegionFileSystem().getStoreFileInfo(this.getColumnFamilyName(), compactionOutput);
                HStoreFile storeFile = this.createStoreFileAndReader(storeFileInfo);
                outputStoreFiles.add(storeFile);
            }
        }
        if (!inputStoreFiles.isEmpty() || !outputStoreFiles.isEmpty()) {
            LOG.info("Replaying compaction marker, replacing input files: " + inputStoreFiles + " with output files : " + outputStoreFiles);
            this.replaceStoreFiles(inputStoreFiles, outputStoreFiles);
            this.completeCompaction(inputStoreFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactRecentForTestingAssumingDefaultPolicy(int N) throws IOException {
        boolean isMajor;
        List<HStoreFile> filesToCompact;
        List<HStoreFile> list;
        this.lock.readLock().lock();
        try {
            list = this.filesCompacting;
            synchronized (list) {
                int count;
                filesToCompact = Lists.newArrayList(this.storeEngine.getStoreFileManager().getStorefiles());
                if (!this.filesCompacting.isEmpty()) {
                    HStoreFile last = this.filesCompacting.get(this.filesCompacting.size() - 1);
                    int idx = filesToCompact.indexOf(last);
                    Preconditions.checkArgument(idx != -1);
                    filesToCompact.subList(0, idx + 1).clear();
                }
                if (N > (count = filesToCompact.size())) {
                    throw new RuntimeException("Not enough files");
                }
                isMajor = (filesToCompact = filesToCompact.subList(count - N, count)).size() == this.storeEngine.getStoreFileManager().getStorefileCount();
                this.filesCompacting.addAll(filesToCompact);
                Collections.sort(this.filesCompacting, this.storeEngine.getStoreFileManager().getStoreFileComparator());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            List<Path> newFiles = ((DefaultCompactor)this.storeEngine.getCompactor()).compactForTesting(filesToCompact, isMajor);
            for (Path newFile : newFiles) {
                HStoreFile sf = this.moveFileIntoPlace(newFile);
                if (this.getCoprocessorHost() != null) {
                    this.getCoprocessorHost().postCompact(this, sf, null, null, null);
                }
                this.replaceStoreFiles(filesToCompact, Collections.singletonList(sf));
                this.completeCompaction(filesToCompact);
            }
        }
        finally {
            list = this.filesCompacting;
            synchronized (list) {
                this.filesCompacting.removeAll(filesToCompact);
            }
        }
    }

    @Override
    public boolean hasReferences() {
        this.lock.readLock().lock();
        try {
            ArrayList<HStoreFile> allStoreFiles = new ArrayList<HStoreFile>(this.getStorefiles());
            allStoreFiles.addAll(this.getCompactedFiles());
            boolean bl = StoreUtils.hasReferences(allStoreFiles);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompactionProgress getCompactionProgress() {
        return this.storeEngine.getCompactor().getProgress();
    }

    @Override
    public boolean shouldPerformMajorCompaction() throws IOException {
        for (HStoreFile sf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            if (sf.getReader() != null) continue;
            LOG.debug("StoreFile {} has null Reader", (Object)sf);
            return false;
        }
        return this.storeEngine.getCompactionPolicy().shouldPerformMajorCompaction(this.storeEngine.getStoreFileManager().getStorefiles());
    }

    public Optional<CompactionContext> requestCompaction() throws IOException {
        return this.requestCompaction(Integer.MIN_VALUE, CompactionLifeCycleTracker.DUMMY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<CompactionContext> requestCompaction(int priority, CompactionLifeCycleTracker tracker, User user) throws IOException {
        if (!this.areWritesEnabled()) {
            return Optional.empty();
        }
        this.removeUnneededFiles();
        CompactionContext compaction = this.storeEngine.createCompaction();
        CompactionRequestImpl request = null;
        this.lock.readLock().lock();
        try {
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                Collection<HStoreFile> selectedFiles;
                block20: {
                    if (this.getCoprocessorHost() != null) {
                        List<HStoreFile> candidatesForCoproc = compaction.preSelect(this.filesCompacting);
                        boolean override = this.getCoprocessorHost().preCompactSelection(this, candidatesForCoproc, tracker, user);
                        if (override) {
                            compaction.forceSelect(new CompactionRequestImpl(candidatesForCoproc));
                        }
                    }
                    if (!compaction.hasSelection()) {
                        boolean isUserCompaction = priority == 1;
                        boolean mayUseOffPeak = this.offPeakHours.isOffPeakHour() && offPeakCompactionTracker.compareAndSet(false, true);
                        try {
                            compaction.select(this.filesCompacting, isUserCompaction, mayUseOffPeak, this.forceMajor && this.filesCompacting.isEmpty());
                        }
                        catch (IOException e) {
                            if (mayUseOffPeak) {
                                offPeakCompactionTracker.set(false);
                            }
                            throw e;
                        }
                        assert (compaction.hasSelection());
                        if (mayUseOffPeak && !compaction.getRequest().isOffPeak()) {
                            offPeakCompactionTracker.set(false);
                        }
                    }
                    if (this.getCoprocessorHost() != null) {
                        this.getCoprocessorHost().postCompactSelection(this, ImmutableList.copyOf(compaction.getRequest().getFiles()), tracker, compaction.getRequest(), user);
                    }
                    if (!(selectedFiles = (request = compaction.getRequest()).getFiles()).isEmpty()) break block20;
                    Optional<CompactionContext> mayUseOffPeak = Optional.empty();
                    return mayUseOffPeak;
                }
                this.addToCompactingFiles(selectedFiles);
                this.forceMajor = this.forceMajor && !request.isMajor();
                int compactionPriority = priority != Integer.MIN_VALUE ? priority : this.getCompactPriority();
                request.setPriority(compactionPriority);
                if (request.isAfterSplit()) {
                    int splitHousekeepingPriority = Math.min(compactionPriority, -2147482648);
                    request.setPriority(splitHousekeepingPriority);
                    LOG.info("Keeping/Overriding Compaction request priority to {} for CF {} since it belongs to recently split daughter region {}", new Object[]{splitHousekeepingPriority, this.getColumnFamilyName(), this.getRegionInfo().getRegionNameAsString()});
                }
                request.setDescription(this.getRegionInfo().getRegionNameAsString(), this.getColumnFamilyName());
                request.setTracker(tracker);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " is initiating " + (request.isMajor() ? "major" : "minor") + " compaction" + (request.isAllFiles() ? " (all files)" : ""));
        }
        this.region.reportCompactionRequestStart(request.isMajor());
        return Optional.of(compaction);
    }

    private void addToCompactingFiles(Collection<HStoreFile> filesToAdd) {
        if (CollectionUtils.isEmpty(filesToAdd)) {
            return;
        }
        if (!Collections.disjoint(this.filesCompacting, filesToAdd)) {
            Preconditions.checkArgument(false, "%s overlaps with %s", filesToAdd, this.filesCompacting);
        }
        this.filesCompacting.addAll(filesToAdd);
        Collections.sort(this.filesCompacting, this.storeEngine.getStoreFileManager().getStoreFileComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnneededFiles() throws IOException {
        if (!this.conf.getBoolean("hbase.store.delete.expired.storefile", true)) {
            return;
        }
        if (this.getColumnFamilyDescriptor().getMinVersions() > 0) {
            LOG.debug("Skipping expired store file removal due to min version of {} being {}", (Object)this, (Object)this.getColumnFamilyDescriptor().getMinVersions());
            return;
        }
        this.lock.readLock().lock();
        Collection<HStoreFile> delSfs = null;
        try {
            List<HStoreFile> list = this.filesCompacting;
            synchronized (list) {
                long cfTtl = this.getStoreFileTtl();
                if (cfTtl != Long.MAX_VALUE) {
                    delSfs = this.storeEngine.getStoreFileManager().getUnneededFiles(EnvironmentEdgeManager.currentTime() - cfTtl, this.filesCompacting);
                    this.addToCompactingFiles(delSfs);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (CollectionUtils.isEmpty(delSfs)) {
            return;
        }
        List<HStoreFile> newFiles = Collections.emptyList();
        this.writeCompactionWalRecord(delSfs, newFiles);
        this.replaceStoreFiles(delSfs, newFiles);
        this.completeCompaction(delSfs);
        LOG.info("Completed removal of " + delSfs.size() + " unnecessary (expired) file(s) in " + this + "; total size is " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.storeSize.get(), (String)"", (int)1));
    }

    public void cancelRequestedCompaction(CompactionContext compaction) {
        this.finishCompactionRequest(compaction.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCompactionRequest(CompactionRequestImpl cr) {
        this.region.reportCompactionRequestEnd(cr.isMajor(), cr.getFiles().size(), cr.getSize());
        if (cr.isOffPeak()) {
            offPeakCompactionTracker.set(false);
            cr.setOffPeak(false);
        }
        List<HStoreFile> list = this.filesCompacting;
        synchronized (list) {
            this.filesCompacting.removeAll(cr.getFiles());
        }
    }

    private void validateStoreFile(Path path) throws IOException {
        HStoreFile storeFile = null;
        try {
            storeFile = this.createStoreFileAndReader(path);
        }
        catch (IOException e) {
            LOG.error("Failed to open store file : {}, keeping it in tmp location", (Object)path, (Object)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeStoreFile(false);
            }
        }
    }

    protected void completeCompaction(Collection<HStoreFile> compactedFiles) throws IOException {
        this.storeSize.set(0L);
        this.totalUncompressedBytes.set(0L);
        for (HStoreFile hsf : this.storeEngine.getStoreFileManager().getStorefiles()) {
            StoreFileReader r = hsf.getReader();
            if (r == null) {
                LOG.warn("StoreFile {} has a null Reader", (Object)hsf);
                continue;
            }
            this.storeSize.addAndGet(r.length());
            this.totalUncompressedBytes.addAndGet(r.getTotalUncompressedBytes());
        }
    }

    int versionsToReturn(int wantedVersions) {
        if (wantedVersions <= 0) {
            throw new IllegalArgumentException("Number of versions must be > 0");
        }
        int maxVersions = this.getColumnFamilyDescriptor().getMaxVersions();
        return wantedVersions > maxVersions ? maxVersions : wantedVersions;
    }

    @Override
    public boolean canSplit() {
        boolean result2;
        boolean bl = result2 = !this.hasReferences();
        if (!result2) {
            LOG.trace("Not splittable; has references: {}", (Object)this);
        }
        return result2;
    }

    public Optional<byte[]> getSplitPoint() {
        this.lock.readLock().lock();
        try {
            assert (!this.getRegionInfo().isMetaRegion());
            if (this.hasReferences()) {
                LOG.trace("Not splittable; has references: {}", (Object)this);
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            Optional<byte[]> optional = this.storeEngine.getStoreFileManager().getSplitPoint();
            return optional;
        }
        catch (IOException e) {
            LOG.warn("Failed getting store size for {}", (Object)this, (Object)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Optional.empty();
    }

    @Override
    public long getLastCompactSize() {
        return this.lastCompactSize;
    }

    @Override
    public long getSize() {
        return this.storeSize.get();
    }

    public void triggerMajorCompaction() {
        this.forceMajor = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner getScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        this.lock.readLock().lock();
        try {
            ScanInfo scanInfo = this.getCoprocessorHost() != null ? this.getCoprocessorHost().preStoreScannerOpen(this, scan) : this.getScanInfo();
            KeyValueScanner keyValueScanner = this.createScanner(scan, scanInfo, targetCols, readPt);
            return keyValueScanner;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected KeyValueScanner createScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        return scan.isReversed() ? new ReversedStoreScanner(this, scanInfo, scan, targetCols, readPt) : new StoreScanner(this, scanInfo, scan, targetCols, readPt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyValueScanner> recreateScanners(List<KeyValueScanner> currentFileScanners, boolean cacheBlocks, boolean usePread, boolean isCompaction, ScanQueryMatcher matcher, byte[] startRow, boolean includeStartRow, byte[] stopRow, boolean includeStopRow, long readPt, boolean includeMemstoreScanner) throws IOException {
        this.lock.readLock().lock();
        try {
            Object object;
            HashMap<String, HStoreFile> name2File = new HashMap<String, HStoreFile>(this.getStorefilesCount() + this.getCompactedFilesCount());
            for (HStoreFile hStoreFile : this.getStorefiles()) {
                name2File.put(hStoreFile.getFileInfo().getActiveFileName(), hStoreFile);
            }
            Collection<HStoreFile> compactedFiles = this.getCompactedFiles();
            for (HStoreFile file : IterableUtils.emptyIfNull(compactedFiles)) {
                name2File.put(file.getFileInfo().getActiveFileName(), file);
            }
            ArrayList<HStoreFile> arrayList = new ArrayList<HStoreFile>();
            for (KeyValueScanner kvs : currentFileScanners) {
                assert (kvs.isFileScanner());
                if (kvs.peek() == null) continue;
                arrayList.add((HStoreFile)name2File.get(kvs.getFilePath().getName()));
            }
            if (arrayList.isEmpty()) {
                object = null;
                return object;
            }
            object = this.getScanners(arrayList, cacheBlocks, false, false, matcher, startRow, includeStartRow, stopRow, includeStopRow, readPt, false);
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        return this.getRegionInfo().getShortNameToLog() + "/" + this.getColumnFamilyName();
    }

    @Override
    public int getStorefilesCount() {
        return this.storeEngine.getStoreFileManager().getStorefileCount();
    }

    @Override
    public int getCompactedFilesCount() {
        return this.storeEngine.getStoreFileManager().getCompactedFilesCount();
    }

    private LongStream getStoreFileAgeStream() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(sf -> {
            if (sf.getReader() == null) {
                LOG.warn("StoreFile {} has a null Reader", sf);
                return false;
            }
            return true;
        }).filter(HStoreFile::isHFile).mapToLong(sf -> sf.getFileInfo().getCreatedTimestamp()).map(t -> EnvironmentEdgeManager.currentTime() - t);
    }

    @Override
    public OptionalLong getMaxStoreFileAge() {
        return this.getStoreFileAgeStream().max();
    }

    @Override
    public OptionalLong getMinStoreFileAge() {
        return this.getStoreFileAgeStream().min();
    }

    @Override
    public OptionalDouble getAvgStoreFileAge() {
        return this.getStoreFileAgeStream().average();
    }

    @Override
    public long getNumReferenceFiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(HStoreFile::isReference).count();
    }

    @Override
    public long getNumHFiles() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(HStoreFile::isHFile).count();
    }

    @Override
    public long getStoreSizeUncompressed() {
        return this.totalUncompressedBytes.get();
    }

    @Override
    public long getStorefilesSize() {
        return this.getStorefilesSize(this.storeEngine.getStoreFileManager().getStorefiles(), sf -> true);
    }

    @Override
    public long getHFilesSize() {
        return this.getStorefilesSize(this.storeEngine.getStoreFileManager().getStorefiles(), HStoreFile::isHFile);
    }

    private long getTotalUncompressedBytes(List<HStoreFile> files) {
        return files.stream().mapToLong(file -> this.getStorefileFieldSize((HStoreFile)file, StoreFileReader::getTotalUncompressedBytes)).sum();
    }

    private long getStorefilesSize(Collection<HStoreFile> files, Predicate<HStoreFile> predicate) {
        return files.stream().filter(predicate).mapToLong(file -> this.getStorefileFieldSize((HStoreFile)file, StoreFileReader::length)).sum();
    }

    private long getStorefileFieldSize(HStoreFile file, ToLongFunction<StoreFileReader> f) {
        if (file == null) {
            return 0L;
        }
        StoreFileReader reader = file.getReader();
        if (reader == null) {
            return 0L;
        }
        return f.applyAsLong(reader);
    }

    private long getStorefilesFieldSize(ToLongFunction<StoreFileReader> f) {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().mapToLong(file -> this.getStorefileFieldSize((HStoreFile)file, f)).sum();
    }

    @Override
    public long getStorefilesRootLevelIndexSize() {
        return this.getStorefilesFieldSize(StoreFileReader::indexSize);
    }

    @Override
    public long getTotalStaticIndexSize() {
        return this.getStorefilesFieldSize(StoreFileReader::getUncompressedDataIndexSize);
    }

    @Override
    public long getTotalStaticBloomSize() {
        return this.getStorefilesFieldSize(StoreFileReader::getTotalBloomSize);
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return this.memstore.size();
    }

    @Override
    public int getCompactPriority() {
        int priority = this.storeEngine.getStoreFileManager().getStoreCompactionPriority();
        if (priority == 1) {
            LOG.warn("Compaction priority is USER despite there being no user compaction");
        }
        return priority;
    }

    public boolean throttleCompaction(long compactionSize) {
        return this.storeEngine.getCompactionPolicy().throttleCompaction(compactionSize);
    }

    public HRegion getHRegion() {
        return this.region;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.region.getCoprocessorHost();
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.getRegionFileSystem().getRegionInfo();
    }

    @Override
    public boolean areWritesEnabled() {
        return this.region.areWritesEnabled();
    }

    @Override
    public long getSmallestReadPoint() {
        return this.region.getSmallestReadPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsert(Iterable<Cell> cells, long readpoint, MemStoreSizing memstoreSizing) throws IOException {
        this.lock.readLock().lock();
        try {
            this.memstore.upsert(cells, readpoint, memstoreSizing);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public StoreFlushContext createFlushContext(long cacheFlushId, FlushLifeCycleTracker tracker) {
        return new StoreFlusherImpl(cacheFlushId, tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsCompaction() {
        ArrayList<HStoreFile> filesCompactingClone = null;
        List<HStoreFile> list = this.filesCompacting;
        synchronized (list) {
            filesCompactingClone = Lists.newArrayList(this.filesCompacting);
        }
        return this.storeEngine.needsCompaction(filesCompactingClone);
    }

    public CacheConfig getCacheConfig() {
        return this.storeContext.getCacheConf();
    }

    @Override
    public long heapSize() {
        MemStoreSize memstoreSize = this.memstore.size();
        return DEEP_OVERHEAD + memstoreSize.getHeapSize() + this.storeContext.heapSize();
    }

    @Override
    public CellComparator getComparator() {
        return this.storeContext.getComparator();
    }

    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    void setScanInfo(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
    }

    @Override
    public boolean hasTooManyStoreFiles() {
        return (long)this.getStorefilesCount() > this.blockingFileCount;
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount.get();
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize.get();
    }

    @Override
    public long getFlushedOutputFileSize() {
        return this.flushedOutputFileSize.get();
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount.get();
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize.get();
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount.get();
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize.get();
    }

    public StoreEngine<?, ?, ?, ?> getStoreEngine() {
        return this.storeEngine;
    }

    protected OffPeakHours getOffPeakHours() {
        return this.offPeakHours;
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        Configuration storeConf;
        this.conf = storeConf = StoreUtils.createStoreConfiguration(conf, this.region.getTableDescriptor(), this.getColumnFamilyDescriptor());
        ((CompactionPolicy)this.storeEngine.compactionPolicy).setConf(storeConf);
        this.offPeakHours = OffPeakHours.getInstance(storeConf);
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    @Override
    public double getCompactionPressure() {
        return this.storeEngine.getStoreFileManager().getCompactionPressure();
    }

    @Override
    public boolean isPrimaryReplicaStore() {
        return this.getRegionInfo().getReplicaId() == 0;
    }

    public void preSnapshotOperation() {
        this.archiveLock.lock();
    }

    public void postSnapshotOperation() {
        this.archiveLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeAndArchiveCompactedFiles() throws IOException {
        this.archiveLock.lock();
        try {
            this.lock.readLock().lock();
            ArrayList<HStoreFile> copyCompactedfiles = null;
            try {
                Collection<HStoreFile> compactedfiles = this.getStoreEngine().getStoreFileManager().getCompactedfiles();
                if (CollectionUtils.isNotEmpty(compactedfiles)) {
                    copyCompactedfiles = new ArrayList<HStoreFile>(compactedfiles);
                } else {
                    LOG.trace("No compacted files to archive");
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            if (CollectionUtils.isNotEmpty(copyCompactedfiles)) {
                this.removeCompactedfiles(copyCompactedfiles, true);
            }
        }
        finally {
            this.archiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCompactedfiles(Collection<HStoreFile> compactedfiles, boolean evictOnClose) throws IOException {
        ArrayList<HStoreFile> filesToRemove = new ArrayList<HStoreFile>(compactedfiles.size());
        ArrayList<Long> storeFileSizes = new ArrayList<Long>(compactedfiles.size());
        Iterator<HStoreFile> iterator2 = compactedfiles.iterator();
        while (iterator2.hasNext()) {
            HStoreFile file;
            HStoreFile hStoreFile = file = iterator2.next();
            synchronized (hStoreFile) {
                try {
                    long length;
                    StoreFileReader r = file.getReader();
                    if (r == null) {
                        LOG.debug("The file {} was closed but still not archived", (Object)file);
                        length = this.getStoreFileSize(file);
                        filesToRemove.add(file);
                        storeFileSizes.add(length);
                        continue;
                    }
                    if (file.isCompactedAway() && !file.isReferencedInReads()) {
                        LOG.trace("Closing and archiving the file {}", (Object)file);
                        length = r.length();
                        r.close(evictOnClose);
                        filesToRemove.add(file);
                        storeFileSizes.add(length);
                    } else {
                        LOG.info("Can't archive compacted file " + file.getPath() + " because of either isCompactedAway=" + file.isCompactedAway() + " or file has reference, isReferencedInReads=" + file.isReferencedInReads() + ", refCount=" + r.getRefCount() + ", skipping for now.");
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while trying to close the compacted store file {}", (Object)file.getPath(), (Object)e);
                }
            }
        }
        if (this.isPrimaryReplicaStore() && !filesToRemove.isEmpty()) {
            LOG.debug("Moving the files {} to archive", filesToRemove);
            try {
                this.getRegionFileSystem().removeStoreFiles(this.getColumnFamilyDescriptor().getNameAsString(), filesToRemove);
            }
            catch (FailedArchiveException fae) {
                Collection<Path> failedFiles = fae.getFailedFiles();
                Iterator iter = filesToRemove.iterator();
                Iterator sizeIter = storeFileSizes.iterator();
                while (iter.hasNext()) {
                    sizeIter.next();
                    if (!failedFiles.contains(((HStoreFile)iter.next()).getPath())) continue;
                    iter.remove();
                    sizeIter.remove();
                }
                if (!filesToRemove.isEmpty()) {
                    this.clearCompactedfiles(filesToRemove);
                }
                throw fae;
            }
        }
        if (!filesToRemove.isEmpty()) {
            this.clearCompactedfiles(filesToRemove);
            this.reportArchivedFilesForQuota(filesToRemove, storeFileSizes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    long getStoreFileSize(HStoreFile file) {
        long length;
        block10: {
            length = 0L;
            file.initReader();
            length = file.getReader().length();
            try {
                file.closeStoreFile(file.getCacheConf() != null ? file.getCacheConf().shouldEvictOnClose() : true);
            }
            catch (IOException e) {
                LOG.trace("Failed to close reader after computing store file size for {}, ignoring", (Object)file, (Object)e);
            }
            break block10;
            catch (IOException e) {
                try {
                    LOG.trace("Failed to open reader when trying to compute store file size for {}, ignoring", (Object)file, (Object)e);
                }
                catch (Throwable throwable) {
                    try {
                        file.closeStoreFile(file.getCacheConf() != null ? file.getCacheConf().shouldEvictOnClose() : true);
                    }
                    catch (IOException e2) {
                        LOG.trace("Failed to close reader after computing store file size for {}, ignoring", (Object)file, (Object)e2);
                    }
                    throw throwable;
                }
                try {
                    file.closeStoreFile(file.getCacheConf() != null ? file.getCacheConf().shouldEvictOnClose() : true);
                }
                catch (IOException e3) {
                    LOG.trace("Failed to close reader after computing store file size for {}, ignoring", (Object)file, (Object)e3);
                }
            }
        }
        return length;
    }

    public Long preFlushSeqIDEstimation() {
        return this.memstore.preFlushSeqIDEstimation();
    }

    @Override
    public boolean isSloppyMemStore() {
        return this.memstore.isSloppy();
    }

    private void clearCompactedfiles(List<HStoreFile> filesToRemove) throws IOException {
        LOG.trace("Clearing the compacted file {} from this store", filesToRemove);
        try {
            this.lock.writeLock().lock();
            this.getStoreEngine().getStoreFileManager().removeCompactedFiles(filesToRemove);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getCurrentParallelPutCount() {
        return this.currentParallelPutCount.get();
    }

    public int getStoreRefCount() {
        return this.storeEngine.getStoreFileManager().getStorefiles().stream().filter(sf -> sf.getReader() != null).filter(HStoreFile::isHFile).mapToInt(HStoreFile::getRefCount).sum();
    }

    public int getMaxCompactedStoreFileRefCount() {
        OptionalInt maxCompactedStoreFileRefCount = this.storeEngine.getStoreFileManager().getCompactedfiles().stream().filter(sf -> sf.getReader() != null).filter(HStoreFile::isHFile).mapToInt(HStoreFile::getRefCount).max();
        return maxCompactedStoreFileRefCount.isPresent() ? maxCompactedStoreFileRefCount.getAsInt() : 0;
    }

    void reportArchivedFilesForQuota(List<? extends StoreFile> archivedFiles, List<Long> fileSizes) {
        boolean success;
        if (archivedFiles.size() != fileSizes.size()) {
            throw new RuntimeException("Coding error: should never see lists of varying size");
        }
        RegionServerServices rss = this.region.getRegionServerServices();
        if (rss == null) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> filesWithSizes = new ArrayList<Map.Entry<String, Long>>(archivedFiles.size());
        Iterator<Long> fileSizeIter = fileSizes.iterator();
        for (StoreFile storeFile : archivedFiles) {
            long fileSize = fileSizeIter.next();
            if (!storeFile.isHFile() || fileSize == 0L) continue;
            filesWithSizes.add(Maps.immutableEntry(storeFile.getPath().getName(), fileSize));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Files archived: " + archivedFiles + ", reporting the following to the Master: " + filesWithSizes);
        }
        if (!(success = rss.reportFileArchivalForQuotas(this.getTableName(), filesWithSizes))) {
            LOG.warn("Failed to report archival of files: " + filesWithSizes);
        }
    }

    @Override
    public long getMemstoreOnlyRowReadsCount() {
        return this.memstoreOnlyRowReadsCount.sum();
    }

    @Override
    public long getMixedRowReadsCount() {
        return this.mixedRowReadsCount.sum();
    }

    @Override
    public Configuration getReadOnlyConfiguration() {
        return new ReadOnlyConfiguration(this.conf);
    }

    void updateMetricsStore(boolean memstoreRead) {
        if (memstoreRead) {
            this.memstoreOnlyRowReadsCount.increment();
        } else {
            this.mixedRowReadsCount.increment();
        }
    }

    private final class StoreFlusherImpl
    implements StoreFlushContext {
        private final FlushLifeCycleTracker tracker;
        private final long cacheFlushSeqNum;
        private MemStoreSnapshot snapshot;
        private List<Path> tempFiles;
        private List<Path> committedFiles;
        private long cacheFlushCount;
        private long cacheFlushSize;
        private long outputFileSize;

        private StoreFlusherImpl(long cacheFlushSeqNum, FlushLifeCycleTracker tracker) {
            this.cacheFlushSeqNum = cacheFlushSeqNum;
            this.tracker = tracker;
        }

        @Override
        public MemStoreSize prepare() {
            this.snapshot = HStore.this.memstore.snapshot();
            this.cacheFlushCount = this.snapshot.getCellsCount();
            this.cacheFlushSize = this.snapshot.getDataSize();
            this.committedFiles = new ArrayList<Path>(1);
            return this.snapshot.getMemStoreSize();
        }

        @Override
        public void flushCache(MonitoredTask status) throws IOException {
            RegionServerServices rsService = HStore.this.region.getRegionServerServices();
            ThroughputController throughputController = rsService == null ? null : rsService.getFlushThroughputController();
            this.tempFiles = HStore.this.flushCache(this.cacheFlushSeqNum, this.snapshot, status, throughputController, this.tracker);
        }

        @Override
        public boolean commit(MonitoredTask status) throws IOException {
            if (CollectionUtils.isEmpty(this.tempFiles)) {
                return false;
            }
            ArrayList<HStoreFile> storeFiles = new ArrayList<HStoreFile>(this.tempFiles.size());
            for (Path storeFilePath : this.tempFiles) {
                try {
                    HStoreFile sf = HStore.this.commitFile(storeFilePath, this.cacheFlushSeqNum, status);
                    this.outputFileSize += sf.getReader().length();
                    storeFiles.add(sf);
                }
                catch (IOException ex) {
                    LOG.error("Failed to commit store file {}", (Object)storeFilePath, (Object)ex);
                    for (HStoreFile sf : storeFiles) {
                        Path pathToDelete = sf.getPath();
                        try {
                            sf.deleteStoreFile();
                        }
                        catch (IOException deleteEx) {
                            LOG.error(HBaseMarkers.FATAL, "Failed to delete store file we committed, halting {}", (Object)pathToDelete, (Object)ex);
                            Runtime.getRuntime().halt(1);
                        }
                    }
                    throw new IOException("Failed to commit the flush", ex);
                }
            }
            for (HStoreFile sf : storeFiles) {
                if (HStore.this.getCoprocessorHost() != null) {
                    HStore.this.getCoprocessorHost().postFlush(HStore.this, sf, this.tracker);
                }
                this.committedFiles.add(sf.getPath());
            }
            HStore.this.flushedCellsCount.addAndGet(this.cacheFlushCount);
            HStore.this.flushedCellsSize.addAndGet(this.cacheFlushSize);
            HStore.this.flushedOutputFileSize.addAndGet(this.outputFileSize);
            return HStore.this.updateStorefiles(storeFiles, this.snapshot.getId());
        }

        @Override
        public long getOutputFileSize() {
            return this.outputFileSize;
        }

        @Override
        public List<Path> getCommittedFiles() {
            return this.committedFiles;
        }

        @Override
        public void replayFlush(List<String> fileNames, boolean dropMemstoreSnapshot) throws IOException {
            ArrayList<HStoreFile> storeFiles = new ArrayList<HStoreFile>(fileNames.size());
            for (String file : fileNames) {
                StoreFileInfo storeFileInfo = HStore.this.getRegionFileSystem().getStoreFileInfo(HStore.this.getColumnFamilyName(), file);
                HStoreFile storeFile = HStore.this.createStoreFileAndReader(storeFileInfo);
                storeFiles.add(storeFile);
                HStore.this.storeSize.addAndGet(storeFile.getReader().length());
                HStore.this.totalUncompressedBytes.addAndGet(storeFile.getReader().getTotalUncompressedBytes());
                if (!LOG.isInfoEnabled()) continue;
                LOG.info(this + " added " + storeFile + ", entries=" + storeFile.getReader().getEntries() + ", sequenceid=" + storeFile.getReader().getSequenceID() + ", filesize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)storeFile.getReader().length(), (String)"", (int)1));
            }
            long snapshotId = -1L;
            if (dropMemstoreSnapshot && this.snapshot != null) {
                snapshotId = this.snapshot.getId();
            }
            HStore.this.updateStorefiles(storeFiles, snapshotId);
        }

        @Override
        public void abort() throws IOException {
            if (this.snapshot != null) {
                HStore.this.updateStorefiles(Collections.emptyList(), this.snapshot.getId());
            }
        }
    }
}

