/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.text.NumberFormat;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterBase;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterChunk;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteArrayHashKey;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CellHashKey;
import org.apache.hudi.org.apache.hadoop.hbase.util.Hash;
import org.apache.hudi.org.apache.hadoop.hbase.util.HashKey;
import org.apache.hudi.org.apache.hadoop.hbase.util.RowBloomHashKey;
import org.apache.hudi.org.apache.hadoop.hbase.util.RowColBloomHashKey;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class BloomFilterUtil {
    public static final String STATS_RECORD_SEP = "; ";
    public static final double LOG2_SQUARED = Math.log(2.0) * Math.log(2.0);
    private static Random randomGeneratorForTest;
    public static final String PREFIX_LENGTH_KEY = "RowPrefixBloomFilter.prefix_length";
    public static final byte[] bitvals;

    private BloomFilterUtil() {
    }

    public static long computeBitSize(long maxKeys, double errorRate) {
        return (long)Math.ceil((double)maxKeys * (-Math.log(errorRate) / LOG2_SQUARED));
    }

    public static void setRandomGeneratorForTest(Random random) {
        randomGeneratorForTest = random;
    }

    public static long idealMaxKeys(long bitSize, double errorRate) {
        return (long)((double)bitSize * (LOG2_SQUARED / -Math.log(errorRate)));
    }

    public static long computeMaxKeys(long bitSize, double errorRate, int hashCount) {
        return (long)((double)(-bitSize) * 1.0 / (double)hashCount * Math.log(1.0 - Math.exp(Math.log(errorRate) / (double)hashCount)));
    }

    public static double actualErrorRate(long maxKeys, long bitSize, int functionCount) {
        return Math.exp(Math.log(1.0 - Math.exp((double)((long)(-functionCount) * maxKeys) * 1.0 / (double)bitSize)) * (double)functionCount);
    }

    public static int computeFoldableByteSize(long bitSize, int foldFactor) {
        int mask = (1 << foldFactor) - 1;
        long byteSizeLong = (bitSize + 7L) / 8L;
        if (((long)mask & byteSizeLong) != 0L) {
            byteSizeLong >>= foldFactor;
            ++byteSizeLong;
            byteSizeLong <<= foldFactor;
        }
        if (byteSizeLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteSize=" + byteSizeLong + " too large for bitSize=" + bitSize + ", foldFactor=" + foldFactor);
        }
        return (int)byteSizeLong;
    }

    public static int optimalFunctionCount(int maxKeys, long bitSize) {
        long i = bitSize / (long)maxKeys;
        double result2 = Math.ceil(Math.log(2.0) * (double)i);
        if (result2 > 2.147483647E9) {
            throw new IllegalArgumentException("result too large for integer value.");
        }
        return (int)result2;
    }

    public static BloomFilterChunk createBySize(int byteSizeHint, double errorRate, int hashType, int foldFactor, BloomType bloomType) {
        BloomFilterChunk bbf = new BloomFilterChunk(hashType, bloomType);
        bbf.byteSize = BloomFilterUtil.computeFoldableByteSize((long)byteSizeHint * 8L, foldFactor);
        long bitSize = bbf.byteSize * 8L;
        bbf.maxKeys = (int)BloomFilterUtil.idealMaxKeys(bitSize, errorRate);
        bbf.hashCount = BloomFilterUtil.optimalFunctionCount(bbf.maxKeys, bitSize);
        bbf.maxKeys = (int)BloomFilterUtil.computeMaxKeys(bitSize, errorRate, bbf.hashCount);
        return bbf;
    }

    public static boolean contains(byte[] buf, int offset, int length, ByteBuff bloomBuf, int bloomOffset, int bloomSize, Hash hash, int hashCount) {
        ByteArrayHashKey hashKey = new ByteArrayHashKey(buf, offset, length);
        return BloomFilterUtil.contains(bloomBuf, bloomOffset, bloomSize, hash, hashCount, hashKey);
    }

    private static <T> boolean contains(ByteBuff bloomBuf, int bloomOffset, int bloomSize, Hash hash, int hashCount, HashKey<T> hashKey) {
        int hash1 = hash.hash(hashKey, 0);
        int bloomBitSize = bloomSize << 3;
        int hash2 = 0;
        int compositeHash = 0;
        if (randomGeneratorForTest == null) {
            compositeHash = hash1;
            hash2 = hash.hash(hashKey, hash1);
        }
        for (int i = 0; i < hashCount; ++i) {
            int hashLoc = randomGeneratorForTest == null ? Math.abs(compositeHash % bloomBitSize) : randomGeneratorForTest.nextInt(bloomBitSize);
            compositeHash += hash2;
            if (BloomFilterUtil.checkBit(hashLoc, bloomBuf, bloomOffset)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Cell cell, ByteBuff bloomBuf, int bloomOffset, int bloomSize, Hash hash, int hashCount, BloomType type2) {
        CellHashKey hashKey = type2 == BloomType.ROWCOL ? new RowColBloomHashKey(cell) : new RowBloomHashKey(cell);
        return BloomFilterUtil.contains(bloomBuf, bloomOffset, bloomSize, hash, hashCount, hashKey);
    }

    static boolean checkBit(int pos, ByteBuff bloomBuf, int bloomOffset) {
        int bytePos = pos >> 3;
        int bitPos = pos & 7;
        byte curByte = bloomBuf.get(bloomOffset + bytePos);
        return (curByte = (byte)(curByte & bitvals[bitPos])) != 0;
    }

    public static String formatStats(BloomFilterBase bloomFilter) {
        StringBuilder sb = new StringBuilder();
        long k = bloomFilter.getKeyCount();
        long m = bloomFilter.getMaxKeys();
        sb.append("BloomSize: " + bloomFilter.getByteSize() + STATS_RECORD_SEP);
        sb.append("No of Keys in bloom: " + k + STATS_RECORD_SEP);
        sb.append("Max Keys for bloom: " + m);
        if (m > 0L) {
            sb.append("; Percentage filled: " + NumberFormat.getPercentInstance().format((double)k * 1.0 / (double)m));
        }
        return sb.toString();
    }

    public static String toString(BloomFilterChunk bloomFilter) {
        return BloomFilterUtil.formatStats(bloomFilter) + STATS_RECORD_SEP + "Actual error rate: " + String.format("%.8f", bloomFilter.actualErrorRate());
    }

    public static byte[] getBloomFilterParam(BloomType bloomFilterType, Configuration conf) throws IllegalArgumentException {
        byte[] bloomParam = null;
        String message = "Bloom filter type is " + (Object)((Object)bloomFilterType) + ", ";
        if (bloomFilterType.equals((Object)BloomType.ROWPREFIX_FIXED_LENGTH)) {
            int prefixLength;
            String prefixLengthString = conf.get(PREFIX_LENGTH_KEY);
            if (prefixLengthString == null) {
                message = message + "RowPrefixBloomFilter.prefix_length not specified.";
                throw new IllegalArgumentException(message);
            }
            try {
                prefixLength = Integer.parseInt(prefixLengthString);
                if (prefixLength <= 0 || prefixLength > Short.MAX_VALUE) {
                    message = message + "the value of RowPrefixBloomFilter.prefix_length must >=0 and < 32767";
                    throw new IllegalArgumentException(message);
                }
            }
            catch (NumberFormatException nfe) {
                message = "Number format exception when parsing RowPrefixBloomFilter.prefix_length for BloomType " + bloomFilterType.toString() + ":" + prefixLengthString;
                throw new IllegalArgumentException(message, nfe);
            }
            bloomParam = Bytes.toBytes(prefixLength);
        }
        return bloomParam;
    }

    static {
        bitvals = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    }
}

