/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.metrics2.lib;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsExecutorImpl
implements MetricsExecutor {
    @Override
    public ScheduledExecutorService getExecutor() {
        return ExecutorSingleton.INSTANCE.scheduler;
    }

    @Override
    public void stop() {
        if (!this.getExecutor().isShutdown()) {
            this.getExecutor().shutdown();
        }
    }

    private static final class ThreadPoolExecutorThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private ThreadPoolExecutorThreadFactory(String name2) {
            this.name = name2;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, this.name + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    private static enum ExecutorSingleton {
        INSTANCE;

        private final transient ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1, new ThreadPoolExecutorThreadFactory("HBase-Metrics2-"));
    }
}

