/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.dns;

import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.CorruptedFrameException;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.CharsetUtil;

final class DnsCodecUtil {
    private DnsCodecUtil() {
    }

    static void encodeDomainName(String name2, ByteBuf buf) {
        String label;
        int labelLen;
        String[] labels;
        if (".".equals(name2)) {
            buf.writeByte(0);
            return;
        }
        String[] stringArray = labels = name2.split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n && (labelLen = (label = stringArray[i]).length()) != 0; ++i) {
            buf.writeByte(labelLen);
            ByteBufUtil.writeAscii(buf, (CharSequence)label);
        }
        buf.writeByte(0);
    }

    static String decodeDomainName(ByteBuf in) {
        int position = -1;
        int checked = 0;
        int end = in.writerIndex();
        int readable = in.readableBytes();
        if (readable == 0) {
            return ".";
        }
        StringBuilder name2 = new StringBuilder(readable << 1);
        while (in.isReadable()) {
            boolean pointer;
            short len = in.readUnsignedByte();
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                if (position == -1) {
                    position = in.readerIndex() + 1;
                }
                if (!in.isReadable()) {
                    throw new CorruptedFrameException("truncated pointer in a name");
                }
                int next = (len & 0x3F) << 8 | in.readUnsignedByte();
                if (next >= end) {
                    throw new CorruptedFrameException("name has an out-of-range pointer");
                }
                in.readerIndex(next);
                if ((checked += 2) < end) continue;
                throw new CorruptedFrameException("name contains a loop.");
            }
            if (len == 0) break;
            if (!in.isReadable(len)) {
                throw new CorruptedFrameException("truncated label in a name");
            }
            name2.append(in.toString(in.readerIndex(), len, CharsetUtil.UTF_8)).append('.');
            in.skipBytes(len);
        }
        if (position != -1) {
            in.readerIndex(position);
        }
        if (name2.length() == 0) {
            return ".";
        }
        if (name2.charAt(name2.length() - 1) != '.') {
            name2.append('.');
        }
        return name2.toString();
    }

    static ByteBuf decompressDomainName(ByteBuf compression) {
        String domainName = DnsCodecUtil.decodeDomainName(compression);
        ByteBuf result2 = compression.alloc().buffer(domainName.length() << 1);
        DnsCodecUtil.encodeDomainName(domainName, result2);
        return result2;
    }
}

