/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.http.client.fluent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hudi.org.apache.http.Consts;
import org.apache.hudi.org.apache.http.Header;
import org.apache.hudi.org.apache.http.HttpEntity;
import org.apache.hudi.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.hudi.org.apache.http.HttpHost;
import org.apache.hudi.org.apache.http.HttpResponse;
import org.apache.hudi.org.apache.http.HttpVersion;
import org.apache.hudi.org.apache.http.NameValuePair;
import org.apache.hudi.org.apache.http.client.ClientProtocolException;
import org.apache.hudi.org.apache.http.client.HttpClient;
import org.apache.hudi.org.apache.http.client.config.RequestConfig;
import org.apache.hudi.org.apache.http.client.fluent.Executor;
import org.apache.hudi.org.apache.http.client.fluent.InternalByteArrayEntity;
import org.apache.hudi.org.apache.http.client.fluent.InternalEntityEnclosingHttpRequest;
import org.apache.hudi.org.apache.http.client.fluent.InternalFileEntity;
import org.apache.hudi.org.apache.http.client.fluent.InternalHttpRequest;
import org.apache.hudi.org.apache.http.client.fluent.InternalInputStreamEntity;
import org.apache.hudi.org.apache.http.client.fluent.Response;
import org.apache.hudi.org.apache.http.client.methods.Configurable;
import org.apache.hudi.org.apache.http.client.methods.HttpUriRequest;
import org.apache.hudi.org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hudi.org.apache.http.entity.ContentType;
import org.apache.hudi.org.apache.http.protocol.HttpContext;

public class Request {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DATE_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    private final InternalHttpRequest request;
    private Boolean useExpectContinue;
    private Integer socketTmeout;
    private Integer connectTimeout;
    private HttpHost proxy;
    private SimpleDateFormat dateFormatter;

    public static Request Get(URI uri2) {
        return new Request(new InternalHttpRequest("GET", uri2));
    }

    public static Request Get(String uri2) {
        return new Request(new InternalHttpRequest("GET", URI.create(uri2)));
    }

    public static Request Head(URI uri2) {
        return new Request(new InternalHttpRequest("HEAD", uri2));
    }

    public static Request Head(String uri2) {
        return new Request(new InternalHttpRequest("HEAD", URI.create(uri2)));
    }

    public static Request Post(URI uri2) {
        return new Request(new InternalEntityEnclosingHttpRequest("POST", uri2));
    }

    public static Request Post(String uri2) {
        return new Request(new InternalEntityEnclosingHttpRequest("POST", URI.create(uri2)));
    }

    public static Request Patch(URI uri2) {
        return new Request(new InternalEntityEnclosingHttpRequest("PATCH", uri2));
    }

    public static Request Patch(String uri2) {
        return new Request(new InternalEntityEnclosingHttpRequest("PATCH", URI.create(uri2)));
    }

    public static Request Put(URI uri2) {
        return new Request(new InternalEntityEnclosingHttpRequest("PUT", uri2));
    }

    public static Request Put(String uri2) {
        return new Request(new InternalEntityEnclosingHttpRequest("PUT", URI.create(uri2)));
    }

    public static Request Trace(URI uri2) {
        return new Request(new InternalHttpRequest("TRACE", uri2));
    }

    public static Request Trace(String uri2) {
        return new Request(new InternalHttpRequest("TRACE", URI.create(uri2)));
    }

    public static Request Delete(URI uri2) {
        return new Request(new InternalHttpRequest("DELETE", uri2));
    }

    public static Request Delete(String uri2) {
        return new Request(new InternalHttpRequest("DELETE", URI.create(uri2)));
    }

    public static Request Options(URI uri2) {
        return new Request(new InternalHttpRequest("OPTIONS", uri2));
    }

    public static Request Options(String uri2) {
        return new Request(new InternalHttpRequest("OPTIONS", URI.create(uri2)));
    }

    Request(InternalHttpRequest request) {
        this.request = request;
    }

    HttpResponse internalExecute(HttpClient client, HttpContext localContext) throws ClientProtocolException, IOException {
        RequestConfig.Builder builder = client instanceof Configurable ? RequestConfig.copy(((Configurable)((Object)client)).getConfig()) : RequestConfig.custom();
        if (this.useExpectContinue != null) {
            builder.setExpectContinueEnabled(this.useExpectContinue);
        }
        if (this.socketTmeout != null) {
            builder.setSocketTimeout(this.socketTmeout);
        }
        if (this.connectTimeout != null) {
            builder.setConnectTimeout(this.connectTimeout);
        }
        if (this.proxy != null) {
            builder.setProxy(this.proxy);
        }
        RequestConfig config = builder.build();
        this.request.setConfig(config);
        return client.execute((HttpUriRequest)this.request, localContext);
    }

    public Response execute() throws ClientProtocolException, IOException {
        return new Response(this.internalExecute(Executor.CLIENT, null));
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public Request addHeader(Header header) {
        this.request.addHeader(header);
        return this;
    }

    public Request setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public Request addHeader(String name2, String value) {
        this.request.addHeader(name2, value);
        return this;
    }

    public Request setHeader(String name2, String value) {
        this.request.setHeader(name2, value);
        return this;
    }

    public Request removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public Request removeHeaders(String name2) {
        this.request.removeHeaders(name2);
        return this;
    }

    public Request setHeaders(Header ... headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public Request setCacheControl(String cacheControl) {
        this.request.setHeader("Cache-Control", cacheControl);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
            this.dateFormatter.setTimeZone(TIME_ZONE);
        }
        return this.dateFormatter;
    }

    public Request setDate(Date date) {
        this.request.setHeader("Date", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfModifiedSince(Date date) {
        this.request.setHeader("If-Modified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfUnmodifiedSince(Date date) {
        this.request.setHeader("If-Unmodified-Since", this.getDateFormat().format(date));
        return this;
    }

    @Deprecated
    public Request config(String param, Object object) {
        return this;
    }

    @Deprecated
    public Request removeConfig(String param) {
        return this;
    }

    public Request version(HttpVersion version) {
        this.request.setProtocolVersion(version);
        return this;
    }

    @Deprecated
    public Request elementCharset(String charset) {
        return this;
    }

    public Request useExpectContinue() {
        this.useExpectContinue = Boolean.TRUE;
        return this;
    }

    public Request userAgent(String agent) {
        this.request.setHeader("User-Agent", agent);
        return this;
    }

    public Request socketTimeout(int timeout) {
        this.socketTmeout = timeout;
        return this;
    }

    public Request connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @Deprecated
    public Request staleConnectionCheck(boolean b) {
        return this;
    }

    public Request viaProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public Request viaProxy(String proxy) {
        this.proxy = HttpHost.create(proxy);
        return this;
    }

    public Request body(HttpEntity entity) {
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException(this.request.getMethod() + " request cannot enclose an entity");
        }
        ((HttpEntityEnclosingRequest)((Object)this.request)).setEntity(entity);
        return this;
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams2, Charset charset) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : formParams2) {
            paramList.add(nameValuePair);
        }
        ContentType contentType = ContentType.create("application/x-www-form-urlencoded", charset);
        String string = URLEncodedUtils.format(paramList, charset);
        return this.bodyString(string, contentType);
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams2) {
        return this.bodyForm(formParams2, Consts.ISO_8859_1);
    }

    public Request bodyForm(NameValuePair ... formParams2) {
        return this.bodyForm(Arrays.asList(formParams2), Consts.ISO_8859_1);
    }

    public Request bodyString(String s, ContentType contentType) {
        Charset charset = contentType != null ? contentType.getCharset() : null;
        byte[] raw = charset != null ? s.getBytes(charset) : s.getBytes();
        return this.body(new InternalByteArrayEntity(raw, contentType));
    }

    public Request bodyFile(File file, ContentType contentType) {
        return this.body(new InternalFileEntity(file, contentType));
    }

    public Request bodyByteArray(byte[] b) {
        return this.body(new InternalByteArrayEntity(b));
    }

    public Request bodyByteArray(byte[] b, ContentType contentType) {
        return this.body(new InternalByteArrayEntity(b, contentType));
    }

    public Request bodyByteArray(byte[] b, int off, int len) {
        return this.body(new InternalByteArrayEntity(b, off, len));
    }

    public Request bodyByteArray(byte[] b, int off, int len, ContentType contentType) {
        return this.body(new InternalByteArrayEntity(b, off, len, contentType));
    }

    public Request bodyStream(InputStream inStream) {
        return this.body(new InternalInputStreamEntity(inStream, -1L, null));
    }

    public Request bodyStream(InputStream inStream, ContentType contentType) {
        return this.body(new InternalInputStreamEntity(inStream, -1L, contentType));
    }

    public String toString() {
        return this.request.getRequestLine().toString();
    }
}

