/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.http.impl.conn;

import org.apache.hudi.org.apache.http.HttpHost;
import org.apache.hudi.org.apache.http.annotation.Contract;
import org.apache.hudi.org.apache.http.annotation.ThreadingBehavior;
import org.apache.hudi.org.apache.http.conn.SchemePortResolver;
import org.apache.hudi.org.apache.http.conn.UnsupportedSchemeException;
import org.apache.hudi.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host2) throws UnsupportedSchemeException {
        Args.notNull(host2, "HTTP host");
        int port = host2.getPort();
        if (port > 0) {
            return port;
        }
        String name2 = host2.getSchemeName();
        if (name2.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name2.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name2 + " protocol is not supported");
    }
}

