/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.spark.sql.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.hudi.org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
public final class SchemaConverters$ {
    public static SchemaConverters$ MODULE$;
    private Schema nullSchema;
    private final String unionFieldMemberPrefix;
    private volatile boolean bitmap$0;

    static {
        new SchemaConverters$();
    }

    private Schema nullSchema$lzycompute() {
        SchemaConverters$ schemaConverters$ = this;
        synchronized (schemaConverters$) {
            if (!this.bitmap$0) {
                this.nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                this.bitmap$0 = true;
            }
        }
        return this.nullSchema;
    }

    private Schema nullSchema() {
        if (!this.bitmap$0) {
            return this.nullSchema$lzycompute();
        }
        return this.nullSchema;
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema) {
        return this.toSqlTypeHelper(avroSchema, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    private String unionFieldMemberPrefix() {
        return this.unionFieldMemberPrefix;
    }

    private SchemaConverters.SchemaType toSqlTypeHelper(Schema avroSchema, Set<String> existingRecordNames) {
        Schema.Type type2;
        block23: {
            Some some;
            Seq seq;
            while (true) {
                if (Schema.Type.INT.equals(type2 = avroSchema.getType())) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Date) {
                        return new SchemaConverters.SchemaType((DataType)DateType$.MODULE$, false);
                    }
                    return new SchemaConverters.SchemaType((DataType)IntegerType$.MODULE$, false);
                }
                if (Schema.Type.STRING.equals(type2)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.BOOLEAN.equals(type2)) {
                    return new SchemaConverters.SchemaType((DataType)BooleanType$.MODULE$, false);
                }
                if (Schema.Type.BYTES.equals(type2) ? true : Schema.Type.FIXED.equals(type2)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(decimal.getPrecision(), decimal.getScale()), false);
                    }
                    return new SchemaConverters.SchemaType((DataType)BinaryType$.MODULE$, false);
                }
                if (Schema.Type.DOUBLE.equals(type2)) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
                if (Schema.Type.FLOAT.equals(type2)) {
                    return new SchemaConverters.SchemaType((DataType)FloatType$.MODULE$, false);
                }
                if (Schema.Type.LONG.equals(type2)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.TimestampMillis ? true : logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampType$.MODULE$, false);
                    }
                    return new SchemaConverters.SchemaType((DataType)LongType$.MODULE$, false);
                }
                if (Schema.Type.ENUM.equals(type2)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.NULL.equals(type2)) {
                    return new SchemaConverters.SchemaType((DataType)NullType$.MODULE$, true);
                }
                if (Schema.Type.RECORD.equals(type2)) {
                    if (existingRecordNames.contains((Object)avroSchema.getFullName())) {
                        throw new IncompatibleSchemaException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("\n               |Found recursive reference in Avro schema, which can not be processed by Spark:\n               |").append(avroSchema.toString(true)).append("\n          ").toString())).stripMargin(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    Set newRecordNames = (Set)existingRecordNames.$plus((Object)avroSchema.getFullName());
                    Buffer fields2 = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> {
                        SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(f.schema(), (Set<String>)newRecordNames);
                        return new StructField(f.name(), schemaType.dataType(), schemaType.nullable(), StructField$.MODULE$.apply$default$4());
                    }, Buffer$.MODULE$.canBuildFrom());
                    return new SchemaConverters.SchemaType((DataType)StructType$.MODULE$.apply(fields2.toSeq()), false);
                }
                if (Schema.Type.ARRAY.equals(type2)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getElementType(), existingRecordNames);
                    return new SchemaConverters.SchemaType((DataType)new ArrayType(schemaType.dataType(), schemaType.nullable()), false);
                }
                if (Schema.Type.MAP.equals(type2)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getValueType(), existingRecordNames);
                    return new SchemaConverters.SchemaType((DataType)new MapType((DataType)StringType$.MODULE$, schemaType.dataType(), schemaType.nullable()), false);
                }
                if (!Schema.Type.UNION.equals(type2)) break block23;
                if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$2(x$1)))) {
                    Buffer remainingUnionTypes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$3(x$2)));
                    if (remainingUnionTypes.size() == 1) {
                        SchemaConverters.SchemaType qual$1 = this.toSqlTypeHelper((Schema)remainingUnionTypes.head(), existingRecordNames);
                        boolean x$12 = true;
                        DataType x$22 = qual$1.copy$default$1();
                        return qual$1.copy(x$22, x$12);
                    }
                    SchemaConverters.SchemaType qual$2 = this.toSqlTypeHelper(Schema.createUnion((List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(remainingUnionTypes).asJava())), existingRecordNames);
                    boolean x$32 = true;
                    DataType x$4 = qual$2.copy$default$1();
                    return qual$2.copy(x$4, x$32);
                }
                seq = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getType(), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0) break;
                avroSchema = (Schema)avroSchema.getTypes().get(0);
            }
            Some some3 = Seq$.MODULE$.unapplySeq(seq);
            if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
                Schema.Type t1 = (Schema.Type)((SeqLike)some3.get()).apply(0);
                Schema.Type t2 = (Schema.Type)((SeqLike)some3.get()).apply(1);
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                GenTraversable genTraversable2 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                if (!(genTraversable != null ? !genTraversable.equals(genTraversable2) : genTraversable2 != null)) {
                    return new SchemaConverters.SchemaType((DataType)LongType$.MODULE$, false);
                }
            }
            if (!(some = Seq$.MODULE$.unapplySeq(seq)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                Schema.Type t1 = (Schema.Type)((SeqLike)some.get()).apply(0);
                Schema.Type t2 = (Schema.Type)((SeqLike)some.get()).apply(1);
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2}));
                GenTraversable genTraversable3 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                if (!(genTraversable != null ? !genTraversable.equals(genTraversable3) : genTraversable3 != null)) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
            }
            Buffer fields3 = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getTypes()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Schema s = (Schema)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(s, existingRecordNames);
                    return new StructField(new StringBuilder(0).append(MODULE$.unionFieldMemberPrefix()).append(i).toString(), schemaType.dataType(), true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple2);
            }, Buffer$.MODULE$.canBuildFrom());
            return new SchemaConverters.SchemaType((DataType)StructType$.MODULE$.apply(fields3.toSeq()), false);
        }
        throw new IncompatibleSchemaException(new StringBuilder(17).append("Unsupported type ").append(type2).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    /*
     * Unable to fully structure code
     */
    public Schema toAvroType(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block12: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block11: {
                                                            builder = SchemaBuilder.builder();
                                                            var11_6 = catalystType;
                                                            if (!BooleanType$.MODULE$.equals(var11_6)) break block11;
                                                            v0 = (Schema)builder.booleanType();
                                                            break block12;
                                                        }
                                                        if (!(ByteType$.MODULE$.equals(var11_6) != false ? true : (ShortType$.MODULE$.equals(var11_6) != false ? true : IntegerType$.MODULE$.equals(var11_6) != false))) break block13;
                                                        v0 = (Schema)builder.intType();
                                                        break block12;
                                                    }
                                                    if (!LongType$.MODULE$.equals(var11_6)) break block14;
                                                    v0 = (Schema)builder.longType();
                                                    break block12;
                                                }
                                                if (!DateType$.MODULE$.equals(var11_6)) break block15;
                                                v0 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                                break block12;
                                            }
                                            if (!TimestampType$.MODULE$.equals(var11_6)) break block16;
                                            v0 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                            break block12;
                                        }
                                        if (!FloatType$.MODULE$.equals(var11_6)) break block17;
                                        v0 = (Schema)builder.floatType();
                                        break block12;
                                    }
                                    if (!DoubleType$.MODULE$.equals(var11_6)) break block18;
                                    v0 = (Schema)builder.doubleType();
                                    break block12;
                                }
                                if (!(StringType$.MODULE$.equals(var11_6) != false ? true : (var11_6 instanceof CharType != false ? true : var11_6 instanceof VarcharType != false))) break block19;
                                v0 = (Schema)builder.stringType();
                                break block12;
                            }
                            if (!NullType$.MODULE$.equals(var11_6)) break block20;
                            v0 = (Schema)builder.nullType();
                            break block12;
                        }
                        if (!(var11_6 instanceof DecimalType)) break block21;
                        var12_7 = (DecimalType)var11_6;
                        avroType = LogicalTypes.decimal((int)var12_7.precision(), (int)var12_7.scale());
                        fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var12_7.precision()];
                        var16_10 = nameSpace;
                        name = "".equals(var16_10) != false ? new StringBuilder(6).append(recordName).append(".fixed").toString() : new StringBuilder(7).append(nameSpace).append(".").append(recordName).append(".fixed").toString();
                        v0 = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
                        break block12;
                    }
                    if (!BinaryType$.MODULE$.equals(var11_6)) break block22;
                    v0 = (Schema)builder.bytesType();
                    break block12;
                }
                if (!(var11_6 instanceof ArrayType)) break block23;
                var17_12 = (ArrayType)var11_6;
                et = var17_12.elementType();
                containsNull = var17_12.containsNull();
                v0 = (Schema)builder.array().items(this.toAvroType(et, containsNull, recordName, nameSpace));
                break block12;
            }
            if (!(var11_6 instanceof MapType)) ** GOTO lbl-1000
            var20_15 = (MapType)var11_6;
            var21_16 = var20_15.keyType();
            vt = var20_15.valueType();
            valueContainsNull = var20_15.valueContainsNull();
            if (StringType$.MODULE$.equals(var21_16)) {
                v0 = (Schema)builder.map().values(this.toAvroType(vt, valueContainsNull, recordName, nameSpace));
            } else if (var11_6 instanceof StructType) {
                var24_19 = (StructType)var11_6;
                v1 = nameSpace;
                var26_20 = "";
                v2 = (v1 == null ? var26_20 != null : v1.equals(var26_20) == false) ? new StringBuilder(1).append(nameSpace).append(".").append(recordName).toString() : (childNameSpace = recordName);
                if (this.canBeUnion(var24_19)) {
                    nonNullUnionFieldTypes = (Seq)var24_19.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toAvroType$1(java.lang.String org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/avro/Schema;)((String)childNameSpace), Seq$.MODULE$.canBuildFrom());
                    if (nullable) {
                        var29_23 = this.nullSchema();
                        v3 = (Seq)nonNullUnionFieldTypes.$plus$colon((Object)var29_23, Seq$.MODULE$.canBuildFrom());
                    } else {
                        v3 = nonNullUnionFieldTypes;
                    }
                    unionFieldTypes = v3;
                    v0 = Schema.createUnion((Schema[])((Schema[])unionFieldTypes.toArray(ClassTag$.MODULE$.apply(Schema.class))));
                } else {
                    fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                    var24_19.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toAvroType$2(java.lang.String org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, (SchemaBuilder.FieldAssembler)fieldsAssembler));
                    v0 = (Schema)fieldsAssembler.endRecord();
                }
            } else {
                throw new IncompatibleSchemaException(new StringBuilder(17).append("Unexpected type ").append(var11_6).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = v0;
        if (nullable) {
            v4 = catalystType;
            var31_27 = NullType$.MODULE$;
            if (v4 == null ? var31_27 != null : v4.equals(var31_27) == false) {
                v5 = schema.getType();
                var32_28 = Schema.Type.UNION;
                if (v5 == null ? var32_28 != null : v5.equals(var32_28) == false) {
                    return Schema.createUnion((Schema[])new Schema[]{schema, this.nullSchema()});
                }
            }
        }
        return schema;
    }

    public boolean toAvroType$default$2() {
        return false;
    }

    public String toAvroType$default$3() {
        return "topLevelRecord";
    }

    public String toAvroType$default$4() {
        return "";
    }

    private boolean canBeUnion(StructType st) {
        return st.fields().length > 0 && st.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$canBeUnion$1(f)));
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$2(Schema x$1) {
        Schema.Type type2 = x$1.getType();
        Schema.Type type3 = Schema.Type.NULL;
        return !(type2 != null ? !type2.equals(type3) : type3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$3(Schema x$2) {
        Schema.Type type2 = x$2.getType();
        Schema.Type type3 = Schema.Type.NULL;
        return !(type2 != null ? !type2.equals(type3) : type3 != null);
    }

    public static final /* synthetic */ Schema $anonfun$toAvroType$1(String childNameSpace$1, StructField f) {
        return MODULE$.toAvroType(f.dataType(), false, f.name(), childNameSpace$1);
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$toAvroType$2(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.toAvroType(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        return fieldsAssembler$1.name(f.name()).type(fieldAvroType).noDefault();
    }

    public static final /* synthetic */ boolean $anonfun$canBeUnion$1(StructField f) {
        return f.name().matches(new StringBuilder(3).append(MODULE$.unionFieldMemberPrefix()).append("\\d+").toString()) && f.nullable();
    }

    private SchemaConverters$() {
        MODULE$ = this;
        this.unionFieldMemberPrefix = "member";
    }
}

