/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.client;

import java.util.Objects;
import org.apache.hudi.org.eclipse.jetty.util.HostPort;
import org.apache.hudi.org.eclipse.jetty.util.URIUtil;

public class Origin {
    private final String scheme;
    private final Address address;
    private final Object tag;

    public Origin(String scheme2, String host2, int port) {
        this(scheme2, host2, port, null);
    }

    public Origin(String scheme2, String host2, int port, Object tag) {
        this(scheme2, new Address(host2, port), tag);
    }

    public Origin(String scheme2, Address address) {
        this(scheme2, address, null);
    }

    public Origin(String scheme2, Address address, Object tag) {
        this.scheme = Objects.requireNonNull(scheme2);
        this.address = address;
        this.tag = tag;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Address getAddress() {
        return this.address;
    }

    public Object getTag() {
        return this.tag;
    }

    public String asString() {
        StringBuilder result2 = new StringBuilder();
        URIUtil.appendSchemeHostPort(result2, this.scheme, this.address.host, this.address.port);
        return result2.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Origin that = (Origin)obj;
        return this.scheme.equals(that.scheme) && this.address.equals(that.address) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.address, this.tag);
    }

    public String toString() {
        String result2 = this.asString();
        if (this.tag != null) {
            result2 = result2 + "[tag=" + this.tag + "]";
        }
        return result2;
    }

    public static class Address {
        private final String host;
        private final int port;

        public Address(String host2, int port) {
            this.host = HostPort.normalizeHost(Objects.requireNonNull(host2));
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Address that = (Address)obj;
            return this.host.equals(that.host) && this.port == that.port;
        }

        public int hashCode() {
            int result2 = this.host.hashCode();
            result2 = 31 * result2 + this.port;
            return result2;
        }

        public String asString() {
            return String.format("%s:%d", this.host, this.port);
        }

        public String toString() {
            return this.asString();
        }
    }
}

