/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import org.apache.hudi.org.eclipse.jetty.util.annotation.ManagedOperation;
import org.apache.hudi.org.eclipse.jetty.util.log.Log;
import org.apache.hudi.org.eclipse.jetty.util.log.Logger;
import org.apache.hudi.org.eclipse.jetty.webapp.WebAppClassLoader;

@ManagedObject
public class CachingWebAppClassLoader
extends WebAppClassLoader {
    private static final Logger LOG = Log.getLogger(CachingWebAppClassLoader.class);
    private final Set<String> _notFound = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<String, URL> _cache = new ConcurrentHashMap();

    public CachingWebAppClassLoader(ClassLoader parent, WebAppClassLoader.Context context) throws IOException {
        super(parent, context);
    }

    public CachingWebAppClassLoader(WebAppClassLoader.Context context) throws IOException {
        super(context);
    }

    @Override
    public URL getResource(String name2) {
        if (this._notFound.contains(name2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not found cache hit resource {}", name2);
            }
            return null;
        }
        URL url2 = this._cache.get(name2);
        if (url2 == null) {
            url2 = super.getResource(name2);
            if (url2 == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caching not found resource {}", name2);
                }
                this._notFound.add(name2);
            } else {
                this._cache.putIfAbsent(name2, url2);
            }
        }
        return url2;
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        if (this._notFound.contains(name2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not found cache hit resource {}", name2);
            }
            throw new ClassNotFoundException(name2 + ": in notfound cache");
        }
        try {
            return super.loadClass(name2);
        }
        catch (ClassNotFoundException nfe) {
            if (this._notFound.add(name2) && LOG.isDebugEnabled()) {
                LOG.debug("Caching not found {}", name2);
                LOG.debug(nfe);
            }
            throw nfe;
        }
    }

    @ManagedOperation
    public void clearCache() {
        this._cache.clear();
        this._notFound.clear();
    }

    @Override
    public String toString() {
        return "Caching[" + super.toString() + "]";
    }
}

