/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.hudi.org.eclipse.jetty.util.log.Log;
import org.apache.hudi.org.eclipse.jetty.util.log.Logger;
import org.apache.hudi.org.eclipse.jetty.util.resource.EmptyResource;
import org.apache.hudi.org.eclipse.jetty.util.resource.Resource;
import org.apache.hudi.org.eclipse.jetty.webapp.AbstractConfiguration;
import org.apache.hudi.org.eclipse.jetty.webapp.WebAppContext;

public class MetaInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(MetaInfConfiguration.class);
    public static final String USE_CONTAINER_METAINF_CACHE = "org.apache.hudi.org.eclipse.jetty.metainf.useCache";
    public static final boolean DEFAULT_USE_CONTAINER_METAINF_CACHE = true;
    public static final String CACHED_CONTAINER_TLDS = "org.apache.hudi.org.eclipse.jetty.tlds.cache";
    public static final String CACHED_CONTAINER_FRAGMENTS = "org.apache.hudi.org.eclipse.jetty.webFragments.cache";
    public static final String CACHED_CONTAINER_RESOURCES = "org.apache.hudi.org.eclipse.jetty.resources.cache";
    public static final String METAINF_TLDS = "org.apache.hudi.org.eclipse.jetty.tlds";
    public static final String METAINF_FRAGMENTS = "org.apache.hudi.org.eclipse.jetty.webFragments";
    public static final String METAINF_RESOURCES = "org.apache.hudi.org.eclipse.jetty.resources";
    public static final List<String> __allScanTypes = Arrays.asList("org.apache.hudi.org.eclipse.jetty.tlds", "org.apache.hudi.org.eclipse.jetty.resources", "org.apache.hudi.org.eclipse.jetty.webFragments");

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        Boolean attr;
        boolean useContainerCache = true;
        if (context.getServer() != null && (attr = (Boolean)context.getServer().getAttribute(USE_CONTAINER_METAINF_CACHE)) != null) {
            useContainerCache = attr;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} = {}", USE_CONTAINER_METAINF_CACHE, useContainerCache);
        }
        if (context.getAttribute(METAINF_TLDS) == null) {
            context.setAttribute(METAINF_TLDS, new HashSet());
        }
        if (context.getAttribute(METAINF_RESOURCES) == null) {
            context.setAttribute(METAINF_RESOURCES, new HashSet());
        }
        if (context.getAttribute(METAINF_FRAGMENTS) == null) {
            context.setAttribute(METAINF_FRAGMENTS, new HashMap());
        }
        this.scanJars(context, context.getMetaData().getContainerResources(), useContainerCache, __allScanTypes);
        ArrayList<String> scanTypes = new ArrayList<String>(__allScanTypes);
        if (context.getMetaData().isMetaDataComplete() || context.getServletContext().getEffectiveMajorVersion() < 3 && !context.isConfigurationDiscovered()) {
            scanTypes.remove(METAINF_FRAGMENTS);
        }
        this.scanJars(context, context.getMetaData().getWebInfJars(), false, scanTypes);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches) throws Exception {
        this.scanJars(context, jars, useCaches, __allScanTypes);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches, List<String> scanTypes) throws Exception {
        ConcurrentHashMap<Resource, Resource> metaInfResourceCache = null;
        ConcurrentHashMap<Resource, Resource> metaInfFragmentCache = null;
        ConcurrentHashMap<Resource, Collection<URL>> metaInfTldCache = null;
        if (useCaches) {
            metaInfResourceCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_RESOURCES);
            if (metaInfResourceCache == null) {
                metaInfResourceCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_RESOURCES, metaInfResourceCache);
            }
            if ((metaInfFragmentCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_FRAGMENTS)) == null) {
                metaInfFragmentCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_FRAGMENTS, metaInfFragmentCache);
            }
            if ((metaInfTldCache = (ConcurrentHashMap<Resource, Collection<URL>>)context.getServer().getAttribute(CACHED_CONTAINER_TLDS)) == null) {
                metaInfTldCache = new ConcurrentHashMap<Resource, Collection<URL>>();
                context.getServer().setAttribute(CACHED_CONTAINER_TLDS, metaInfTldCache);
            }
        }
        if (jars != null) {
            for (Resource r : jars) {
                if (scanTypes.contains(METAINF_RESOURCES)) {
                    this.scanForResources(context, r, metaInfResourceCache);
                }
                if (scanTypes.contains(METAINF_FRAGMENTS)) {
                    this.scanForFragment(context, r, metaInfFragmentCache);
                }
                if (!scanTypes.contains(METAINF_TLDS)) continue;
                this.scanForTlds(context, r, metaInfTldCache);
            }
        }
    }

    public void scanForResources(WebAppContext context, Resource target, ConcurrentHashMap<Resource, Resource> cache) throws Exception {
        HashSet<Resource> dirs;
        Resource resourcesDir = null;
        if (cache != null && cache.containsKey(target)) {
            resourcesDir = cache.get(target);
            if (resourcesDir == EmptyResource.INSTANCE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(target + " cached as containing no META-INF/resources", new Object[0]);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(target + " META-INF/resources found in cache ", new Object[0]);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(target + " META-INF/resources checked", new Object[0]);
            }
            if (target.isDirectory()) {
                resourcesDir = target.addPath("/META-INF/resources");
            } else {
                URI uri2 = target.getURI();
                resourcesDir = Resource.newResource(this.uriJarPrefix(uri2, "!/META-INF/resources"));
            }
            if (!resourcesDir.exists() || !resourcesDir.isDirectory()) {
                resourcesDir.close();
                resourcesDir = EmptyResource.INSTANCE;
            }
            if (cache != null) {
                Resource old = cache.putIfAbsent(target, resourcesDir);
                if (old != null) {
                    resourcesDir = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(target + " META-INF/resources cache updated", new Object[0]);
                }
            }
            if (resourcesDir == EmptyResource.INSTANCE) {
                return;
            }
        }
        if ((dirs = (HashSet<Resource>)context.getAttribute(METAINF_RESOURCES)) == null) {
            dirs = new HashSet<Resource>();
            context.setAttribute(METAINF_RESOURCES, dirs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(resourcesDir + " added to context", new Object[0]);
        }
        dirs.add(resourcesDir);
    }

    public void scanForFragment(WebAppContext context, Resource jar, ConcurrentHashMap<Resource, Resource> cache) throws Exception {
        HashMap<Resource, Resource> fragments2;
        Resource webFrag = null;
        if (cache != null && cache.containsKey(jar)) {
            webFrag = cache.get(jar);
            if (webFrag == EmptyResource.INSTANCE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " cached as containing no META-INF/web-fragment.xml", new Object[0]);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(jar + " META-INF/web-fragment.xml found in cache ", new Object[0]);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(jar + " META-INF/web-fragment.xml checked", new Object[0]);
            }
            if (jar.isDirectory()) {
                webFrag = Resource.newResource(new File(jar.getFile(), "/META-INF/web-fragment.xml"));
            } else {
                URI uri2 = jar.getURI();
                webFrag = Resource.newResource(this.uriJarPrefix(uri2, "!/META-INF/web-fragment.xml"));
            }
            if (!webFrag.exists() || webFrag.isDirectory()) {
                webFrag.close();
                webFrag = EmptyResource.INSTANCE;
            }
            if (cache != null) {
                Resource old = cache.putIfAbsent(jar, webFrag);
                if (old != null) {
                    webFrag = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " META-INF/web-fragment.xml cache updated", new Object[0]);
                }
            }
            if (webFrag == EmptyResource.INSTANCE) {
                return;
            }
        }
        if ((fragments2 = (HashMap<Resource, Resource>)context.getAttribute(METAINF_FRAGMENTS)) == null) {
            fragments2 = new HashMap<Resource, Resource>();
            context.setAttribute(METAINF_FRAGMENTS, fragments2);
        }
        fragments2.put(jar, webFrag);
        if (LOG.isDebugEnabled()) {
            LOG.debug(webFrag + " added to context", new Object[0]);
        }
    }

    public void scanForTlds(WebAppContext context, Resource jar, ConcurrentHashMap<Resource, Collection<URL>> cache) throws Exception {
        Collection<Object> tlds = null;
        if (cache != null && cache.containsKey(jar)) {
            Collection<URL> tmp = cache.get(jar);
            if (tmp.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " cached as containing no tlds", new Object[0]);
                }
                return;
            }
            tlds = tmp;
            if (LOG.isDebugEnabled()) {
                LOG.debug(jar + " tlds found in cache ", new Object[0]);
            }
        } else {
            tlds = new HashSet<URL>();
            if (jar.isDirectory()) {
                tlds.addAll(this.getTlds(jar.getFile()));
            } else {
                URI uri2 = jar.getURI();
                tlds.addAll(this.getTlds(uri2));
            }
            if (cache != null) {
                Collection<Object> old;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(jar + " tld cache updated", new Object[0]);
                }
                if ((old = cache.putIfAbsent(jar, tlds)) != null) {
                    tlds = old;
                }
            }
            if (tlds.isEmpty()) {
                return;
            }
        }
        HashSet<Object> metaInfTlds = (HashSet<Object>)context.getAttribute(METAINF_TLDS);
        if (metaInfTlds == null) {
            metaInfTlds = new HashSet<Object>();
            context.setAttribute(METAINF_TLDS, metaInfTlds);
        }
        metaInfTlds.addAll(tlds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tlds added to context", new Object[0]);
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(METAINF_RESOURCES, null);
        context.setAttribute(METAINF_FRAGMENTS, null);
        context.setAttribute(METAINF_TLDS, null);
    }

    public Collection<URL> getTlds(File dir) throws IOException {
        if (dir == null || !dir.isDirectory()) {
            return Collections.emptySet();
        }
        HashSet<URL> tlds = new HashSet<URL>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    tlds.addAll(this.getTlds(f));
                    continue;
                }
                String name2 = f.getCanonicalPath();
                if (!name2.contains("META-INF") || !name2.endsWith(".tld")) continue;
                tlds.add(f.toURI().toURL());
            }
        }
        return tlds;
    }

    public Collection<URL> getTlds(URI uri2) throws IOException {
        HashSet<URL> tlds = new HashSet<URL>();
        String jarUri = this.uriJarPrefix(uri2, "!/");
        URL url2 = new URL(jarUri);
        JarURLConnection jarConn = (JarURLConnection)url2.openConnection();
        jarConn.setUseCaches(Resource.getDefaultUseCaches());
        JarFile jarFile = jarConn.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            String name2 = e.getName();
            if (!name2.startsWith("META-INF") || !name2.endsWith(".tld")) continue;
            tlds.add(new URL(jarUri + name2));
        }
        if (!Resource.getDefaultUseCaches()) {
            jarFile.close();
        }
        return tlds;
    }

    private String uriJarPrefix(URI uri2, String suffix) {
        String uriString = uri2.toString();
        if (uriString.startsWith("jar:")) {
            return uriString + suffix;
        }
        return "jar:" + uriString + suffix;
    }
}

