/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.info;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.hudi.org.openjdk.jol.info.AbstractGraphWalker;
import org.apache.hudi.org.openjdk.jol.info.ArrayGraphPathRecord;
import org.apache.hudi.org.openjdk.jol.info.FieldGraphPathRecord;
import org.apache.hudi.org.openjdk.jol.info.GraphLayout;
import org.apache.hudi.org.openjdk.jol.info.GraphPathRecord;
import org.apache.hudi.org.openjdk.jol.info.GraphVisitor;
import org.apache.hudi.org.openjdk.jol.util.ObjectUtils;
import org.apache.hudi.org.openjdk.jol.util.SimpleIdentityHashSet;
import org.apache.hudi.org.openjdk.jol.util.SimpleStack;
import org.apache.hudi.org.openjdk.jol.vm.VM;

public class GraphWalker
extends AbstractGraphWalker {
    private final GraphVisitor[] visitors;
    private final HashMap<Class<?>, Long> sizeCache;

    public GraphWalker(GraphVisitor ... visitor2) {
        this.visitors = visitor2;
        this.sizeCache = new HashMap();
    }

    public GraphLayout walk(Object ... roots) {
        this.verifyRoots(roots);
        GraphLayout data2 = new GraphLayout(roots);
        SimpleIdentityHashSet visited = new SimpleIdentityHashSet();
        SimpleStack<GraphPathRecord> s = new SimpleStack<GraphPathRecord>();
        int rootId = 1;
        boolean single = roots.length == 1;
        for (Object root : roots) {
            String label = single ? "" : "<r" + rootId + ">";
            FieldGraphPathRecord e = new FieldGraphPathRecord(null, label, 0, root);
            if (visited.add(root)) {
                data2.addRecord(e);
                s.push(e);
            }
            ++rootId;
        }
        while (!s.isEmpty()) {
            GraphPathRecord cGpr = (GraphPathRecord)s.pop();
            Object o = cGpr.obj();
            Class<?> cl = o.getClass();
            if (cl.isArray()) {
                if (cl.getComponentType().isPrimitive()) continue;
                Object[] arr = (Object[])o;
                for (int i = 0; i < arr.length; ++i) {
                    Object e = arr[i];
                    if (e == null || !visited.add(e)) continue;
                    ArrayGraphPathRecord gpr = new ArrayGraphPathRecord(cGpr, i, cGpr.depth() + 1, e);
                    data2.addRecord(gpr);
                    for (GraphVisitor v : this.visitors) {
                        v.visit(gpr);
                    }
                    s.push(gpr);
                }
                continue;
            }
            Long knownSize = this.sizeCache.get(cl);
            if (knownSize == null) {
                knownSize = VM.current().sizeOf(o);
                this.sizeCache.put(cl, knownSize);
            }
            cGpr.setSize(knownSize);
            for (Field f : this.getAllReferenceFields(cl)) {
                Object e = ObjectUtils.value(o, f);
                if (e == null || !visited.add(e)) continue;
                FieldGraphPathRecord gpr = new FieldGraphPathRecord(cGpr, f.getName(), cGpr.depth() + 1, e);
                data2.addRecord(gpr);
                for (GraphVisitor v : this.visitors) {
                    v.visit(gpr);
                }
                s.push(gpr);
            }
        }
        return data2;
    }
}

