/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.layouters;

import java.util.List;
import java.util.TreeSet;
import org.apache.hudi.org.openjdk.jol.datamodel.DataModel;
import org.apache.hudi.org.openjdk.jol.datamodel.ModelVM;
import org.apache.hudi.org.openjdk.jol.info.ClassData;
import org.apache.hudi.org.openjdk.jol.info.ClassLayout;
import org.apache.hudi.org.openjdk.jol.info.FieldData;
import org.apache.hudi.org.openjdk.jol.info.FieldLayout;
import org.apache.hudi.org.openjdk.jol.layouters.Layouter;
import org.apache.hudi.org.openjdk.jol.util.MathUtil;
import org.apache.hudi.org.openjdk.jol.vm.VM;
import org.apache.hudi.org.openjdk.jol.vm.VirtualMachine;

public class CurrentLayouter
implements Layouter {
    static final DataModel CURRENT = new ModelVM();

    @Override
    public ClassLayout layout(ClassData data2) {
        long instanceSize;
        VirtualMachine vm = VM.current();
        if (data2.isArray()) {
            int base2 = vm.arrayBaseOffset(data2.arrayComponentType());
            int scale = vm.arrayIndexScale(data2.arrayComponentType());
            long instanceSize2 = MathUtil.align((long)base2 + data2.arrayLength() * (long)scale, vm.objectAlignment());
            TreeSet<FieldLayout> result2 = new TreeSet<FieldLayout>();
            result2.add(new FieldLayout(FieldData.create(data2.arrayClass(), "<elements>", data2.arrayComponentType()), base2, (long)scale * data2.arrayLength()));
            return ClassLayout.create(data2, result2, CURRENT, instanceSize2, false);
        }
        List<FieldData> fields2 = data2.fields();
        TreeSet<FieldLayout> result3 = new TreeSet<FieldLayout>();
        for (FieldData f : fields2) {
            result3.add(new FieldLayout(f, vm.fieldOffset(f.refField()), vm.sizeOfField(f.typeClass())));
        }
        if (result3.isEmpty()) {
            instanceSize = vm.objectHeaderSize();
        } else {
            FieldLayout f = (FieldLayout)result3.last();
            instanceSize = f.offset() + f.size();
        }
        instanceSize = MathUtil.align(instanceSize, vm.objectAlignment());
        return ClassLayout.create(data2, result3, CURRENT, instanceSize, true);
    }

    public String toString() {
        return "Current VM Layout";
    }
}

