/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.roaringbitmap;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import org.apache.hudi.org.roaringbitmap.BitmapContainer;
import org.apache.hudi.org.roaringbitmap.Container;
import org.apache.hudi.org.roaringbitmap.RoaringArray;
import org.apache.hudi.org.roaringbitmap.RoaringBitmap;

public class ParallelAggregation {
    private static final Collector<Map.Entry<Character, List<Container>>, RoaringArray, RoaringBitmap> XOR = new ContainerCollector(ParallelAggregation::xor);
    private static final OrCollector OR = new OrCollector();

    public static SortedMap<Character, List<Container>> groupByKey(RoaringBitmap ... bitmaps) {
        HashMap<Character, ArrayList<Container>> grouped = new HashMap<Character, ArrayList<Container>>();
        for (RoaringBitmap bitmap : bitmaps) {
            RoaringArray ra = bitmap.highLowContainer;
            for (int i = 0; i < ra.size; ++i) {
                Container container2 = ra.values[i];
                Character key = Character.valueOf(ra.keys[i]);
                ArrayList<Container> slice = (ArrayList<Container>)grouped.get(key);
                if (null == slice) {
                    slice = new ArrayList<Container>();
                    grouped.put(key, slice);
                }
                slice.add(container2);
            }
        }
        return new TreeMap<Character, List<Container>>(grouped);
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        SortedMap<Character, List<Container>> grouped = ParallelAggregation.groupByKey(bitmaps);
        char[] keys2 = new char[grouped.size()];
        Container[] values2 = new Container[grouped.size()];
        ArrayList<List<Container>> slices = new ArrayList<List<Container>>(grouped.size());
        int i = 0;
        for (Map.Entry<Character, List<Container>> slice : grouped.entrySet()) {
            keys2[i++] = slice.getKey().charValue();
            slices.add(slice.getValue());
        }
        IntStream.range(0, i).parallel().forEach(position -> {
            values2[position] = ParallelAggregation.or((List)slices.get(position));
        });
        return new RoaringBitmap(new RoaringArray(keys2, values2, i));
    }

    public static RoaringBitmap xor(RoaringBitmap ... bitmaps) {
        return ParallelAggregation.groupByKey(bitmaps).entrySet().parallelStream().collect(XOR);
    }

    private static Container xor(List<Container> containers) {
        Container result2 = containers.get(0).clone();
        for (int i = 1; i < containers.size(); ++i) {
            result2 = result2.ixor(containers.get(i));
        }
        return result2;
    }

    private static Container or(List<Container> containers) {
        int parallelism;
        if (containers.size() < 16) {
            Container result2 = containers.get(0).clone();
            for (int i2 = 1; i2 < containers.size(); ++i2) {
                result2 = result2.lazyIOR(containers.get(i2));
            }
            return result2.repairAfterLazy();
        }
        if (containers.size() < 512 || (parallelism = ParallelAggregation.availableParallelism()) == 1) {
            Container result3 = new BitmapContainer(new long[1024], -1);
            for (Container container2 : containers) {
                result3 = result3.lazyIOR(container2);
            }
            return ((Container)result3).repairAfterLazy();
        }
        int step = Math.floorDiv(containers.size(), parallelism);
        int mod = Math.floorMod(containers.size(), parallelism);
        return IntStream.range(0, parallelism).parallel().mapToObj(i -> containers.subList(i * step + Math.min(i, mod), (i + 1) * step + Math.min(i + 1, mod))).collect(OR);
    }

    private static int availableParallelism() {
        return ForkJoinTask.inForkJoinPool() ? ForkJoinTask.getPool().getParallelism() : ForkJoinPool.getCommonPoolParallelism();
    }

    public static class OrCollector
    implements Collector<List<Container>, Container, Container> {
        @Override
        public Supplier<Container> supplier() {
            return () -> new BitmapContainer(new long[1024], -1);
        }

        @Override
        public BiConsumer<Container, List<Container>> accumulator() {
            return (l, r) -> l.lazyIOR(ParallelAggregation.or(r));
        }

        @Override
        public BinaryOperator<Container> combiner() {
            return Container::lazyIOR;
        }

        @Override
        public Function<Container, Container> finisher() {
            return Container::repairAfterLazy;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    public static class ContainerCollector
    implements Collector<Map.Entry<Character, List<Container>>, RoaringArray, RoaringBitmap> {
        private final Function<List<Container>, Container> reducer;

        ContainerCollector(Function<List<Container>, Container> reducer) {
            this.reducer = reducer;
        }

        @Override
        public Supplier<RoaringArray> supplier() {
            return RoaringArray::new;
        }

        @Override
        public BiConsumer<RoaringArray, Map.Entry<Character, List<Container>>> accumulator() {
            return (l, r) -> {
                assert (l.size == 0 || l.keys[l.size - 1] < ((Character)r.getKey()).charValue());
                Container container2 = this.reducer.apply((List)r.getValue());
                if (!container2.isEmpty()) {
                    l.append(((Character)r.getKey()).charValue(), container2);
                }
            };
        }

        @Override
        public BinaryOperator<RoaringArray> combiner() {
            return (l, r) -> {
                assert (l.size == 0 || r.size == 0 || l.keys[l.size - 1] - r.keys[0] < 0);
                l.append((RoaringArray)r);
                return l;
            };
        }

        @Override
        public Function<RoaringArray, RoaringBitmap> finisher() {
            return RoaringBitmap::new;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.noneOf(Collector.Characteristics.class);
        }
    }
}

