/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.roaringbitmap;

import org.apache.hudi.org.roaringbitmap.ArrayContainer;
import org.apache.hudi.org.roaringbitmap.BitmapContainer;
import org.apache.hudi.org.roaringbitmap.CharIterator;
import org.apache.hudi.org.roaringbitmap.Container;
import org.apache.hudi.org.roaringbitmap.IntIterator;
import org.apache.hudi.org.roaringbitmap.ReverseArrayContainerCharIterator;
import org.apache.hudi.org.roaringbitmap.ReverseBitmapContainerCharIterator;
import org.apache.hudi.org.roaringbitmap.ReverseRunContainerCharIterator;
import org.apache.hudi.org.roaringbitmap.RoaringBitmap;
import org.apache.hudi.org.roaringbitmap.RunContainer;

public class ReverseIntIteratorFlyweight
implements IntIterator {
    private int hs;
    private CharIterator iter;
    private ReverseArrayContainerCharIterator arrIter = new ReverseArrayContainerCharIterator();
    private ReverseBitmapContainerCharIterator bitmapIter = new ReverseBitmapContainerCharIterator();
    private ReverseRunContainerCharIterator runIter = new ReverseRunContainerCharIterator();
    private short pos;
    private RoaringBitmap roaringBitmap = null;

    public ReverseIntIteratorFlyweight() {
    }

    public ReverseIntIteratorFlyweight(RoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public IntIterator clone() {
        try {
            ReverseIntIteratorFlyweight x = (ReverseIntIteratorFlyweight)super.clone();
            if (this.iter != null) {
                x.iter = this.iter.clone();
            }
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            this.pos = (short)(this.pos - 1);
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos >= 0) {
            Container container2 = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container2 instanceof BitmapContainer) {
                this.bitmapIter.wrap(((BitmapContainer)container2).bitmap);
                this.iter = this.bitmapIter;
            } else if (container2 instanceof ArrayContainer) {
                this.arrIter.wrap((ArrayContainer)container2);
                this.iter = this.arrIter;
            } else {
                this.runIter.wrap((RunContainer)container2);
                this.iter = this.runIter;
            }
            this.hs = this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos) << 16;
        }
    }

    public void wrap(RoaringBitmap r) {
        this.roaringBitmap = r;
        this.hs = 0;
        this.pos = (short)(this.roaringBitmap.highLowContainer.size() - 1);
        this.nextContainer();
    }
}

