/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.roaringbitmap.longlong;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hudi.org.roaringbitmap.BitmapDataProvider;
import org.apache.hudi.org.roaringbitmap.BitmapDataProviderSupplier;
import org.apache.hudi.org.roaringbitmap.IntConsumer;
import org.apache.hudi.org.roaringbitmap.IntIterator;
import org.apache.hudi.org.roaringbitmap.RoaringBitmap;
import org.apache.hudi.org.roaringbitmap.RoaringBitmapPrivate;
import org.apache.hudi.org.roaringbitmap.RoaringBitmapSupplier;
import org.apache.hudi.org.roaringbitmap.Util;
import org.apache.hudi.org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.apache.hudi.org.roaringbitmap.buffer.MutableRoaringBitmapPrivate;
import org.apache.hudi.org.roaringbitmap.longlong.ImmutableLongBitmapDataProvider;
import org.apache.hudi.org.roaringbitmap.longlong.LongBitmapDataProvider;
import org.apache.hudi.org.roaringbitmap.longlong.LongConsumer;
import org.apache.hudi.org.roaringbitmap.longlong.LongIterator;
import org.apache.hudi.org.roaringbitmap.longlong.RoaringIntPacking;

public class Roaring64NavigableMap
implements Externalizable,
LongBitmapDataProvider {
    public static final int SERIALIZATION_MODE_LEGACY = 0;
    public static final int SERIALIZATION_MODE_PORTABLE = 1;
    public static int SERIALIZATION_MODE = 0;
    private NavigableMap<Integer, BitmapDataProvider> highToBitmap;
    private boolean signedLongs = false;
    private transient BitmapDataProviderSupplier supplier;
    private transient boolean doCacheCardinalities = true;
    private transient int firstHighNotValid = this.highestHigh() + 1;
    private transient boolean allValid = false;
    private transient long[] sortedCumulatedCardinality = new long[0];
    private transient int[] sortedHighs = new int[0];
    private transient Map.Entry<Integer, BitmapDataProvider> latestAddedHigh = null;
    private static final boolean DEFAULT_ORDER_IS_SIGNED = false;
    private static final boolean DEFAULT_CARDINALITIES_ARE_CACHED = true;

    public Roaring64NavigableMap() {
        this(false);
    }

    public Roaring64NavigableMap(boolean signedLongs) {
        this(signedLongs, true);
    }

    public Roaring64NavigableMap(boolean signedLongs, boolean cacheCardinalities) {
        this(signedLongs, cacheCardinalities, new RoaringBitmapSupplier());
    }

    public Roaring64NavigableMap(BitmapDataProviderSupplier supplier) {
        this(false, true, supplier);
    }

    public Roaring64NavigableMap(boolean signedLongs, BitmapDataProviderSupplier supplier) {
        this(signedLongs, true, supplier);
    }

    public Roaring64NavigableMap(boolean signedLongs, boolean cacheCardinalities, BitmapDataProviderSupplier supplier) {
        this.signedLongs = signedLongs;
        this.supplier = supplier;
        this.highToBitmap = signedLongs ? new TreeMap<Integer, BitmapDataProvider>() : new TreeMap<Integer, BitmapDataProvider>(RoaringIntPacking.unsignedComparator());
        this.doCacheCardinalities = cacheCardinalities;
        this.resetPerfHelpers();
    }

    private void resetPerfHelpers() {
        this.firstHighNotValid = RoaringIntPacking.highestHigh(this.signedLongs) + 1;
        this.allValid = false;
        this.sortedCumulatedCardinality = new long[0];
        this.sortedHighs = new int[0];
        this.latestAddedHigh = null;
    }

    NavigableMap<Integer, BitmapDataProvider> getHighToBitmap() {
        return this.highToBitmap;
    }

    int getLowestInvalidHigh() {
        return this.firstHighNotValid;
    }

    long[] getSortedCumulatedCardinality() {
        return this.sortedCumulatedCardinality;
    }

    private static String getClassName(BitmapDataProvider bitmap) {
        if (bitmap == null) {
            return "null";
        }
        return bitmap.getClass().getName();
    }

    @Override
    public void addLong(long x) {
        BitmapDataProvider bitmap;
        int high = this.high(x);
        int low = this.low(x);
        Map.Entry<Integer, BitmapDataProvider> local = this.latestAddedHigh;
        if (local != null && local.getKey() == high) {
            bitmap = local.getValue();
        } else {
            bitmap = (BitmapDataProvider)this.highToBitmap.get(high);
            if (bitmap == null) {
                bitmap = this.newRoaringBitmap();
                this.pushBitmapForHigh(high, bitmap);
            }
            this.latestAddedHigh = new AbstractMap.SimpleImmutableEntry<Integer, BitmapDataProvider>(high, bitmap);
        }
        bitmap.add(low);
        this.invalidateAboveHigh(high);
    }

    public void addInt(int x) {
        this.addLong(Util.toUnsignedLong(x));
    }

    private BitmapDataProvider newRoaringBitmap() {
        return this.supplier.newEmpty();
    }

    private void invalidateAboveHigh(int high) {
        if (this.compare(this.firstHighNotValid, high) > 0) {
            this.firstHighNotValid = high;
            int indexNotValid = this.binarySearch(this.sortedHighs, this.firstHighNotValid);
            int indexAfterWhichToReset = indexNotValid >= 0 ? indexNotValid : -indexNotValid - 1;
            Arrays.fill(this.sortedHighs, indexAfterWhichToReset, this.sortedHighs.length, this.highestHigh());
        }
        this.allValid = false;
    }

    private int compare(int x, int y) {
        if (this.signedLongs) {
            return Integer.compare(x, y);
        }
        return RoaringIntPacking.compareUnsigned(x, y);
    }

    private void pushBitmapForHigh(int high, BitmapDataProvider bitmap) {
        BitmapDataProvider previous = this.highToBitmap.put(high, bitmap);
        assert (previous == null) : "Should push only not-existing high";
    }

    private int low(long id) {
        return RoaringIntPacking.low(id);
    }

    private int high(long id) {
        return RoaringIntPacking.high(id);
    }

    @Override
    public long getLongCardinality() {
        if (this.doCacheCardinalities) {
            if (this.highToBitmap.isEmpty()) {
                return 0L;
            }
            int indexOk = this.ensureCumulatives(this.highestHigh());
            if (this.highToBitmap.isEmpty()) {
                return 0L;
            }
            return this.sortedCumulatedCardinality[indexOk - 1];
        }
        long cardinality = 0L;
        for (BitmapDataProvider bitmap : this.highToBitmap.values()) {
            cardinality += bitmap.getLongCardinality();
        }
        return cardinality;
    }

    public int getIntCardinality() throws UnsupportedOperationException {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot call .getIntCardinality as the cardinality is bigger than Integer.MAX_VALUE");
        }
        return (int)cardinality;
    }

    @Override
    public long select(long j) throws IllegalArgumentException {
        long previousBucketCardinality;
        if (!this.doCacheCardinalities) {
            return this.selectNoCache(j);
        }
        int indexOk = this.ensureCumulatives(this.highestHigh());
        if (this.highToBitmap.isEmpty()) {
            return this.throwSelectInvalidIndex(j);
        }
        int position = Arrays.binarySearch(this.sortedCumulatedCardinality, 0, indexOk, j);
        if (position >= 0) {
            if (position == indexOk - 1) {
                return this.throwSelectInvalidIndex(j);
            }
            int high = this.sortedHighs[position + 1];
            BitmapDataProvider nextBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
            return RoaringIntPacking.pack(high, nextBitmap.select(0));
        }
        int insertionPoint = -position - 1;
        if (insertionPoint == 0) {
            previousBucketCardinality = 0L;
        } else {
            if (insertionPoint >= indexOk) {
                return this.throwSelectInvalidIndex(j);
            }
            previousBucketCardinality = this.sortedCumulatedCardinality[insertionPoint - 1];
        }
        int givenBitmapSelect = (int)(j - previousBucketCardinality);
        int high = this.sortedHighs[insertionPoint];
        BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        int low = lowBitmap.select(givenBitmapSelect);
        return RoaringIntPacking.pack(high, low);
    }

    private long selectNoCache(long j) {
        long left = j;
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            long lowCardinality = ((BitmapDataProvider)entry.getValue()).getCardinality();
            if (left >= lowCardinality) {
                left -= lowCardinality;
                continue;
            }
            int leftAsUnsignedInt = (int)left;
            return RoaringIntPacking.pack((Integer)entry.getKey(), ((BitmapDataProvider)entry.getValue()).select(leftAsUnsignedInt));
        }
        return this.throwSelectInvalidIndex(j);
    }

    private long throwSelectInvalidIndex(long j) {
        throw new IllegalArgumentException("select " + j + " when the cardinality is " + this.getLongCardinality());
    }

    public Iterator<Long> iterator() {
        final LongIterator it = this.getLongIterator();
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Long next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void forEach(final LongConsumer lc) {
        for (final Map.Entry highEntry : this.highToBitmap.entrySet()) {
            ((BitmapDataProvider)highEntry.getValue()).forEach(new IntConsumer(){

                @Override
                public void accept(int low) {
                    lc.accept(RoaringIntPacking.pack((Integer)highEntry.getKey(), low));
                }
            });
        }
    }

    @Override
    public long rankLong(long id) {
        int high = RoaringIntPacking.high(id);
        int low = RoaringIntPacking.low(id);
        if (!this.doCacheCardinalities) {
            return this.rankLongNoCache(high, low);
        }
        int indexOk = this.ensureCumulatives(high);
        int highPosition = this.binarySearch(this.sortedHighs, 0, indexOk, high);
        if (highPosition >= 0) {
            long previousBucketCardinality = highPosition == 0 ? 0L : this.sortedCumulatedCardinality[highPosition - 1];
            BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(this.sortedHighs[highPosition]);
            return previousBucketCardinality + lowBitmap.rankLong(low);
        }
        int insertionPoint = -highPosition - 1;
        if (insertionPoint == 0) {
            return 0L;
        }
        return this.sortedCumulatedCardinality[insertionPoint - 1];
    }

    private long rankLongNoCache(int high, int low) {
        long result2 = 0L;
        BitmapDataProvider lastBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (lastBitmap == null) {
            for (Map.Entry bitmap : this.highToBitmap.entrySet()) {
                if ((Integer)bitmap.getKey() > high) break;
                result2 += ((BitmapDataProvider)bitmap.getValue()).getLongCardinality();
            }
        } else {
            for (BitmapDataProvider bitmap : this.highToBitmap.values()) {
                if (bitmap == lastBitmap) {
                    result2 += bitmap.rankLong(low);
                    break;
                }
                result2 += bitmap.getLongCardinality();
            }
        }
        return result2;
    }

    protected int ensureCumulatives(int high) {
        Map.Entry<Integer, BitmapDataProvider> e;
        int currentHigh;
        if (this.allValid) {
            return this.highToBitmap.size();
        }
        if (this.compare(high, this.firstHighNotValid) < 0) {
            int position = this.binarySearch(this.sortedHighs, high);
            if (position >= 0) {
                return position + 1;
            }
            int insertionPosition = -position - 1;
            return insertionPosition;
        }
        NavigableMap<Integer, BitmapDataProvider> tailMap = this.highToBitmap.tailMap(this.firstHighNotValid, true);
        int indexOk = this.highToBitmap.size() - tailMap.size();
        Iterator it = tailMap.entrySet().iterator();
        while (it.hasNext() && this.compare(currentHigh = ((Integer)(e = it.next()).getKey()).intValue(), high) <= 0) {
            if (((BitmapDataProvider)e.getValue()).isEmpty()) {
                if (this.latestAddedHigh != null && this.latestAddedHigh.getKey() == currentHigh) {
                    this.latestAddedHigh = null;
                }
                it.remove();
                continue;
            }
            this.ensureOne(e, currentHigh, indexOk);
            ++indexOk;
        }
        if (this.highToBitmap.isEmpty() || indexOk == this.highToBitmap.size()) {
            this.allValid = true;
        }
        return indexOk;
    }

    private int binarySearch(int[] array, int key) {
        if (this.signedLongs) {
            return Arrays.binarySearch(array, key);
        }
        return Roaring64NavigableMap.unsignedBinarySearch(array, 0, array.length, key, RoaringIntPacking.unsignedComparator());
    }

    private int binarySearch(int[] array, int from, int to, int key) {
        if (this.signedLongs) {
            return Arrays.binarySearch(array, from, to, key);
        }
        return Roaring64NavigableMap.unsignedBinarySearch(array, from, to, key, RoaringIntPacking.unsignedComparator());
    }

    private static int unsignedBinarySearch(int[] a, int fromIndex, int toIndex, int key, Comparator<? super Integer> c) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            int cmp = c.compare((Integer)midVal, (Integer)key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void ensureOne(Map.Entry<Integer, BitmapDataProvider> e, int currentHigh, int indexOk) {
        assert (indexOk <= this.sortedHighs.length) : indexOk + " is bigger than " + this.sortedHighs.length;
        int index = indexOk == 0 ? (this.sortedHighs.length == 0 ? -1 : -1) : (indexOk < this.sortedHighs.length ? -indexOk - 1 : -this.sortedHighs.length - 1);
        assert (index == this.binarySearch(this.sortedHighs, 0, indexOk, currentHigh)) : "Computed " + index + " differs from dummy binary-search index: " + this.binarySearch(this.sortedHighs, 0, indexOk, currentHigh);
        if (index >= 0) {
            throw new IllegalStateException("Unexpectedly found " + currentHigh + " in " + Arrays.toString(this.sortedHighs) + " strictly before index" + indexOk);
        }
        int insertionPosition = -index - 1;
        if (insertionPosition >= this.sortedHighs.length) {
            int previousSize = this.sortedHighs.length;
            int newSize = Math.min(Integer.MAX_VALUE, this.sortedHighs.length * 2 + 1);
            this.sortedHighs = Arrays.copyOf(this.sortedHighs, newSize);
            this.sortedCumulatedCardinality = Arrays.copyOf(this.sortedCumulatedCardinality, newSize);
            Arrays.fill(this.sortedHighs, previousSize, this.sortedHighs.length, this.highestHigh());
            Arrays.fill(this.sortedCumulatedCardinality, previousSize, this.sortedHighs.length, Long.MAX_VALUE);
        }
        this.sortedHighs[insertionPosition] = currentHigh;
        long previousCardinality = insertionPosition >= 1 ? this.sortedCumulatedCardinality[insertionPosition - 1] : 0L;
        this.sortedCumulatedCardinality[insertionPosition] = previousCardinality + e.getValue().getLongCardinality();
        this.firstHighNotValid = currentHigh == this.highestHigh() ? currentHigh : currentHigh + 1;
    }

    private int highestHigh() {
        return RoaringIntPacking.highestHigh(this.signedLongs);
    }

    public void naivelazyor(Roaring64NavigableMap x2) {
        if (this == x2) {
            return;
        }
        for (Map.Entry e2 : x2.highToBitmap.entrySet()) {
            Integer high = (Integer)e2.getKey();
            BitmapDataProvider lowBitmap1 = (BitmapDataProvider)this.highToBitmap.get(high);
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)e2.getValue();
            if (lowBitmap1 == null) {
                Cloneable lowBitmap2Clone;
                if (lowBitmap2 instanceof RoaringBitmap) {
                    lowBitmap2Clone = ((RoaringBitmap)lowBitmap2).clone();
                } else if (lowBitmap2 instanceof MutableRoaringBitmap) {
                    lowBitmap2Clone = ((MutableRoaringBitmap)lowBitmap2).clone();
                } else {
                    throw new UnsupportedOperationException(".naivelazyor(...) over " + Roaring64NavigableMap.getClassName(lowBitmap2));
                }
                this.pushBitmapForHigh(high, (BitmapDataProvider)((Object)lowBitmap2Clone));
                continue;
            }
            if (lowBitmap1 instanceof RoaringBitmap && lowBitmap2 instanceof RoaringBitmap) {
                RoaringBitmapPrivate.naivelazyor((RoaringBitmap)lowBitmap1, (RoaringBitmap)lowBitmap2);
                continue;
            }
            if (lowBitmap1 instanceof MutableRoaringBitmap && lowBitmap2 instanceof MutableRoaringBitmap) {
                MutableRoaringBitmapPrivate.naivelazyor((MutableRoaringBitmap)lowBitmap1, (MutableRoaringBitmap)lowBitmap2);
                continue;
            }
            throw new UnsupportedOperationException(".naivelazyor(...) over " + Roaring64NavigableMap.getClassName(lowBitmap1) + " and " + Roaring64NavigableMap.getClassName(lowBitmap2));
        }
    }

    public void or(Roaring64NavigableMap x2) {
        if (this == x2) {
            return;
        }
        boolean firstBucket = true;
        for (Map.Entry e2 : x2.highToBitmap.entrySet()) {
            Cloneable lowBitmap2Clone;
            Integer high = (Integer)e2.getKey();
            BitmapDataProvider lowBitmap1 = (BitmapDataProvider)this.highToBitmap.get(high);
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)e2.getValue();
            if ((lowBitmap1 == null || lowBitmap1 instanceof RoaringBitmap) && lowBitmap2 instanceof RoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((RoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)((Object)lowBitmap2Clone));
                } else {
                    ((RoaringBitmap)lowBitmap1).or((RoaringBitmap)lowBitmap2);
                }
            } else if ((lowBitmap1 == null || lowBitmap1 instanceof MutableRoaringBitmap) && lowBitmap2 instanceof MutableRoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((MutableRoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)((Object)lowBitmap2Clone));
                } else {
                    ((MutableRoaringBitmap)lowBitmap1).or((MutableRoaringBitmap)lowBitmap2);
                }
            } else {
                throw new UnsupportedOperationException(".or(...) over " + Roaring64NavigableMap.getClassName(lowBitmap1) + " and " + Roaring64NavigableMap.getClassName(lowBitmap2));
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public void xor(Roaring64NavigableMap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        boolean firstBucket = true;
        for (Map.Entry e2 : x2.highToBitmap.entrySet()) {
            Cloneable lowBitmap2Clone;
            Integer high = (Integer)e2.getKey();
            BitmapDataProvider lowBitmap1 = (BitmapDataProvider)this.highToBitmap.get(high);
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)e2.getValue();
            if ((lowBitmap1 == null || lowBitmap1 instanceof RoaringBitmap) && lowBitmap2 instanceof RoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((RoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)((Object)lowBitmap2Clone));
                } else {
                    ((RoaringBitmap)lowBitmap1).xor((RoaringBitmap)lowBitmap2);
                }
            } else if ((lowBitmap1 == null || lowBitmap1 instanceof MutableRoaringBitmap) && lowBitmap2 instanceof MutableRoaringBitmap) {
                if (lowBitmap1 == null) {
                    lowBitmap2Clone = ((MutableRoaringBitmap)lowBitmap2).clone();
                    this.pushBitmapForHigh(high, (BitmapDataProvider)((Object)lowBitmap2Clone));
                } else {
                    ((MutableRoaringBitmap)lowBitmap1).xor((MutableRoaringBitmap)lowBitmap2);
                }
            } else {
                throw new UnsupportedOperationException(".or(...) over " + Roaring64NavigableMap.getClassName(lowBitmap1) + " and " + Roaring64NavigableMap.getClassName(lowBitmap2));
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public void and(Roaring64NavigableMap x2) {
        if (x2 == this) {
            return;
        }
        boolean firstBucket = true;
        Iterator thisIterator = this.highToBitmap.entrySet().iterator();
        while (thisIterator.hasNext()) {
            Map.Entry e1 = thisIterator.next();
            Integer high = (Integer)e1.getKey();
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)x2.highToBitmap.get(high);
            if (lowBitmap2 == null) {
                thisIterator.remove();
            } else {
                BitmapDataProvider lowBitmap1 = (BitmapDataProvider)e1.getValue();
                if (lowBitmap2 instanceof RoaringBitmap && lowBitmap1 instanceof RoaringBitmap) {
                    ((RoaringBitmap)lowBitmap1).and((RoaringBitmap)lowBitmap2);
                } else if (lowBitmap2 instanceof MutableRoaringBitmap && lowBitmap1 instanceof MutableRoaringBitmap) {
                    ((MutableRoaringBitmap)lowBitmap1).and((MutableRoaringBitmap)lowBitmap2);
                } else {
                    throw new UnsupportedOperationException(".and(...) over " + Roaring64NavigableMap.getClassName(lowBitmap1) + " and " + Roaring64NavigableMap.getClassName(lowBitmap2));
                }
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    public void andNot(Roaring64NavigableMap x2) {
        if (x2 == this) {
            this.clear();
            return;
        }
        boolean firstBucket = true;
        for (Map.Entry e1 : this.highToBitmap.entrySet()) {
            Integer high = (Integer)e1.getKey();
            BitmapDataProvider lowBitmap2 = (BitmapDataProvider)x2.highToBitmap.get(high);
            if (lowBitmap2 != null) {
                BitmapDataProvider lowBitmap1 = (BitmapDataProvider)e1.getValue();
                if (lowBitmap2 instanceof RoaringBitmap && lowBitmap1 instanceof RoaringBitmap) {
                    ((RoaringBitmap)lowBitmap1).andNot((RoaringBitmap)lowBitmap2);
                } else if (lowBitmap2 instanceof MutableRoaringBitmap && lowBitmap1 instanceof MutableRoaringBitmap) {
                    ((MutableRoaringBitmap)lowBitmap1).andNot((MutableRoaringBitmap)lowBitmap2);
                } else {
                    throw new UnsupportedOperationException(".and(...) over " + Roaring64NavigableMap.getClassName(lowBitmap1) + " and " + Roaring64NavigableMap.getClassName(lowBitmap2));
                }
            }
            if (!firstBucket) continue;
            firstBucket = false;
            this.firstHighNotValid = Math.min(this.firstHighNotValid, high);
            this.allValid = false;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public String toString() {
        StringBuilder answer = new StringBuilder("{}".length() + "-1234567890123456789,".length() * 256);
        LongIterator i = this.getLongIterator();
        answer.append('{');
        if (i.hasNext()) {
            if (this.signedLongs) {
                answer.append(i.next());
            } else {
                answer.append(RoaringIntPacking.toUnsignedString(i.next()));
            }
        }
        while (i.hasNext()) {
            answer.append(',');
            if (answer.length() > 524288) {
                answer.append('.').append('.').append('.');
                break;
            }
            if (this.signedLongs) {
                answer.append(i.next());
                continue;
            }
            answer.append(RoaringIntPacking.toUnsignedString(i.next()));
        }
        answer.append("}");
        return answer.toString();
    }

    @Override
    public LongIterator getLongIterator() {
        Iterator<Map.Entry<Integer, BitmapDataProvider>> it = this.highToBitmap.entrySet().iterator();
        return this.toIterator(it, false);
    }

    protected LongIterator toIterator(final Iterator<Map.Entry<Integer, BitmapDataProvider>> it, final boolean reversed) {
        return new LongIterator(){
            protected int currentKey;
            protected IntIterator currentIt;

            @Override
            public boolean hasNext() {
                if (this.currentIt == null && !this.moveToNextEntry(it)) {
                    return false;
                }
                do {
                    if (!this.currentIt.hasNext()) continue;
                    return true;
                } while (this.moveToNextEntry(it));
                return false;
            }

            private boolean moveToNextEntry(Iterator<Map.Entry<Integer, BitmapDataProvider>> it2) {
                if (it2.hasNext()) {
                    Map.Entry<Integer, BitmapDataProvider> next = it2.next();
                    this.currentKey = next.getKey();
                    this.currentIt = reversed ? next.getValue().getReverseIntIterator() : next.getValue().getIntIterator();
                    return true;
                }
                return false;
            }

            @Override
            public long next() {
                if (this.hasNext()) {
                    return RoaringIntPacking.pack(this.currentKey, this.currentIt.next());
                }
                throw new IllegalStateException("empty");
            }

            @Override
            public LongIterator clone() {
                throw new UnsupportedOperationException("TODO");
            }
        };
    }

    @Override
    public boolean contains(long x) {
        int high = RoaringIntPacking.high(x);
        BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (lowBitmap == null) {
            return false;
        }
        int low = RoaringIntPacking.low(x);
        return lowBitmap.contains(low);
    }

    @Override
    public int getSizeInBytes() {
        return (int)this.getLongSizeInBytes();
    }

    @Override
    public long getLongSizeInBytes() {
        long size = 8L;
        size += this.highToBitmap.values().stream().mapToLong(p -> p.getLongSizeInBytes()).sum();
        size += 8L + 40L * (long)this.highToBitmap.size();
        size += 16L * (long)this.highToBitmap.size();
        size += 8L * (long)this.sortedCumulatedCardinality.length;
        return size += 4L * (long)this.sortedHighs.length;
    }

    @Override
    public boolean isEmpty() {
        return this.getLongCardinality() == 0L;
    }

    @Override
    public ImmutableLongBitmapDataProvider limit(long x) {
        throw new UnsupportedOperationException("TODO");
    }

    public void repairAfterLazy() {
        for (BitmapDataProvider lowBitmap : this.highToBitmap.values()) {
            if (lowBitmap instanceof RoaringBitmap) {
                RoaringBitmapPrivate.repairAfterLazy((RoaringBitmap)lowBitmap);
                continue;
            }
            if (lowBitmap instanceof MutableRoaringBitmap) {
                MutableRoaringBitmapPrivate.repairAfterLazy((MutableRoaringBitmap)lowBitmap);
                continue;
            }
            throw new UnsupportedOperationException(".repairAfterLazy is not supported for " + lowBitmap.getClass());
        }
    }

    public boolean runOptimize() {
        boolean hasChanged = false;
        for (BitmapDataProvider lowBitmap : this.highToBitmap.values()) {
            if (lowBitmap instanceof RoaringBitmap) {
                hasChanged |= ((RoaringBitmap)lowBitmap).runOptimize();
                continue;
            }
            if (!(lowBitmap instanceof MutableRoaringBitmap)) continue;
            hasChanged |= ((MutableRoaringBitmap)lowBitmap).runOptimize();
        }
        return hasChanged;
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        if (SERIALIZATION_MODE == 1) {
            this.serializePortable(out);
        } else {
            this.serializeLegacy(out);
        }
    }

    @Deprecated
    public void serializeLegacy(DataOutput out) throws IOException {
        out.writeBoolean(this.signedLongs);
        out.writeInt(this.highToBitmap.size());
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            out.writeInt((Integer)entry.getKey());
            ((BitmapDataProvider)entry.getValue()).serialize(out);
        }
    }

    public void serializePortable(DataOutput out) throws IOException {
        out.writeLong(Long.reverseBytes(this.highToBitmap.size()));
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            out.writeInt(Integer.reverseBytes((Integer)entry.getKey()));
            ((BitmapDataProvider)entry.getValue()).serialize(out);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        if (SERIALIZATION_MODE == 1) {
            this.deserializePortable(in);
        } else {
            this.deserializeLegacy(in);
        }
    }

    public void deserializeLegacy(DataInput in) throws IOException {
        this.clear();
        this.signedLongs = in.readBoolean();
        int nbHighs = in.readInt();
        this.highToBitmap = this.signedLongs ? new TreeMap<Integer, BitmapDataProvider>() : new TreeMap<Integer, BitmapDataProvider>(RoaringIntPacking.unsignedComparator());
        for (int i = 0; i < nbHighs; ++i) {
            int high = in.readInt();
            BitmapDataProvider provider = this.newRoaringBitmap();
            if (provider instanceof RoaringBitmap) {
                ((RoaringBitmap)provider).deserialize(in);
            } else if (provider instanceof MutableRoaringBitmap) {
                ((MutableRoaringBitmap)provider).deserialize(in);
            } else {
                throw new UnsupportedEncodingException("Cannot deserialize a " + provider.getClass());
            }
            this.highToBitmap.put(high, provider);
        }
        this.resetPerfHelpers();
    }

    public void deserializePortable(DataInput in) throws IOException {
        this.clear();
        this.signedLongs = false;
        long nbHighs = Long.reverseBytes(in.readLong());
        this.highToBitmap = new TreeMap<Integer, BitmapDataProvider>(RoaringIntPacking.unsignedComparator());
        int i = 0;
        while ((long)i < nbHighs) {
            int high = Integer.reverseBytes(in.readInt());
            BitmapDataProvider provider = this.newRoaringBitmap();
            if (provider instanceof RoaringBitmap) {
                ((RoaringBitmap)provider).deserialize(in);
            } else if (provider instanceof MutableRoaringBitmap) {
                ((MutableRoaringBitmap)provider).deserialize(in);
            } else {
                throw new UnsupportedEncodingException("Cannot deserialize a " + provider.getClass());
            }
            this.highToBitmap.put(high, provider);
            ++i;
        }
        this.resetPerfHelpers();
    }

    @Override
    public long serializedSizeInBytes() {
        long nbBytes = 0L;
        if (SERIALIZATION_MODE == 1) {
            nbBytes += 8L;
        } else {
            ++nbBytes;
            nbBytes += 4L;
        }
        for (Map.Entry entry : this.highToBitmap.entrySet()) {
            nbBytes += 4L;
            nbBytes += (long)((BitmapDataProvider)entry.getValue()).serializedSizeInBytes();
        }
        return nbBytes;
    }

    public void clear() {
        this.highToBitmap.clear();
        this.resetPerfHelpers();
    }

    @Override
    public long[] toArray() {
        long cardinality = this.getLongCardinality();
        if (cardinality > Integer.MAX_VALUE) {
            throw new IllegalStateException("The cardinality does not fit in an array");
        }
        long[] array = new long[(int)cardinality];
        int pos = 0;
        LongIterator it = this.getLongIterator();
        while (it.hasNext()) {
            array[pos++] = it.next();
        }
        return array;
    }

    public static Roaring64NavigableMap bitmapOf(long ... dat) {
        Roaring64NavigableMap ans = new Roaring64NavigableMap();
        ans.add(dat);
        return ans;
    }

    public void add(long ... dat) {
        for (long oneLong : dat) {
            this.addLong(oneLong);
        }
    }

    @Deprecated
    public void add(long rangeStart, long rangeEnd) {
        this.addRange(rangeStart, rangeEnd);
    }

    public void addRange(long rangeStart, long rangeEnd) {
        int startHigh = this.high(rangeStart);
        int startLow = this.low(rangeStart);
        int endHigh = this.high(rangeEnd);
        int endLow = this.low(rangeEnd);
        int compareHigh = this.compare(startHigh, endHigh);
        if (compareHigh > 0 || compareHigh == 0 && Util.toUnsignedLong(startLow) >= Util.toUnsignedLong(endLow)) {
            throw new IllegalArgumentException("Invalid range [" + rangeStart + "," + rangeEnd + ")");
        }
        int high = startHigh;
        while (this.compare(high, endHigh) <= 0) {
            int currentStartLow;
            long startLowAsLong;
            long endLowAsLong = endHigh == high ? Util.toUnsignedLong(endLow) : Util.toUnsignedLong(-1) + 1L;
            if (endLowAsLong > (startLowAsLong = Util.toUnsignedLong(currentStartLow = startHigh == high ? startLow : 0))) {
                BitmapDataProvider bitmap = (BitmapDataProvider)this.highToBitmap.get(high);
                if (bitmap == null) {
                    bitmap = this.newRoaringBitmap();
                    this.pushBitmapForHigh(high, bitmap);
                }
                bitmap.add(startLowAsLong, endLowAsLong);
            }
            if (high == this.highestHigh()) break;
            ++high;
        }
        this.invalidateAboveHigh(startHigh);
    }

    @Override
    public LongIterator getReverseLongIterator() {
        return this.toIterator(this.highToBitmap.descendingMap().entrySet().iterator(), true);
    }

    @Override
    public void removeLong(long x) {
        int high = this.high(x);
        BitmapDataProvider bitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (bitmap != null) {
            int low = this.low(x);
            bitmap.remove(low);
            if (bitmap.isEmpty()) {
                this.highToBitmap.remove(high);
                this.latestAddedHigh = null;
            }
            this.invalidateAboveHigh(high);
        }
    }

    @Override
    public void trim() {
        for (BitmapDataProvider bitmap : this.highToBitmap.values()) {
            bitmap.trim();
        }
    }

    public int hashCode() {
        return this.highToBitmap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Roaring64NavigableMap other = (Roaring64NavigableMap)obj;
        return Objects.equals(this.highToBitmap, other.highToBitmap);
    }

    public void flip(long x) {
        int high = RoaringIntPacking.high(x);
        BitmapDataProvider lowBitmap = (BitmapDataProvider)this.highToBitmap.get(high);
        if (lowBitmap == null) {
            this.addLong(x);
        } else {
            int low = RoaringIntPacking.low(x);
            if (lowBitmap instanceof RoaringBitmap) {
                ((RoaringBitmap)lowBitmap).flip(low);
            } else if (lowBitmap instanceof MutableRoaringBitmap) {
                ((MutableRoaringBitmap)lowBitmap).flip(low);
            } else if (lowBitmap.contains(low)) {
                lowBitmap.remove(low);
            } else {
                lowBitmap.add(low);
            }
        }
        this.invalidateAboveHigh(high);
    }

    private void assertNonEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty " + this.getClass().getSimpleName());
        }
    }

    @Override
    public long first() {
        this.assertNonEmpty();
        Map.Entry<Integer, BitmapDataProvider> firstEntry = this.highToBitmap.firstEntry();
        return RoaringIntPacking.pack(firstEntry.getKey(), firstEntry.getValue().first());
    }

    @Override
    public long last() {
        this.assertNonEmpty();
        Map.Entry<Integer, BitmapDataProvider> lastEntry = this.highToBitmap.lastEntry();
        return RoaringIntPacking.pack(lastEntry.getKey(), lastEntry.getValue().last());
    }
}

