/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark3.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.BaseDefaultSource;
import org.apache.hudi.spark3.internal.HoodieDataSourceInternalTable;
import org.apache.spark.sql.HoodieDataTypeUtils;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class DefaultSource
extends BaseDefaultSource
implements TableProvider {
    public StructType inferSchema(CaseInsensitiveStringMap options) {
        String jsonSchema = options.get((Object)HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key());
        return HoodieDataTypeUtils.parseStructTypeFromJson(jsonSchema);
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties2) {
        String instantTime = properties2.get("hoodie.instant.time");
        String path = properties2.get("path");
        String tblName = properties2.get(HoodieWriteConfig.TBL_NAME.key());
        boolean populateMetaFields = Boolean.parseBoolean(properties2.getOrDefault(HoodieTableConfig.POPULATE_META_FIELDS.key(), Boolean.toString(HoodieTableConfig.POPULATE_META_FIELDS.defaultValue())));
        boolean arePartitionRecordsSorted = Boolean.parseBoolean(properties2.getOrDefault("hoodie.bulkinsert.are.partitioner.records.sorted", Boolean.toString(HoodieInternalConfig.DEFAULT_BULKINSERT_ARE_PARTITIONER_RECORDS_SORTED)));
        HashMap<String, String> newProps = new HashMap<String, String>(properties2);
        HoodieDataTypeUtils.tryOverrideParquetWriteLegacyFormatProperty(newProps, schema);
        HoodieWriteConfig config = DataSourceUtils.createHoodieConfig((String)newProps.get(HoodieWriteConfig.AVRO_SCHEMA_STRING.key()), path, tblName, newProps);
        return new HoodieDataSourceInternalTable(instantTime, config, schema, this.getSparkSession(), this.getConfiguration(), newProps, populateMetaFields, arePartitionRecordsSorted);
    }
}

