/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark3.internal;

import java.util.Map;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.spark3.internal.HoodieDataSourceInternalBatchWrite;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;

public class HoodieDataSourceInternalBatchWriteBuilder
implements WriteBuilder {
    private final String instantTime;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final SparkSession jss;
    private final StorageConfiguration<?> storageConf;
    private final Map<String, String> properties;
    private final boolean populateMetaFields;
    private final boolean arePartitionRecordsSorted;

    public HoodieDataSourceInternalBatchWriteBuilder(String instantTime, HoodieWriteConfig writeConfig, StructType structType, SparkSession jss, StorageConfiguration<?> storageConf, Map<String, String> properties2, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.instantTime = instantTime;
        this.writeConfig = writeConfig;
        this.structType = structType;
        this.jss = jss;
        this.storageConf = storageConf;
        this.properties = properties2;
        this.populateMetaFields = populateMetaFields;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
    }

    public BatchWrite buildForBatch() {
        return new HoodieDataSourceInternalBatchWrite(this.instantTime, this.writeConfig, this.structType, this.jss, this.storageConf, this.properties, this.populateMetaFields, this.arePartitionRecordsSorted);
    }
}

