/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import org.apache.hudi.client.transaction.DirectMarkerTransactionManager;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieEarlyConflictDetectionException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.marker.SimpleDirectMarkerBasedDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTransactionDirectMarkerBasedDetectionStrategy
extends SimpleDirectMarkerBasedDetectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTransactionDirectMarkerBasedDetectionStrategy.class);

    public SimpleTransactionDirectMarkerBasedDetectionStrategy(HoodieStorage storage2, String partitionPath, String fileId, String instantTime, HoodieActiveTimeline activeTimeline, HoodieWriteConfig config) {
        super(storage2, partitionPath, fileId, instantTime, activeTimeline, config);
    }

    @Override
    public void detectAndResolveConflictIfNecessary() throws HoodieEarlyConflictDetectionException {
        DirectMarkerTransactionManager txnManager = new DirectMarkerTransactionManager((HoodieWriteConfig)this.config, this.storage, this.partitionPath, this.fileId);
        InstantGenerator instantGenerator = TimelineLayout.fromVersion(this.activeTimeline.getTimelineLayoutVersion()).getInstantGenerator();
        try {
            txnManager.beginTransaction(this.instantTime, instantGenerator);
            super.detectAndResolveConflictIfNecessary();
        }
        catch (Exception e) {
            LOG.warn("Exception occurs during create marker file in early conflict detection mode within transaction.");
            throw e;
        }
        finally {
            txnManager.endTransaction(this.instantTime, instantGenerator);
            txnManager.close();
        }
    }
}

