/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.client.timeline.TimelineArchivers;
import org.apache.hudi.client.timeline.versioning.v1.TimelineArchiverV1;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.MetadataConversionUtils;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.v1.ActiveTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.ArchivedTimelineLoaderV2;
import org.apache.hudi.common.table.timeline.versioning.v2.CommitMetadataSerDeV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.DowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EightToSevenDowngradeHandler
implements DowngradeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EightToSevenDowngradeHandler.class);
    private static final Set<String> SUPPORTED_METADATA_PARTITION_PATHS = EightToSevenDowngradeHandler.getSupportedMetadataPartitionPaths();

    @Override
    public Map<ConfigProperty, String> downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        List<HoodieInstant> instants;
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HashMap<ConfigProperty, String> tablePropsToAdd = new HashMap<ConfigProperty, String>();
        UpgradeDowngradeUtils.rollbackFailedWritesAndCompact(table, context, config, upgradeDowngradeHelper, HoodieTableType.MERGE_ON_READ.equals((Object)table.getMetaClient().getTableType()), HoodieTableVersion.EIGHT);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getStorageConf().newInstance()).setBasePath(config.getBasePath()).build();
        try {
            instants = metaClient.scanHoodieInstantsFromFileSystem(metaClient.getTimelinePath(), ActiveTimelineV2.VALID_EXTENSIONS_IN_ACTIVE_TIMELINE, false);
        }
        catch (IOException ioe) {
            LOG.error("Failed to get instants from filesystem", (Throwable)ioe);
            throw new HoodieIOException("Failed to get instants from filesystem", ioe);
        }
        if (!instants.isEmpty()) {
            InstantFileNameGenerator instantFileNameGenerator = metaClient.getInstantFileNameGenerator();
            CommitMetadataSerDeV2 commitMetadataSerDeV2 = new CommitMetadataSerDeV2();
            CommitMetadataSerDeV1 commitMetadataSerDeV1 = new CommitMetadataSerDeV1();
            ActiveTimelineV1 activeTimelineV1 = new ActiveTimelineV1(metaClient);
            context.map(instants, instant -> {
                String originalFileName = instantFileNameGenerator.getFileName((HoodieInstant)instant);
                return EightToSevenDowngradeHandler.downgradeActiveTimelineInstant(instant, originalFileName, metaClient, commitMetadataSerDeV2, commitMetadataSerDeV1, activeTimelineV1);
            }, instants.size());
        }
        try {
            EightToSevenDowngradeHandler.downgradeFromLSMTimeline(table, config);
        }
        catch (Exception e) {
            LOG.warn("Failed to downgrade from LSM timeline");
        }
        EightToSevenDowngradeHandler.downgradePartitionFields(config, metaClient.getTableConfig(), tablePropsToAdd);
        EightToSevenDowngradeHandler.unsetInitialVersion(metaClient.getTableConfig(), tablePropsToAdd);
        EightToSevenDowngradeHandler.unsetRecordMergeMode(metaClient.getTableConfig(), tablePropsToAdd);
        EightToSevenDowngradeHandler.downgradeKeyGeneratorType(metaClient.getTableConfig(), tablePropsToAdd);
        EightToSevenDowngradeHandler.downgradeBootstrapIndexType(metaClient.getTableConfig(), tablePropsToAdd);
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            EightToSevenDowngradeHandler.downgradeMetadataPartitions(context, metaClient.getStorage(), metaClient, tablePropsToAdd);
            UpgradeDowngradeUtils.updateMetadataTableVersion(context, HoodieTableVersion.SEVEN, metaClient);
        }
        return tablePropsToAdd;
    }

    static void downgradePartitionFields(HoodieWriteConfig config, HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String keyGenerator = tableConfig.getKeyGeneratorClassName();
        String partitionPathField = config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        if (keyGenerator != null && partitionPathField != null && (keyGenerator.equals(KeyGeneratorType.CUSTOM.getClassName()) || keyGenerator.equals(KeyGeneratorType.CUSTOM_AVRO.getClassName()))) {
            tablePropsToAdd.put(HoodieTableConfig.PARTITION_FIELDS, tableConfig.getPartitionFieldProp());
        }
    }

    static void unsetInitialVersion(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        tableConfig.getProps().remove(HoodieTableConfig.INITIAL_VERSION.key());
    }

    static void unsetRecordMergeMode(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        Triple<RecordMergeMode, String, String> mergingConfigs = HoodieTableConfig.inferCorrectMergingBehavior(tableConfig.getRecordMergeMode(), tableConfig.getPayloadClass(), tableConfig.getRecordMergeStrategyId(), tableConfig.getPreCombineField(), tableConfig.getTableVersion());
        if (StringUtils.nonEmpty(mergingConfigs.getMiddle())) {
            tablePropsToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, mergingConfigs.getMiddle());
        }
        if (StringUtils.nonEmpty(mergingConfigs.getRight())) {
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, mergingConfigs.getRight());
        }
        tableConfig.getProps().remove(HoodieTableConfig.RECORD_MERGE_MODE.key());
    }

    static void downgradeBootstrapIndexType(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String bootstrapIndexClassName;
        if ((tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME) || tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)) && StringUtils.nonEmpty(bootstrapIndexClassName = BootstrapIndexType.getBootstrapIndexClassName(tableConfig))) {
            tablePropsToAdd.put(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME, bootstrapIndexClassName);
        }
        tableConfig.getProps().remove(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE.key());
    }

    static void downgradeKeyGeneratorType(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String keyGenerator;
        if ((tableConfig.contains(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME) || tableConfig.contains(HoodieTableConfig.KEY_GENERATOR_TYPE)) && StringUtils.nonEmpty(keyGenerator = KeyGeneratorType.getKeyGeneratorClassName(tableConfig))) {
            tablePropsToAdd.put(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, keyGenerator);
        }
        tableConfig.getProps().remove(HoodieTableConfig.KEY_GENERATOR_TYPE.key());
    }

    static void downgradeFromLSMTimeline(HoodieTable table, HoodieWriteConfig config) {
        block14: {
            table.getMetaClient().getTableConfig().getTimelineLayoutVersion().ifPresent(timelineLayoutVersion -> ValidationUtils.checkState(TimelineLayoutVersion.LAYOUT_VERSION_2.equals(timelineLayoutVersion), "Downgrade from LSM timeline is only supported for layout version 2. Given version: " + timelineLayoutVersion));
            try {
                TimelineArchiverV1 archiver = (TimelineArchiverV1)TimelineArchivers.getInstance(TimelineLayoutVersion.LAYOUT_VERSION_1, config, table);
                int batchSize = config.getCommitArchivalBatchSize();
                StoragePath archivePath = new StoragePath(table.getMetaClient().getMetaPath(), "archived");
                try (ArchiveEntryFlusher flusher = new ArchiveEntryFlusher(table.getMetaClient(), archiver, batchSize, archivePath);){
                    ArchivedTimelineLoaderV2 timelineLoader = new ArchivedTimelineLoaderV2();
                    timelineLoader.loadInstants(table.getMetaClient(), null, HoodieArchivedTimeline.LoadMode.FULL, record -> true, flusher);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to downgrade LSM timeline to old archived format");
                if (!config.isFailOnTimelineArchivingEnabled()) break block14;
                throw new HoodieException("Failed to downgrade LSM timeline to old archived format", e);
            }
        }
    }

    static boolean downgradeActiveTimelineInstant(HoodieInstant instant, String originalFileName, HoodieTableMetaClient metaClient, CommitMetadataSerDeV2 commitMetadataSerDeV2, CommitMetadataSerDeV1 commitMetadataSerDeV1, ActiveTimelineV1 activeTimelineV1) {
        String replacedFileName = originalFileName;
        boolean isCompleted = instant.isCompleted();
        if (isCompleted) {
            replacedFileName = replacedFileName.replaceAll("_\\d+", "");
        }
        if (UpgradeDowngradeUtils.EIGHT_TO_SIX_TIMELINE_ACTION_MAP.containsKey(instant.getAction()) && !isCompleted) {
            replacedFileName = replacedFileName.replace(instant.getAction(), UpgradeDowngradeUtils.EIGHT_TO_SIX_TIMELINE_ACTION_MAP.get(instant.getAction()));
        }
        try {
            return EightToSevenDowngradeHandler.rewriteTimelineV2InstantFileToV1Format(instant, metaClient, originalFileName, replacedFileName, commitMetadataSerDeV2, commitMetadataSerDeV1, activeTimelineV1);
        }
        catch (IOException e) {
            LOG.error("Can not to complete the downgrade from version eight to version seven. The reason for failure is {}", (Object)e.getMessage());
            throw new HoodieException(e);
        }
    }

    static boolean rewriteTimelineV2InstantFileToV1Format(HoodieInstant instant, HoodieTableMetaClient metaClient, String originalFileName, String replacedFileName, CommitMetadataSerDeV2 commitMetadataSerDeV2, CommitMetadataSerDeV1 commitMetadataSerDeV1, ActiveTimelineV1 activeTimelineV1) throws IOException {
        StoragePath fromPath = new StoragePath(TimelineLayout.TIMELINE_LAYOUT_V2.getTimelinePathProvider().getTimelinePath(metaClient.getTableConfig(), metaClient.getBasePath()), originalFileName);
        long modificationTime = instant.isCompleted() ? UpgradeDowngradeUtils.convertCompletionTimeToEpoch(instant) : -1L;
        StoragePath toPath = new StoragePath(TimelineLayout.TIMELINE_LAYOUT_V1.getTimelinePathProvider().getTimelinePath(metaClient.getTableConfig(), metaClient.getBasePath()), replacedFileName);
        boolean success = true;
        if (instant.getAction().equals("commit") || instant.getAction().equals("deltacommit") || (instant.getAction().equals("replacecommit") || instant.getAction().equals("clustering")) && instant.isCompleted()) {
            Option<byte[]> data2 = instant.getAction().equals("replacecommit") || instant.getAction().equals("clustering") ? commitMetadataSerDeV1.serialize(HoodieReplaceCommitMetadata.fromBytes(metaClient.getActiveTimeline().getInstantDetails(instant).get(), HoodieReplaceCommitMetadata.class)) : commitMetadataSerDeV1.serialize(commitMetadataSerDeV2.deserialize(instant, metaClient.getActiveTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class));
            String toPathStr = toPath.toUri().toString();
            activeTimelineV1.createFileInMetaPath(toPathStr, data2, true);
            if (modificationTime > 0L) {
                metaClient.getStorage().setModificationTime(toPath, modificationTime);
            }
            metaClient.getStorage().deleteFile(fromPath);
        } else {
            success = metaClient.getStorage().rename(fromPath, toPath);
        }
        if (!success) {
            throw new HoodieIOException("an error that occurred while renaming " + fromPath + " to: " + toPath);
        }
        return true;
    }

    static void downgradeMetadataPartitions(HoodieEngineContext context, HoodieStorage hoodieStorage, HoodieTableMetaClient metaClient, Map<ConfigProperty, String> tablePropsToAdd) {
        StoragePath metadataTableBasePath = HoodieTableMetadata.getMetadataTableBasePath(metaClient.getBasePath());
        List<String> metadataPartitions = FSUtils.getAllPartitionPaths(context, hoodieStorage, metadataTableBasePath, false);
        List<String> validPartitionPaths = EightToSevenDowngradeHandler.deleteMetadataPartition(context, metaClient, metadataPartitions);
        tablePropsToAdd.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS, String.join((CharSequence)",", validPartitionPaths));
    }

    static List<String> deleteMetadataPartition(HoodieEngineContext context, HoodieTableMetaClient metaClient, List<String> metadataPartitions) {
        metadataPartitions.stream().filter(metadataPath -> !SUPPORTED_METADATA_PARTITION_PATHS.contains(metadataPath)).forEach(metadataPath -> HoodieTableMetadataUtil.deleteMetadataTablePartition(metaClient, context, metadataPath, true));
        return metadataPartitions.stream().filter(SUPPORTED_METADATA_PARTITION_PATHS::contains).collect(Collectors.toList());
    }

    private static Set<String> getSupportedMetadataPartitionPaths() {
        HashSet<String> supportedPartitionPaths = new HashSet<String>();
        supportedPartitionPaths.add(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath());
        supportedPartitionPaths.add(MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        supportedPartitionPaths.add(MetadataPartitionType.FILES.getPartitionPath());
        supportedPartitionPaths.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
        return supportedPartitionPaths;
    }

    private static class ArchiveEntryFlusher
    implements BiConsumer<String, GenericRecord>,
    AutoCloseable {
        private final TimelineArchiverV1 archiverV1;
        private final List<GenericRecord> buffer;
        private final int batchSize;
        private final StoragePath archivePath;
        private final HoodieTableMetaClient metaClient;

        public ArchiveEntryFlusher(HoodieTableMetaClient metaClient, TimelineArchiverV1 archiverV1, int batchSize, StoragePath archivePath) {
            this.metaClient = metaClient;
            this.archiverV1 = archiverV1;
            this.batchSize = batchSize;
            this.buffer = new ArrayList<GenericRecord>();
            this.archivePath = archivePath;
        }

        @Override
        public void accept(String s, GenericRecord archiveEntry) {
            if (this.buffer.size() >= this.batchSize) {
                this.archiverV1.flushArchiveEntries(new ArrayList<GenericRecord>(this.buffer), this.archivePath);
                this.buffer.clear();
            } else {
                try {
                    HoodieArchivedMetaEntry legacyArchiveEntry = MetadataConversionUtils.createMetaWrapper(this.metaClient, archiveEntry);
                    this.buffer.add((GenericRecord)legacyArchiveEntry);
                }
                catch (IOException e) {
                    throw new HoodieException("Convert lsm archive entry to legacy error", e);
                }
            }
        }

        @Override
        public void close() {
            if (!this.buffer.isEmpty()) {
                this.archiverV1.flushArchiveEntries(new ArrayList<GenericRecord>(this.buffer), this.archivePath);
                this.buffer.clear();
            }
        }
    }
}

