/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.dto.ClusteringOpDTO;
import org.apache.hudi.common.table.timeline.dto.CompactionOpDTO;
import org.apache.hudi.common.table.timeline.dto.DTOUtils;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.Handler;

public class FileSliceHandler
extends Handler {
    public FileSliceHandler(StorageConfiguration<?> conf, TimelineService.Config timelineServiceConfig, HoodieStorage storage2, FileSystemViewManager viewManager) throws IOException {
        super(conf, timelineServiceConfig, storage2, viewManager);
    }

    public List<FileSliceDTO> getAllFileSlices(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getAllFileSlices(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSliceInRange(String basePath, List<String> instantsToReturn) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSliceInRange(instantsToReturn).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestMergedFileSlicesBeforeOrOn(String basePath, String partitionPath, String maxInstantTime) {
        return this.viewManager.getFileSystemView(basePath).getLatestMergedFileSlicesBeforeOrOn(partitionPath, maxInstantTime).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlicesBeforeOrOn(String basePath, String partitionPath, String maxInstantTime, boolean includeFileSlicesInPendingCompaction) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlicesBeforeOrOn(partitionPath, maxInstantTime, includeFileSlicesInPendingCompaction).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public Map<String, List<FileSliceDTO>> getAllLatestFileSlicesBeforeOrOn(String basePath, String maxInstantTime) {
        return this.viewManager.getFileSystemView(basePath).getAllLatestFileSlicesBeforeOrOn(maxInstantTime).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Stream)entry.getValue()).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList())));
    }

    public List<FileSliceDTO> getLatestUnCompactedFileSlices(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestUnCompactedFileSlices(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlices(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlices(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlicesIncludingInflight(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlicesIncludingInflight(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlicesStateless(String basePath, String partitionPath) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlicesStateless(partitionPath).map(FileSliceDTO::fromFileSlice).collect(Collectors.toList());
    }

    public List<FileSliceDTO> getLatestFileSlice(String basePath, String partitionPath, String fileId) {
        return this.viewManager.getFileSystemView(basePath).getLatestFileSlice(partitionPath, fileId).map(FileSliceDTO::fromFileSlice).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList());
    }

    public List<CompactionOpDTO> getPendingCompactionOperations(String basePath) {
        return this.viewManager.getFileSystemView(basePath).getPendingCompactionOperations().map(instantOp -> CompactionOpDTO.fromCompactionOperation((String)instantOp.getKey(), (CompactionOperation)instantOp.getValue())).collect(Collectors.toList());
    }

    public List<CompactionOpDTO> getPendingLogCompactionOperations(String basePath) {
        return this.viewManager.getFileSystemView(basePath).getPendingLogCompactionOperations().map(instantOp -> CompactionOpDTO.fromCompactionOperation((String)instantOp.getKey(), (CompactionOperation)instantOp.getValue())).collect(Collectors.toList());
    }

    public List<FileGroupDTO> getAllFileGroups(String basePath, String partitionPath) {
        List<HoodieFileGroup> fileGroups = this.viewManager.getFileSystemView(basePath).getAllFileGroups(partitionPath).collect(Collectors.toList());
        return DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
    }

    public List<FileGroupDTO> getAllFileGroupsStateless(String basePath, String partitionPath) {
        List<HoodieFileGroup> fileGroups = this.viewManager.getFileSystemView(basePath).getAllFileGroupsStateless(partitionPath).collect(Collectors.toList());
        return DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
    }

    public List<FileGroupDTO> getReplacedFileGroupsBeforeOrOn(String basePath, String maxCommitTime, String partitionPath) {
        List<HoodieFileGroup> fileGroups = this.viewManager.getFileSystemView(basePath).getReplacedFileGroupsBeforeOrOn(maxCommitTime, partitionPath).collect(Collectors.toList());
        return DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
    }

    public List<FileGroupDTO> getReplacedFileGroupsBefore(String basePath, String maxCommitTime, String partitionPath) {
        List<HoodieFileGroup> fileGroups = this.viewManager.getFileSystemView(basePath).getReplacedFileGroupsBefore(maxCommitTime, partitionPath).collect(Collectors.toList());
        return DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
    }

    public List<FileGroupDTO> getReplacedFileGroupsAfterOrOn(String basePath, String minCommitTime, String partitionPath) {
        List<HoodieFileGroup> fileGroups = this.viewManager.getFileSystemView(basePath).getReplacedFileGroupsAfterOrOn(minCommitTime, partitionPath).collect(Collectors.toList());
        return DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
    }

    public List<FileGroupDTO> getAllReplacedFileGroups(String basePath, String partitionPath) {
        List<HoodieFileGroup> fileGroups = this.viewManager.getFileSystemView(basePath).getAllReplacedFileGroups(partitionPath).collect(Collectors.toList());
        return DTOUtils.fileGroupDTOsfromFileGroups(fileGroups);
    }

    public List<ClusteringOpDTO> getFileGroupsInPendingClustering(String basePath) {
        return this.viewManager.getFileSystemView(basePath).getFileGroupsInPendingClustering().map(fgInstant -> ClusteringOpDTO.fromClusteringOp((HoodieFileGroupId)fgInstant.getLeft(), (HoodieInstant)fgInstant.getRight())).collect(Collectors.toList());
    }

    public boolean refreshTable(String basePath) {
        this.viewManager.clearFileSystemView(basePath);
        return true;
    }

    public boolean loadAllPartitions(String basePath) {
        this.viewManager.getFileSystemView(basePath).loadAllPartitions();
        return true;
    }

    public boolean loadPartitions(String basePath, List<String> partitionPaths) {
        this.viewManager.getFileSystemView(basePath).loadPartitions(partitionPaths);
        return true;
    }
}

