/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.checkpointing;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.utilities.checkpointing.InitialCheckPointProvider;

public class InitialCheckpointFromAnotherHoodieTimelineProvider
extends InitialCheckPointProvider {
    private HoodieTableMetaClient anotherDsHoodieMetaClient;

    public InitialCheckpointFromAnotherHoodieTimelineProvider(TypedProperties props) {
        super(props);
    }

    @Override
    public void init(Configuration config) throws HoodieException {
        super.init(config);
        this.anotherDsHoodieMetaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy(config)).setBasePath(this.path.toString()).build();
    }

    @Override
    public String getCheckpoint() throws HoodieException {
        return this.anotherDsHoodieMetaClient.getCommitsTimeline().filterCompletedInstants().getReverseOrderedInstants().map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = this.anotherDsHoodieMetaClient.getCommitMetadataSerDe().deserialize((HoodieInstant)instant, this.anotherDsHoodieMetaClient.getActiveTimeline().getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
                return commitMetadata.getMetadata("deltastreamer.checkpoint.key");
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().get();
    }
}

